/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public class JSFFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJSFFacetInstallDataModelProperties {
    private String errorMessage;

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME");
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        names.add("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR");
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES");
        names.add("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
        names.add("IJSFFacetInstallDataModelProperties.DEFAULT_IMPLEMENTATION_LIBRARY");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME")) {
            return IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.UNKNOWN;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION")) {
            if (JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry() == null) {
                return null;
            }
            return this.getDefaultImplementationLibrary();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return "/WEB-INF/faces-config.xml";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return "Faces Servlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME")) {
            return "javax.faces.webapp.FacesServlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS")) {
            return new String[]{"/faces/*"};
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.jsf";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR")) {
            return "WebContent";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) {
            return new JSFLibraryInternalReference[0];
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES")) {
            return this.getDefaultJSFImplementationLibraries();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.DEFAULT_IMPLEMENTATION_LIBRARY")) {
            return this.getDefaultImplementationLibrary();
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        this.errorMessage = null;
        if (name.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME")) {
            if (this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.UNKNOWN) {
                return this.createErrorStatus(Messages.JSFFacetInstallDataModelProvider_INITIAL_VALIDATION_IMPL_TYPE);
            }
        } else if (name.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION")) {
            if (this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.USER_SPECIFIED) {
                JSFLibraryInternalReference lib = (JSFLibraryInternalReference)this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
                IStatus status = this.validateImpl(lib.getLibrary());
                if (!OK_STATUS.equals(status)) {
                    return status;
                }
                return this.validateClasspath();
            }
        } else {
            if (name.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
                return this.validateConfigLocation(this.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
            }
            if (name.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
                return this.validateServletName(this.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME"));
            }
            if (name.equals("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) {
                return this.validateClasspath();
            }
        }
        return super.validate(name);
    }

    private IStatus createErrorStatus(String msg) {
        return new Status(4, "org.eclipse.jst.jsf.core", msg);
    }

    private IStatus validateServletName(String servletName) {
        if (servletName == null || servletName.trim().length() == 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateServletName;
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateImpl(JSFLibrary impl) {
        if (impl == null) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateJSFImpl;
        }
        if (this.errorMessage != null) {
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateConfigLocation(String text) {
        if (text == null || text.trim().equals("")) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileEmpty;
            return this.createErrorStatus(this.errorMessage);
        }
        text = text.trim();
        if (this.getProjectPath() == null) {
            return OK_STATUS;
        }
        IPath fullPath = this.getProjectPath().append(text);
        Path passedPath = new Path(text);
        if (!fullPath.isValidPath(text)) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFilePath;
            return this.createErrorStatus(this.errorMessage);
        }
        if (text.toLowerCase().lastIndexOf(".xml") != text.length() - 4) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileXML;
            return this.createErrorStatus(this.errorMessage);
        }
        if (text.lastIndexOf("\\") >= 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileSlashes;
            return this.createErrorStatus(this.errorMessage);
        }
        if (passedPath.getDevice() != null) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative1, (Object)this.getWebContentFolderName());
            return this.createErrorStatus(this.errorMessage);
        }
        IPath webContentFolder = this.getWebContentFolder();
        IPath setPath = webContentFolder.append((IPath)passedPath);
        if (!this.getWebContentFolder().isPrefixOf(setPath)) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative2, (Object)this.getWebContentFolderName());
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateClasspath() {
        JSFLibraryInternalReference[] compLibs;
        HashSet<String> jars = new HashSet<String>();
        if (this.doesProjectExist()) {
            try {
                IClasspathEntry[] entries = this.getJavaProject().getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1) {
                        jars.add(entry.getPath().makeAbsolute().toString());
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Error searching class path");
            }
        }
        IStatus status = null;
        JSFLibraryInternalReference ref = null;
        if (this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.USER_SPECIFIED) {
            ref = (JSFLibraryInternalReference)this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
            if (ref != null) {
                status = this.checkForDupeArchiveFiles(jars, ((JSFLibraryInternalReference)this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION")).getLibrary());
                if (!OK_STATUS.equals(status)) {
                    return status;
                }
            } else {
                return this.createErrorStatus(Messages.JSFFacetInstallDataModelProvider_ClientImplValidationMsg);
            }
        }
        if ((compLibs = (JSFLibraryInternalReference[])this.getProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) != null) {
            int i = 0;
            while (i < compLibs.length) {
                JSFLibrary lib = compLibs[i].getLibrary();
                status = this.checkForDupeArchiveFiles(jars, lib);
                if (!OK_STATUS.equals(status)) {
                    return status;
                }
                ++i;
            }
        }
        return OK_STATUS;
    }

    private IJavaProject getJavaProject() {
        IProject proj = this.getProject();
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    private IProject getProject() {
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    private boolean doesProjectExist() {
        IProject project = this.getProject();
        return project != null && project.exists();
    }

    private IStatus checkForDupeArchiveFiles(Set jars, JSFLibrary aJSFLib) {
        if (aJSFLib == null) {
            return OK_STATUS;
        }
        for (ArchiveFile jar : aJSFLib.getArchiveFiles()) {
            if (jars.contains(jar.getResolvedSourceLocation())) {
                return this.createErrorStatus(NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_DupeJarValidation, (Object)jar.getResolvedSourceLocation()));
            }
            jars.add(jar.getResolvedSourceLocation());
        }
        return OK_STATUS;
    }

    private IPath getProjectPath() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (project.exists()) {
            return project.getLocation();
        }
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IFacetedProjectWorkingCopy projModel = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (projModel.getProjectLocation() != null) {
            return projModel.getProjectLocation().append(projName);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(projName);
    }

    private IPath getWebContentFolder() {
        IPath webContentPath = null;
        String projName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        String webFolder = this.getWebContentFolderName();
        if (proj.exists()) {
            webContentPath = ComponentCore.createComponent((IProject)proj).getRootFolder().getUnderlyingFolder().getRawLocation();
        } else {
            if (webFolder == null) {
                return proj.getFullPath();
            }
            webContentPath = proj.getFullPath().append(webFolder);
        }
        return webContentPath;
    }

    private String getWebContentFolderName() {
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (project.exists()) {
            IPath webContentPath = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getProjectRelativePath();
            return webContentPath.toString();
        }
        IFacetedProjectWorkingCopy projWC = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        Set pfas = projWC.getProjectFacetActions();
        for (IFacetedProject.Action action : pfas) {
            if (!action.getProjectFacetVersion().getProjectFacet().getId().equals("jst.web")) continue;
            IDataModel webFacet = (IDataModel)action.getConfig();
            return webFacet.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        }
        return null;
    }

    private List getDefaultJSFImplementationLibraries() {
        JSFLibrary jsfLib;
        ArrayList<JSFLibraryInternalReference> list = new ArrayList<JSFLibraryInternalReference>();
        if (JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry() != null && (jsfLib = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation()) != null) {
            JSFLibraryInternalReference prjJSFLib = new JSFLibraryInternalReference(jsfLib, true, true);
            list.add(prjJSFLib);
        }
        return list;
    }

    private JSFLibraryInternalReference getDefaultImplementationLibrary() {
        if (JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry() != null) {
            JSFLibrary jsfLib = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation();
            return new JSFLibraryInternalReference(jsfLib, true, true);
        }
        return null;
    }
}

