/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ClasspathHelper {
    private static final Object SYSTEM_OWNER = new Object();

    private ClasspathHelper() {
    }

    public static boolean addClasspathEntries(IProject project, IProjectFacetVersion fv) throws CoreException {
        IClasspathProvider cpprov;
        List<IClasspathEntry> cpentries;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        IRuntime runtime = fproj.getPrimaryRuntime();
        if (runtime != null && (cpentries = (cpprov = (IClasspathProvider)runtime.getAdapter(IClasspathProvider.class)).getClasspathEntries(fv)) != null) {
            ClasspathHelper.addClasspathEntries(project, fv, cpentries);
            return true;
        }
        return false;
    }

    public static void addClasspathEntries(IProject project, IProjectFacetVersion fv, List cpentries) throws CoreException {
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            List cp = ClasspathHelper.getClasspath(jproj);
            boolean cpchanged = false;
            Map prefs = ClasspathHelper.readPreferences(project);
            for (IClasspathEntry cpentry : cpentries) {
                IPath path = cpentry.getPath();
                boolean contains = cp.contains(cpentry);
                HashSet<IProjectFacetVersion> owners = (HashSet<IProjectFacetVersion>)prefs.get(path);
                if (owners == null) {
                    owners = new HashSet<IProjectFacetVersion>();
                    if (contains) {
                        owners.add((IProjectFacetVersion)SYSTEM_OWNER);
                    }
                    prefs.put(path, owners);
                }
                owners.add(fv);
                if (contains) continue;
                cp.add(cpentry);
                cpchanged = true;
            }
            if (cpchanged) {
                ClasspathHelper.setClasspath(jproj, cp);
            }
            ClasspathHelper.writePreferences(project, prefs);
        }
        catch (BackingStoreException e) {
            Status st = new Status(4, "org.eclipse.jst.common.project.facet.core", 0, Resources.failedWritingPreferences, (Throwable)e);
            throw new CoreException((IStatus)st);
        }
    }

    public static void removeClasspathEntries(IProject project, IProjectFacetVersion fv) throws CoreException {
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            List cp = ClasspathHelper.getClasspath(jproj);
            IProjectFacet facet = fv.getProjectFacet();
            boolean cpchanged = false;
            Map prefs = ClasspathHelper.readPreferences(project);
            if (prefs.isEmpty()) {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
                IRuntime runtime = fproj.getPrimaryRuntime();
                ClasspathHelper.removeOnlyCPEntries(project, fv, jproj, cp, runtime);
            }
            Iterator itr1 = prefs.entrySet().iterator();
            block2: while (itr1.hasNext()) {
                Map.Entry entry = itr1.next();
                IPath path = (IPath)entry.getKey();
                Set owners = (Set)entry.getValue();
                IProjectFacetVersion foundVersion = null;
                boolean found = false;
                for (IProjectFacetVersion anOwner : owners) {
                    if (!anOwner.getProjectFacet().equals(facet)) continue;
                    foundVersion = anOwner;
                    found = true;
                    break;
                }
                if (!found) continue;
                owners.remove(foundVersion);
                if (owners.size() != 0) continue;
                itr1.remove();
                Iterator itr2 = cp.iterator();
                while (itr2.hasNext()) {
                    IClasspathEntry cpentry = (IClasspathEntry)itr2.next();
                    if (!cpentry.getPath().equals((Object)path)) continue;
                    itr2.remove();
                    cpchanged = true;
                    continue block2;
                }
            }
            if (cpchanged) {
                ClasspathHelper.setClasspath(jproj, cp);
            }
            ClasspathHelper.writePreferences(project, prefs);
        }
        catch (BackingStoreException e) {
            Status st = new Status(4, "org.eclipse.jst.common.project.facet.core", 0, Resources.failedWritingPreferences, (Throwable)e);
            throw new CoreException((IStatus)st);
        }
    }

    private static void removeOnlyCPEntries(IProject project, IProjectFacetVersion fv, IJavaProject jproj, List cp, IRuntime oldRuntime) throws CoreException {
        IRuntime runtime;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        IRuntime iRuntime = runtime = oldRuntime != null ? oldRuntime : fproj.getPrimaryRuntime();
        if (runtime != null) {
            IClasspathProvider cpprov = (IClasspathProvider)runtime.getAdapter(IClasspathProvider.class);
            List<IClasspathEntry> cpentries = cpprov.getClasspathEntries(fv);
            boolean realCPChanged = false;
            block0: for (IClasspathEntry cpentry : cpentries) {
                IPath path = cpentry.getPath();
                boolean contains = cp.contains(cpentry);
                if (!contains) continue;
                Iterator itr2 = cp.iterator();
                while (itr2.hasNext()) {
                    IClasspathEntry realEntry = (IClasspathEntry)itr2.next();
                    if (!realEntry.getPath().equals((Object)path)) continue;
                    itr2.remove();
                    realCPChanged = true;
                    continue block0;
                }
            }
            if (realCPChanged) {
                ClasspathHelper.setClasspath(jproj, cp);
            }
        }
    }

    private static List getClasspath(IJavaProject jproj) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            list.add(cp[i]);
            ++i;
        }
        return list;
    }

    private static void setClasspath(IJavaProject jproj, List cp) throws CoreException {
        IClasspathEntry[] newcp = cp.toArray(new IClasspathEntry[cp.size()]);
        jproj.setRawClasspath(newcp, null);
    }

    private static Map readPreferences(IProject project) throws BackingStoreException {
        Preferences root = ClasspathHelper.getPreferencesNode(project);
        HashMap result = new HashMap();
        String[] keys = root.childrenNames();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Preferences node = root.node(key);
            String owners = node.get("owners", null);
            String[] split = owners.split(";");
            HashSet<Object> set = new HashSet<Object>();
            int j = 0;
            while (j < split.length) {
                String segment = split[j];
                if (segment.equals("#system#")) {
                    set.add(SYSTEM_OWNER);
                } else {
                    IProjectFacetVersion fv = ClasspathHelper.parseFeatureVersion(segment);
                    set.add(fv);
                }
                ++j;
            }
            result.put(ClasspathHelper.decode(key), set);
            ++i;
        }
        return result;
    }

    private static void writePreferences(IProject project, Map prefs) throws BackingStoreException {
        Preferences root = ClasspathHelper.getPreferencesNode(project);
        String[] children = root.childrenNames();
        int i = 0;
        while (i < children.length) {
            root.node(children[i]).removeNode();
            ++i;
        }
        for (Map.Entry entry : prefs.entrySet()) {
            IPath path = (IPath)entry.getKey();
            Set owners = (Set)entry.getValue();
            StringBuffer buf = new StringBuffer();
            for (Object owner : owners) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                if (owner == SYSTEM_OWNER) {
                    buf.append("#system#");
                    continue;
                }
                IProjectFacetVersion fv = (IProjectFacetVersion)owner;
                buf.append(fv.getProjectFacet().getId());
                buf.append(':');
                buf.append(fv.getVersionString());
            }
            Preferences node = root.node(ClasspathHelper.encode(path));
            node.put("owners", buf.toString());
        }
        root.flush();
    }

    private static Preferences getPreferencesNode(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
        return pluginRoot.node("classpath.helper");
    }

    private static IProjectFacetVersion parseFeatureVersion(String str) {
        int colon = str.indexOf(58);
        String id = str.substring(0, colon);
        String ver = str.substring(colon + 1);
        return ProjectFacetsManager.getProjectFacet((String)id).getVersion(ver);
    }

    private static String encode(IPath path) {
        return path.toString().replaceAll("/", "::");
    }

    private static IPath decode(String path) {
        return new Path(path.replaceAll("::", "/"));
    }

    private static final class Resources
    extends NLS {
        public static String failedWritingPreferences;

        static {
            Resources.initializeMessages((String)ClasspathHelper.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

