/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class WSDLSelectionOutputCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private IProject project;
    private String componentName;
    private boolean testService;

    public boolean getTestService() {
        return this.testService;
    }

    public void setTestService(boolean testService) {
        this.testService = testService;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public WebServicesParser getWebServicesParser() {
        if (this.webServicesParser != null) {
            return this.webServicesParser;
        }
        return new WebServicesParserExt();
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        if (this.wsdlURI != null && this.getWebServicesParser().getWSDLDefinition(this.wsdlURI) != null) {
            IStatus status = Status.OK_STATUS;
            Map services = this.getWebServicesParser().getWSDLDefinition(this.wsdlURI).getServices();
            if (services.isEmpty() && this.testService) {
                this.testService = false;
                status = StatusUtils.warningStatus((String)ConsumptionUIMessages.MSG_WARNING_NO_SERVICE_ELEMENT);
                try {
                    env.getStatusHandler().report(status);
                }
                catch (Exception exception) {
                    status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_WARNING_NO_SERVICE_ELEMENT);
                }
            }
            return status;
        }
        IStatus status = StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_SELECTION_MUST_BE_WSDL);
        if (env != null) {
            env.getStatusHandler().reportError(status);
        }
        return status;
    }
}

