/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.EarFacetRuntimeHandler;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class AddComponentToEnterpriseApplicationOp
extends CreateReferenceComponentsOp {
    public static final String metaInfFolderDeployPath = "/";

    public AddComponentToEnterpriseApplicationOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor != null) {
            monitor.beginTask("", 3);
        }
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            IStatus status = this.validateEditEAR();
            if (status.isOK()) {
                status = super.execute(AddComponentToEnterpriseApplicationOp.submon(monitor, 1), info);
                if (!status.isOK()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.updateEARDD(AddComponentToEnterpriseApplicationOp.submon(monitor, 1));
                this.updateModuleRuntimes(AddComponentToEnterpriseApplicationOp.submon(monitor, 1));
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    protected String getArchiveName(IVirtualComponent comp) {
        boolean useArchiveURI = true;
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)comp.getProject());
        }
        catch (CoreException coreException) {
            useArchiveURI = false;
        }
        if (useArchiveURI && facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)"jst.utility")) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
            boolean bl = useArchiveURI = projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        if (useArchiveURI) {
            return super.getArchiveName(comp);
        }
        return "";
    }

    protected void updateEARDD(IProgressMonitor monitor) {
        StructureEdit se = null;
        try {
            try {
                IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                final IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(sourceComp.getProject());
                IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                final IProject earpj = ear.getProject();
                se = StructureEdit.getStructureEditForWrite((IProject)sourceComp.getProject());
                if (earModel != null) {
                    List list = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    final Map map = (Map)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
                    if (list != null && list.size() > 0) {
                        int i = 0;
                        while (i < list.size()) {
                            StructureEdit compse = null;
                            final IVirtualComponent wc = (IVirtualComponent)list.get(i);
                            boolean linkedToEAR = true;
                            try {
                                if (wc.isBinary()) {
                                    linkedToEAR = ((J2EEModuleVirtualArchiveComponent)wc).isLinkedToEAR();
                                    ((J2EEModuleVirtualArchiveComponent)wc).setLinkedToEAR(false);
                                }
                                WorkbenchComponent earwc = se.getComponent();
                                try {
                                    compse = StructureEdit.getStructureEditForWrite((IProject)wc.getProject());
                                    WorkbenchComponent refwc = compse.getComponent();
                                    final ReferencedComponent ref = se.findReferencedComponent(earwc, refwc);
                                    earModel.modify(new Runnable(){

                                        public void run() {
                                            ICommonApplication application = (ICommonApplication)earModel.getModelObject();
                                            if (application != null) {
                                                ICommonModule mod = AddComponentToEnterpriseApplicationOp.this.addModule(application, wc, (String)map.get(wc));
                                                if (ref != null) {
                                                    ref.setDependentObject((EObject)mod);
                                                }
                                                if (JavaEEProjectUtilities.isStaticWebProject(wc.getProject()) || JavaEEProjectUtilities.isDynamicWebComponent(wc)) {
                                                    AddComponentToEnterpriseApplicationOp.this.updateContextRoot(earpj, wc, mod);
                                                }
                                            }
                                        }
                                    }, null);
                                }
                                finally {
                                    if (compse != null) {
                                        compse.saveIfNecessary(monitor);
                                        compse.dispose();
                                    }
                                }
                            }
                            finally {
                                if (wc.isBinary()) {
                                    ((J2EEModuleVirtualArchiveComponent)wc).setLinkedToEAR(linkedToEAR);
                                }
                            }
                            ++i;
                        }
                    }
                }
                se.saveIfNecessary(monitor);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (se != null) {
                    se.dispose();
                }
            }
        }
        finally {
            if (se != null) {
                se.dispose();
            }
        }
    }

    private void updateContextRoot(IProject earpj, IVirtualComponent wc, ICommonModule mod) {
        boolean useNewModel = JavaEEProjectUtilities.getJ2EEDDProjectVersion(earpj).equals("5.0");
        String contextroot = ComponentUtilities.getServerContextRoot((IProject)wc.getProject());
        if (contextroot == null) {
            contextroot = wc.getProject().getName();
        }
        if (useNewModel) {
            if (mod instanceof Module) {
                Module cfr_ignored_0 = (Module)mod;
                Web web = ((Module)mod).getWeb();
                web.setContextRoot(contextroot);
            }
        } else if ((JavaEEProjectUtilities.isStaticWebProject(wc.getProject()) || JavaEEProjectUtilities.isDynamicWebComponent(wc)) && mod instanceof WebModule) {
            ((WebModule)mod).setContextRoot(contextroot);
        }
    }

    protected ICommonModule createNewModule(IVirtualComponent wc, String name) {
        ICommonModule newModule = null;
        IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        IProject earpj = ear.getProject();
        boolean useNewModel = JavaEEProjectUtilities.getJ2EEDDProjectVersion(earpj).equals("5.0");
        if (JavaEEProjectUtilities.isDynamicWebComponent(wc)) {
            if (useNewModel) {
                Web web = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createWeb();
                web.setWebUri(name);
                Module webModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                webModule.setWeb(web);
                newModule = (ICommonModule)webModule;
            } else {
                WebModule webModule = ApplicationFactory.eINSTANCE.createWebModule();
                webModule.setUri(name);
                newModule = (ICommonModule)webModule;
            }
            this.updateContextRoot(earpj, wc, newModule);
            return newModule;
        }
        if (JavaEEProjectUtilities.isEJBComponent(wc)) {
            if (useNewModel) {
                Module ejbModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                ejbModule.setEjb(name);
                newModule = (ICommonModule)ejbModule;
            } else {
                EjbModule ejbModule = ApplicationFactory.eINSTANCE.createEjbModule();
                ejbModule.setUri(name);
                newModule = (ICommonModule)ejbModule;
            }
            return newModule;
        }
        if (JavaEEProjectUtilities.isApplicationClientComponent(wc)) {
            if (useNewModel) {
                Module appClientModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                appClientModule.setJava(name);
                newModule = (ICommonModule)appClientModule;
            } else {
                JavaClientModule appClientModule = ApplicationFactory.eINSTANCE.createJavaClientModule();
                appClientModule.setUri(name);
                newModule = (ICommonModule)appClientModule;
            }
            return newModule;
        }
        if (JavaEEProjectUtilities.isJCAComponent(wc)) {
            if (useNewModel) {
                Module j2cModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                j2cModule.setConnector(name);
                newModule = (ICommonModule)j2cModule;
            } else {
                ConnectorModule j2cModule = ApplicationFactory.eINSTANCE.createConnectorModule();
                j2cModule.setUri(name);
                newModule = (ICommonModule)j2cModule;
            }
            return newModule;
        }
        return null;
    }

    protected ICommonModule addModule(ICommonApplication application, IVirtualComponent wc, String name) {
        ICommonApplication dd = application;
        ICommonModule existingModule = dd.getFirstEARModule(name);
        if (existingModule == null && (existingModule = this.createNewModule(wc, name)) != null) {
            existingModule.setUri(name);
            dd.getEARModules().add(existingModule);
        }
        return existingModule;
    }

    private void updateModuleRuntimes(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 10);
        }
        try {
            try {
                IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                IProject earpj = ear.getProject();
                List moduleComponents = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                HashSet<IProject> moduleProjects = new HashSet<IProject>();
                Iterator itr = moduleComponents.iterator();
                while (itr.hasNext()) {
                    moduleProjects.add(((IVirtualComponent)itr.next()).getProject());
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                EarFacetRuntimeHandler.updateModuleProjectRuntime(earpj, moduleProjects, AddComponentToEnterpriseApplicationOp.submon(monitor, 9));
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected IStatus validateEditEAR() {
        IStatus status = OK_STATUS;
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        IProject project = sourceComp.getProject();
        IModelProvider provider = ModelProviderManager.getModelProvider(project);
        status = provider.validateEdit(null, null);
        return status;
    }

    protected IStatus validateEdit() {
        return this.validateEditEAR();
    }
}

