/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.binding.http.internal.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.http.HTTPAddress;
import org.eclipse.wst.wsdl.binding.http.HTTPBinding;
import org.eclipse.wst.wsdl.binding.http.HTTPFactory;
import org.eclipse.wst.wsdl.binding.http.HTTPOperation;
import org.eclipse.wst.wsdl.binding.http.HTTPUrlEncoded;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;
import org.w3c.dom.Element;

public class HTTPContentGenerator
implements ContentGenerator {
    public static final int VERB_POST = 0;
    public static final int VERB_GET = 1;
    public static final int VERB_NOT_SET = -1;
    private int verbOption = -1;
    protected String addressLocation = "http://www.example.org/";
    protected static final String[] requiredNamespaces = new String[]{"http://schemas.xmlsoap.org/wsdl/mime/", "http://schemas.xmlsoap.org/wsdl/http/"};

    public void setVerb(int verb) {
        this.verbOption = verb;
    }

    public void setAddressLocation(String addressLocation) {
        this.addressLocation = addressLocation;
    }

    public String[] getRequiredNamespaces() {
        return requiredNamespaces;
    }

    public String getPreferredNamespacePrefix(String namespace) {
        if (namespace.equals("http://schemas.xmlsoap.org/wsdl/mime/")) {
            return "mime";
        }
        if (namespace.equals("http://schemas.xmlsoap.org/wsdl/http/")) {
            return "http";
        }
        return "";
    }

    public void generatePortContent(Port port) {
        ArrayList removeList = new ArrayList(port.getEExtensibilityElements());
        this.removeExtensebilityElements((List)port.getEExtensibilityElements(), removeList);
        HTTPAddress httpAddress = HTTPFactory.eINSTANCE.createHTTPAddress();
        httpAddress.setLocationURI(this.addressLocation);
        port.addExtensibilityElement(httpAddress);
    }

    public void generateBindingContent(Binding binding, PortType portType) {
        ArrayList removeList = new ArrayList(binding.getEExtensibilityElements());
        this.removeExtensebilityElements((List)binding.getEExtensibilityElements(), removeList);
        HTTPBinding httpBinding = HTTPFactory.eINSTANCE.createHTTPBinding();
        httpBinding.setVerb(this.getVerbOption(binding) == 0 ? "POST" : "GET");
        binding.addExtensibilityElement(httpBinding);
    }

    public void generateBindingOperationContent(BindingOperation bindingOperation, Operation operation) {
        ArrayList removeList = new ArrayList(bindingOperation.getEExtensibilityElements());
        this.removeExtensebilityElements((List)bindingOperation.getEExtensibilityElements(), removeList);
        HTTPOperation httpOperation = HTTPFactory.eINSTANCE.createHTTPOperation();
        httpOperation.setLocationURI("/" + operation.getName());
        bindingOperation.addExtensibilityElement(httpOperation);
    }

    public void generateBindingInputContent(BindingInput bindingInput, Input input) {
        ArrayList removeList = new ArrayList(bindingInput.getEExtensibilityElements());
        int option = this.getVerbOption(bindingInput);
        this.removeExtensebilityElements((List)bindingInput.getEExtensibilityElements(), removeList);
        if (option == 0) {
            Element element = this.createElement(bindingInput.getElement(), "mime", "content");
            element.setAttribute("type", "application/x-www-form-urlencoded");
        } else {
            HTTPUrlEncoded urlEncoded = HTTPFactory.eINSTANCE.createHTTPUrlEncoded();
            bindingInput.addExtensibilityElement(urlEncoded);
        }
    }

    public void generateBindingOutputContent(BindingOutput bindingOutput, Output output) {
        ArrayList removeList = new ArrayList(bindingOutput.getEExtensibilityElements());
        this.getVerbOption(bindingOutput);
        this.removeExtensebilityElements((List)bindingOutput.getEExtensibilityElements(), removeList);
        Element bindingOutputElement = bindingOutput.getElement();
        Element element = this.createElement(bindingOutputElement, "mime", "content");
        element.setAttribute("type", "text/xml");
    }

    public void generateBindingFaultContent(BindingFault bindingFault, Fault fault) {
    }

    protected Element createElement(Element parentElement, String prefix, String elementName) {
        String name = prefix != null ? String.valueOf(prefix) + ":" + elementName : elementName;
        Element result = parentElement.getOwnerDocument().createElement(name);
        parentElement.insertBefore(result, parentElement.getFirstChild());
        return result;
    }

    private int getVerbOption(Object genericBindingObject) {
        Binding binding;
        if (this.verbOption == -1 && genericBindingObject != null && (binding = this.getBindingObject(genericBindingObject)) != null) {
            EList list = binding.getEExtensibilityElements();
            Iterator valuesIt = this.getExtensibilityElementAttributeValue((List)list, "verb").iterator();
            while (valuesIt.hasNext()) {
                String verb = (String)valuesIt.next();
                if (verb.equals("POST")) {
                    this.verbOption = 0;
                } else if (verb.equals("GET")) {
                    this.verbOption = 1;
                }
                if (this.verbOption != -1) break;
            }
        }
        if (this.verbOption == -1) {
            this.verbOption = 1;
        }
        return this.verbOption;
    }

    private List getExtensibilityElementAttributeValue(List eeList, String attributeKey) {
        ArrayList<String> values = new ArrayList<String>();
        Iterator eeElementsIt = eeList.iterator();
        while (eeElementsIt.hasNext()) {
            ExtensibilityElement eeElement = (ExtensibilityElement)eeElementsIt.next();
            String attributeValue = eeElement.getElement().getAttribute(attributeKey);
            if (attributeValue == null || attributeValue.equals("")) continue;
            values.add(attributeValue);
        }
        return values;
    }

    private Binding getBindingObject(Object genericBindingObject) {
        Object parent = genericBindingObject;
        int index = 0;
        while (parent != null && index < 5) {
            if ((parent = this.getGenericBindingObjectParent(parent)) instanceof Binding) break;
            ++index;
        }
        return parent instanceof Binding ? (Binding)parent : null;
    }

    private Object getGenericBindingObjectParent(Object genericBindingObject) {
        WSDLElement parent = null;
        if (genericBindingObject != null) {
            if (genericBindingObject instanceof BindingOperation) {
                parent = ((BindingOperation)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingInput) {
                parent = ((BindingInput)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingOutput) {
                parent = ((BindingOutput)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingFault) {
                parent = ((BindingFault)genericBindingObject).getContainer();
            }
        }
        return parent;
    }

    private void removeExtensebilityElements(List originalList, List removeList) {
        Iterator removeIt = removeList.iterator();
        while (removeIt.hasNext()) {
            originalList.remove(removeIt.next());
        }
    }

    public String getProtocol() {
        return "HTTP";
    }
}

