/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.wst.jsdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestor {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int ANNOTATIONS = 8;
    public static final int ENUMS = 16;
    public static final int VARIABLES = 32;
    public static final int PRIMITIVETYPES = 64;
    public static final int VOIDTYPE = 128;
    public static final int REF_TYPES = 30;
    public static final int REF_TYPES_AND_VAR = 62;
    public static final int ALL_TYPES = 126;
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private int fKind;
    private String fName;
    private HashSet fResult;

    public static SimilarElement[] findSimilarElement(IJavaScriptUnit cu, Name name, int kind) throws JavaScriptModelException {
        SimilarElement[] similarElementArray;
        block3: {
            int pos = name.getStartPosition();
            int nArguments = -1;
            String identifier = ASTNodes.getSimpleNameIdentifier(name);
            String returnType = null;
            IJavaScriptUnit preparedCU = null;
            try {
                pos = name.getStartPosition() + 1;
                JSdoc javadoc = (JSdoc)ASTNodes.getParent((ASTNode)name, 29);
                if (javadoc != null) {
                    cu = preparedCU = SimilarElementsRequestor.createPreparedCU(cu, javadoc, name.getStartPosition());
                }
                SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind, nArguments, returnType);
                requestor.setIgnored(1, true);
                requestor.setIgnored(3, true);
                requestor.setIgnored(4, true);
                requestor.setIgnored(7, true);
                requestor.setIgnored(8, true);
                requestor.setIgnored(10, true);
                requestor.setIgnored(6, true);
                requestor.setIgnored(2, true);
                requestor.setIgnored(5, true);
                requestor.setIgnored(10, true);
                requestor.setIgnored(10, true);
                requestor.setIgnored(11, true);
                requestor.setIgnored(12, true);
                similarElementArray = requestor.process(cu, pos);
                Object var10_11 = null;
                if (preparedCU == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var10_12 = null;
                    if (preparedCU == null) break block4;
                    preparedCU.discardWorkingCopy();
                }
                throw throwable;
            }
            preparedCU.discardWorkingCopy();
        }
        return similarElementArray;
    }

    private static IJavaScriptUnit createPreparedCU(IJavaScriptUnit cu, JSdoc comment, int wordStart) throws JavaScriptModelException {
        int startpos = comment.getStartPosition();
        boolean isTopLevel = comment.getParent().getParent() instanceof JavaScriptUnit;
        char[] content = (char[])cu.getBuffer().getCharacters().clone();
        if (isTopLevel && wordStart + 6 < content.length) {
            content[startpos++] = 105;
            content[startpos++] = 109;
            content[startpos++] = 112;
            content[startpos++] = 111;
            content[startpos++] = 114;
            content[startpos++] = 116;
        }
        if (wordStart < content.length) {
            int i = startpos;
            while (i < wordStart) {
                content[i] = 32;
                ++i;
            }
        }
        IJavaScriptUnit newCU = cu.getWorkingCopy(null);
        newCU.getBuffer().setContents(content);
        return newCU;
    }

    private SimilarElementsRequestor(String name, int kind, int nArguments, String preferredType) {
        this.fName = name;
        this.fKind = kind;
        this.fResult = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    private SimilarElement[] process(IJavaScriptUnit cu, int pos) throws JavaScriptModelException {
        try {
            cu.codeComplete(pos, (CompletionRequestor)this);
            this.processKeywords();
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            Object var3_4 = null;
            this.fResult.clear();
            return similarElementArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fResult.clear();
            throw throwable;
        }
    }

    private boolean isKind(int kind) {
        return (this.fKind & kind) != 0;
    }

    private void processKeywords() {
        String voidType;
        if (this.isKind(64)) {
            int i = 0;
            while (i < PRIM_TYPES.length) {
                if (NameMatcher.isSimilarName(this.fName, PRIM_TYPES[i])) {
                    this.addResult(new SimilarElement(64, PRIM_TYPES[i], 50));
                }
                ++i;
            }
        }
        if (this.isKind(128) && NameMatcher.isSimilarName(this.fName, voidType = "void")) {
            this.addResult(new SimilarElement(64, voidType, 50));
        }
    }

    private static final int getKind(int flags, char[] typeNameSig) {
        if (Signature.getTypeSignatureKind((char[])typeNameSig) == 3) {
            return 32;
        }
        if (Flags.isAnnotation((int)flags)) {
            return 8;
        }
        if (Flags.isInterface((int)flags)) {
            return 4;
        }
        if (Flags.isEnum((int)flags)) {
            return 16;
        }
        return 2;
    }

    private void addType(char[] typeNameSig, int flags, int relevance) {
        int kind = SimilarElementsRequestor.getKind(flags, typeNameSig);
        if (!this.isKind(kind)) {
            return;
        }
        String fullName = new String(Signature.toCharArray((char[])Signature.getTypeErasure((char[])typeNameSig)));
        if (TypeFilter.isFiltered(fullName)) {
            return;
        }
        if (NameMatcher.isSimilarName(this.fName, Signature.getSimpleName((String)fullName))) {
            this.addResult(new SimilarElement(kind, fullName, relevance));
        }
    }

    public void accept(CompletionProposal proposal) {
        if (proposal.getKind() == 9) {
            this.addType(proposal.getSignature(), proposal.getFlags(), proposal.getRelevance());
        }
    }
}

