/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class JavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage;

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        return context.getInvocationOffset();
    }

    private List addContextInformations(JavaContentAssistInvocationContext context, int offset, IProgressMonitor monitor) {
        List proposals = this.internalComputeCompletionProposals(offset, context, monitor);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>(proposals.size());
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            ICompletionProposal proposal = (ICompletionProposal)it.next();
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
            wrapper.setContextInformationPosition(offset);
            result.add(wrapper);
        }
        return result;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            int contextInformationPosition = this.guessContextInformationPosition(javaContext);
            List result = this.addContextInformations(javaContext, contextInformationPosition, monitor);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            return this.internalComputeCompletionProposals(context.getInvocationOffset(), javaContext, monitor);
        }
        return Collections.EMPTY_LIST;
    }

    private List internalComputeCompletionProposals(int offset, JavaContentAssistInvocationContext context, IProgressMonitor monitor) {
        String error;
        ArrayList<IJavaCompletionProposal> proposals;
        IJavaScriptUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return Collections.EMPTY_LIST;
        }
        ITextViewer viewer = context.getViewer();
        CompletionProposalCollector collector = this.createCollector(context);
        collector.setInvocationContext(context);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        try {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            unit.codeComplete(offset, (CompletionRequestor)collector);
        }
        catch (JavaScriptModelException x) {
            Shell shell = viewer.getTextWidget().getShell();
            if (x.isDoesNotExist() && !unit.getJavaScriptProject().isOnIncludepath((IJavaScriptElement)unit)) {
                MessageDialog.openInformation((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_accessing_title, (String)JavaTextMessages.CompletionProcessor_error_accessing_message, (IStatus)x.getStatus());
        }
        IJavaCompletionProposal[] javaProposals = collector.getJavaCompletionProposals();
        int contextInformationOffset = this.guessContextInformationPosition(context);
        if (contextInformationOffset != offset) {
            int i = 0;
            while (i < javaProposals.length) {
                if (javaProposals[i] instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal jmcp = (JavaMethodCompletionProposal)javaProposals[i];
                    jmcp.setContextInformationPosition(contextInformationOffset);
                }
                ++i;
            }
        }
        if ((proposals = new ArrayList<IJavaCompletionProposal>(Arrays.asList(javaProposals))).size() == 0 && (error = collector.getErrorMessage()).length() > 0) {
            this.fErrorMessage = error;
        }
        return proposals;
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return new String[0];
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        CompletionProposalCollector collector = new CompletionProposalCollector(context.getCompilationUnit());
        collector.setInvocationContext(context);
        return collector;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

