/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LicenseComposite
extends Composite {
    protected TaskModel taskModel;
    protected IWizardHandle wizard;
    protected Text licenseText;
    protected Button accept;
    protected Button decline;
    protected boolean accepted;

    public LicenseComposite(Composite parent, TaskModel taskModel, IWizardHandle wizard) {
        super(parent, 0);
        this.taskModel = taskModel;
        this.wizard = wizard;
        this.createControl();
    }

    protected void createControl() {
        this.setLayout(new LicenseLayout());
        this.licenseText = new Text((Composite)this, 2890);
        this.licenseText.setBackground(this.licenseText.getDisplay().getSystemColor(25));
        this.accept = new Button((Composite)this, 16);
        this.accept.setText(Messages.wizLicenseAccept);
        this.accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseComposite.this.accepted = LicenseComposite.this.accept.getSelection();
                LicenseComposite.this.taskModel.putObject("accept", (Object)new Boolean(LicenseComposite.this.accepted));
                LicenseComposite.this.wizard.update();
            }
        });
        this.decline = new Button((Composite)this, 16);
        this.decline.setText(Messages.wizLicenseDecline);
        this.updateLicense();
        Dialog.applyDialogFont((Control)this);
    }

    public void updateLicense() {
        Object acc;
        String license = (String)this.taskModel.getObject("license");
        if (license == null) {
            license = "unknown";
        }
        if ((acc = this.taskModel.getObject("accept")) == null) {
            this.accepted = false;
            this.accept.setSelection(false);
            this.decline.setSelection(false);
        }
        if ("none".equals(license)) {
            this.licenseText.setText(Messages.wizLicenseNone);
            this.accept.setEnabled(false);
            this.decline.setEnabled(false);
            this.accepted = true;
        } else if ("unknown".equals(license)) {
            this.licenseText.setText(Messages.wizLicenseNone);
            this.accept.setEnabled(true);
            this.decline.setEnabled(true);
        } else {
            this.licenseText.setText(license);
            this.accept.setEnabled(true);
            this.decline.setEnabled(true);
        }
        this.taskModel.putObject("accept", (Object)new Boolean(this.accepted));
    }

    class LicenseLayout
    extends Layout {
        private static final int INDENT = 15;
        private static final int SPACING = 5;

        LicenseLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint < 200) {
                wHint = 200;
            }
            if (hHint < 300) {
                hHint = 300;
            }
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point p1 = children[1].computeSize(-1, -1, flushCache);
            Point p2 = children[2].computeSize(-1, -1, flushCache);
            Rectangle r = composite.getClientArea();
            children[2].setBounds(r.x + 15, r.y + r.height - p2.y, r.width - 15, p2.y);
            children[1].setBounds(r.x + 15, r.y + r.height - p2.y - p1.y - 5, r.width - 15, p1.y);
            children[0].setBounds(r.x, r.y, r.width, r.height - p1.y - p2.y - 15);
        }
    }
}

