/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.wst.server.core.internal.Trace;

public class SocketUtil {
    private static final Random rand = new Random(System.currentTimeMillis());
    protected static final Object lock = new Object();
    private static Set<String> localHostCache;
    private static Set<String> notLocalHostCache;
    private static Map<String, CacheThread> threadMap;
    private static Set<InetAddress> addressCache;

    static {
        notLocalHostCache = new HashSet<String>();
        threadMap = new HashMap<String, CacheThread>();
    }

    private SocketUtil() {
    }

    public static int findUnusedPort(int low, int high) {
        if (high < low) {
            return -1;
        }
        int i = 0;
        while (i < 10) {
            int port = SocketUtil.getRandomPort(low, high);
            if (!SocketUtil.isPortInUse(port)) {
                return port;
            }
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return rand.nextInt(high - low) + low;
    }

    public static boolean isPortInUse(int port, int count) {
        boolean inUse = SocketUtil.isPortInUse(port);
        while (inUse && count > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            inUse = SocketUtil.isPortInUse(port);
            --count;
        }
        return inUse;
    }

    /*
     * Exception decompiling
     */
    public static boolean isPortInUse(int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalhost(String host) {
        boolean refreshedCache;
        boolean currentThread;
        block35: {
            if (host == null) return false;
            if (host.equals("")) {
                return false;
            }
            if ("localhost".equals(host)) return true;
            if ("127.0.0.1".equals(host)) {
                return true;
            }
            try {
                InetAddress localHostaddr = InetAddress.getLocalHost();
                if (localHostaddr.getHostName().equals(host)) return true;
                if (host.equals(localHostaddr.getCanonicalHostName())) return true;
                if (localHostaddr.getHostAddress().equals(host)) {
                    return true;
                }
            }
            catch (Exception e) {
                Trace.trace(2, "Localhost caching failure", e);
            }
            currentThread = false;
            try {
                Thread t = null;
                Object object = lock;
                synchronized (object) {
                    t = threadMap.get(host);
                }
                if (t != null && t.isAlive()) {
                    currentThread = true;
                    t.join(30L);
                }
            }
            catch (Exception e) {
                Trace.trace(2, "Localhost caching failure", e);
            }
            refreshedCache = false;
            try {
                CacheThread cacheThread;
                HashSet<InetAddress> currentAddresses = new HashSet<InetAddress>();
                currentAddresses.add(InetAddress.getLocalHost());
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                block23: while (true) {
                    if (!nis.hasMoreElements()) {
                        if (addressCache == null || !addressCache.containsAll(currentAddresses) || !currentAddresses.containsAll(addressCache)) {
                            cacheThread = null;
                            refreshedCache = true;
                            Object object = lock;
                            synchronized (object) {
                                addressCache = currentAddresses;
                                notLocalHostCache = new HashSet<String>();
                                localHostCache = new HashSet<String>(currentAddresses.size() * 3);
                                Iterator iter = currentAddresses.iterator();
                                while (true) {
                                    if (!iter.hasNext()) {
                                        cacheThread = new CacheThread(host, currentAddresses, localHostCache, notLocalHostCache, threadMap);
                                        threadMap.put(host, cacheThread);
                                        cacheThread.setDaemon(true);
                                        cacheThread.setPriority(4);
                                        cacheThread.start();
                                        break block23;
                                    }
                                    InetAddress addr = (InetAddress)iter.next();
                                    String a = addr.getHostAddress();
                                    if (a == null || localHostCache.contains(a)) continue;
                                    localHostCache.add(a);
                                }
                            }
                        }
                        break block35;
                    }
                    NetworkInterface inter = nis.nextElement();
                    Enumeration<InetAddress> ias = inter.getInetAddresses();
                    while (true) {
                        if (!ias.hasMoreElements()) continue block23;
                        currentAddresses.add(ias.nextElement());
                    }
                    break;
                }
                cacheThread.join(200L);
            }
            catch (Exception e) {
                Trace.trace(2, "Localhost caching failure", e);
            }
        }
        Object e = lock;
        synchronized (e) {
            if (localHostCache.contains(host)) {
                return true;
            }
            if (notLocalHostCache.contains(host)) {
                return false;
            }
        }
        if (refreshedCache) return false;
        if (currentThread) return false;
        try {
            CacheThread cacheThread = null;
            Object object = lock;
            synchronized (object) {
                cacheThread = new CacheThread(host, null, localHostCache, notLocalHostCache, threadMap);
                threadMap.put(host, cacheThread);
                cacheThread.setDaemon(true);
                cacheThread.setPriority(4);
                cacheThread.start();
            }
            cacheThread.join(75L);
            object = lock;
            synchronized (object) {
                if (!localHostCache.contains(host)) return false;
                return true;
            }
        }
        catch (Exception e2) {
            Trace.trace(2, "Could not find localhost", e2);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheThread
    extends Thread {
        private Set<InetAddress> currentAddresses;
        private Set<String> addressList;
        private String host;
        private Set<String> nonAddressList;
        private Map threadMap2;

        public CacheThread(String host, Set<InetAddress> currentAddresses, Set<String> addressList, Set<String> nonAddressList, Map threadMap2) {
            super("Caching localhost information");
            this.host = host;
            this.currentAddresses = currentAddresses;
            this.addressList = addressList;
            this.nonAddressList = nonAddressList;
            this.threadMap2 = threadMap2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.currentAddresses != null) {
                for (InetAddress addr : this.currentAddresses) {
                    String hostname = addr.getHostName();
                    String hostname2 = addr.getCanonicalHostName();
                    Object object2 = lock;
                    synchronized (object2) {
                        if (hostname != null && !this.addressList.contains(hostname)) {
                            this.addressList.add(hostname);
                        }
                        if (hostname2 != null && !this.addressList.contains(hostname2)) {
                            this.addressList.add(hostname2);
                        }
                    }
                }
            }
            try {
                InetAddress[] addrs = InetAddress.getAllByName(this.host);
                int length = addrs.length;
                int j = 0;
                while (j < length) {
                    InetAddress addr = addrs[0];
                    String hostname = addr.getHostName();
                    String hostname2 = addr.getCanonicalHostName();
                    Object object3 = lock;
                    synchronized (object3) {
                        if (addr.isLoopbackAddress()) {
                            if (hostname != null && !this.addressList.contains(hostname)) {
                                this.addressList.add(hostname);
                            }
                            if (hostname2 != null && !this.addressList.contains(hostname2)) {
                                this.addressList.add(hostname2);
                            }
                        } else {
                            if (hostname != null && !this.nonAddressList.contains(hostname)) {
                                this.nonAddressList.add(hostname);
                            }
                            if (hostname2 != null && !this.nonAddressList.contains(hostname2)) {
                                this.nonAddressList.add(hostname2);
                            }
                        }
                    }
                    ++j;
                }
            }
            catch (UnknownHostException unknownHostException) {
                object = lock;
                synchronized (object) {
                    if (this.host != null && !this.nonAddressList.contains(this.host)) {
                        this.nonAddressList.add(this.host);
                    }
                }
            }
            object = lock;
            synchronized (object) {
                this.threadMap2.remove(this.host);
            }
        }
    }
}

