/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.J2EEComponentArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebComponentArchiveSaveAdapter
extends J2EEComponentArchiveSaveAdapter {
    private IPath IMPORTED_CLASSES_PATH = new Path("/WEB-INF/classes/");
    protected Map<IArchiveResource, IPath> nonStandardSourceFiles;

    public WebComponentArchiveSaveAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    @Override
    protected boolean shouldAddImportedClassesToClasspath() {
        return false;
    }

    @Override
    protected IPath getImportedClassesURI(IArchiveResource aFile) {
        return aFile.getPath().makeRelative().removeFirstSegments(this.IMPORTED_CLASSES_PATH.segmentCount());
    }

    @Override
    protected IPath getImportedClassesRuntimePath() {
        return this.IMPORTED_CLASSES_PATH;
    }

    @Override
    protected IPath getProjectRelativePath(IArchiveResource aFile) {
        if (this.nonStandardSourceFiles != null && this.nonStandardSourceFiles.containsKey(aFile)) {
            IPath path = this.nonStandardSourceFiles.get(aFile);
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualFile vFile = rootFolder.getFile(path);
            IFile iFile = vFile.getUnderlyingFile();
            return iFile.getProjectRelativePath();
        }
        return super.getProjectRelativePath(aFile);
    }

    @Override
    protected boolean isClassWithoutSource(IArchiveResource aFile) {
        String alternateJavaUri;
        Path alternateJavaPath;
        Path jspPath;
        int _index;
        String javaUri = ArchiveUtil.classUriToJavaUri((String)aFile.getPath().toString());
        if (javaUri == null) {
            return true;
        }
        Path javaPath = new Path(javaUri);
        if (this.archive.containsArchiveResource((IPath)javaPath)) {
            return false;
        }
        String jspUri = javaUri.substring(0, javaUri.indexOf(".java"));
        int lastSlash = jspUri.lastIndexOf(47);
        int n = _index = lastSlash == -1 ? "WEB-INF/classes/".length() : lastSlash + 1;
        if (jspUri.charAt(_index) == '_' && this.archive.containsArchiveResource((IPath)(jspPath = new Path(jspUri = String.valueOf(jspUri.substring("WEB-INF/classes/".length(), _index)) + jspUri.substring(_index + 1) + ".jsp")))) {
            return false;
        }
        if (javaPath.segmentCount() > 2 && javaPath.segment(0).equals("WEB-INF") && javaPath.segment(1).equals("classes") && this.archive.containsArchiveResource((IPath)(alternateJavaPath = new Path(alternateJavaUri = javaUri.replaceFirst("classes", "source"))))) {
            try {
                IArchiveResource sourceFile = this.archive.getArchiveResource((IPath)alternateJavaPath);
                if (sourceFile != null) {
                    if (this.nonStandardSourceFiles == null) {
                        this.nonStandardSourceFiles = new HashMap<IArchiveResource, IPath>();
                    }
                    if (!this.nonStandardSourceFiles.containsKey(sourceFile)) {
                        this.nonStandardSourceFiles.put(sourceFile, (IPath)javaPath);
                    }
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected List<IArchiveResource> getArchiveResourcesForSave() {
        ArrayList<IArchiveResource> sortedFiles = new ArrayList<IArchiveResource>();
        int classIndex = 0;
        for (IArchiveResource resource : super.getArchiveResourcesForSave()) {
            if (resource.getPath().lastSegment().endsWith(".class")) {
                sortedFiles.add(classIndex++, resource);
                continue;
            }
            sortedFiles.add(resource);
        }
        return sortedFiles;
    }
}

