/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.util.ReferenceInfoAdapter;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceMapper
extends ReferenceInfoAdapter
implements ISourceElementRequestor,
SuffixConstants {
    public static boolean VERBOSE = false;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return Util.isJavaLikeFileName(name);
        }
    };
    protected ArrayList rootPaths;
    protected BinaryType binaryType;
    protected IPath sourcePath;
    protected String rootPath = "";
    protected HashMap parameterNames;
    protected HashMap sourceRanges;
    protected HashMap categories;
    public static final SourceRange UNKNOWN_RANGE = new SourceRange(-1, 0);
    protected int[] memberDeclarationStart;
    protected SourceRange[] memberNameRange;
    protected String[] memberName;
    protected char[][][] methodParameterNames;
    protected char[][][] methodParameterTypes;
    protected IJavaScriptElement searchedElement;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    IType[] types;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int[] typeModifiers;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;

    public SourceMapper() {
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options) {
        this.options = options;
        try {
            this.encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {}
        if (rootPath != null) {
            this.rootPaths = new ArrayList();
            this.rootPaths.add(rootPath);
        }
        this.sourcePath = sourcePath;
        this.sourceRanges = new HashMap();
        this.parameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand, int modifiers) {
        int importsCounter;
        Object imports = (char[][])this.importsTable.get(this.binaryType);
        if (imports == null) {
            imports = new char[5][];
            importsCounter = 0;
        } else {
            importsCounter = (Integer)this.importsCounterTable.get(this.binaryType);
        }
        if (((char[][])imports).length == importsCounter) {
            Object object = imports;
            char[][] cArrayArray = new char[importsCounter * 2][];
            imports = cArrayArray;
            System.arraycopy(object, 0, cArrayArray, 0, importsCounter);
        }
        char[] name = CharOperation.concatWith(tokens, '.');
        if (onDemand) {
            int nameLength = name.length;
            char[] cArray = name;
            name = new char[nameLength + 2];
            System.arraycopy(cArray, 0, name, 0, nameLength);
            name[nameLength] = 46;
            name[nameLength + 1] = 42;
        }
        imports[importsCounter++] = name;
        this.importsTable.put(this.binaryType, imports);
        this.importsCounterTable.put(this.binaryType, new Integer(importsCounter));
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public void acceptProblem(CategorizedProblem problem) {
    }

    private void addCategories(IJavaScriptElement element, char[][] elementCategories) {
        if (elementCategories == null) {
            return;
        }
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        this.categories.put(element, CharOperation.toStrings(elementCategories));
    }

    public void close() {
        this.sourceRanges = null;
        this.parameterNames = null;
    }

    private String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            char[] typeSig = Signature.createCharArrayTypeSignature(typeNames[i], false);
            StringBuffer simpleTypeSig = null;
            int start = 0;
            int dot = -1;
            int length = typeSig.length;
            int j = 0;
            while (j < length) {
                switch (typeSig[j]) {
                    case 'Q': {
                        if (simpleTypeSig != null) {
                            simpleTypeSig.append(typeSig, start, j - start);
                        }
                        start = j;
                        break;
                    }
                    case '.': {
                        dot = j;
                        break;
                    }
                    case ';': 
                    case '<': {
                        if (dot <= start) break;
                        if (simpleTypeSig == null) {
                            simpleTypeSig = new StringBuffer().append(typeSig, 0, start);
                        }
                        simpleTypeSig.append('Q');
                        simpleTypeSig.append(typeSig, dot + 1, j - dot - 1);
                        start = j;
                    }
                }
                ++j;
            }
            if (simpleTypeSig == null) {
                typeSigs[i] = new String(typeSig);
            } else {
                simpleTypeSig.append(typeSig, start, length - start);
                typeSigs[i] = simpleTypeSig.toString();
            }
            ++i;
        }
        return typeSigs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void computeAllRootPaths(IType type) {
        int size;
        long time;
        HashSet<Object> tempRoots;
        block40: {
            block39: {
                File file;
                Object target;
                boolean containsADefaultPackage;
                HashSet<String> firstLevelPackageNames;
                block41: {
                    int max;
                    int i;
                    if (this.areRootPathsComputed) {
                        return;
                    }
                    IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
                    tempRoots = new HashSet<Object>();
                    time = 0L;
                    if (VERBOSE) {
                        System.out.println("compute all root paths for " + root.getElementName());
                        time = System.currentTimeMillis();
                    }
                    firstLevelPackageNames = new HashSet<String>();
                    containsADefaultPackage = false;
                    target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), root.getPath(), true);
                    if (target instanceof IResource) {
                        IResource resource = (IResource)target;
                        if (resource instanceof IContainer) {
                            try {
                                IResource[] members = ((IContainer)resource).members();
                                i = 0;
                                max = members.length;
                                while (i < max) {
                                    IResource member = members[i];
                                    if (member.getType() == 2) {
                                        firstLevelPackageNames.add(member.getName());
                                    } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(member.getName())) {
                                        containsADefaultPackage = true;
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    } else if (target instanceof File && (file = (File)target).isDirectory()) {
                        File[] files = file.listFiles();
                        i = 0;
                        max = files.length;
                        while (i < max) {
                            File currentFile = files[i];
                            if (currentFile.isDirectory()) {
                                firstLevelPackageNames.add(currentFile.getName());
                            } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(currentFile.getName())) {
                                containsADefaultPackage = true;
                            }
                            ++i;
                        }
                    }
                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block41;
                    JavaModelManager manager = JavaModelManager.getJavaModelManager();
                    ZipFile zip = null;
                    try {
                        try {
                            zip = manager.getZipFile(this.sourcePath);
                            Enumeration<? extends ZipEntry> entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                String entryName;
                                ZipEntry entry = entries.nextElement();
                                if (entry.isDirectory() || !Util.isJavaLikeFileName(entryName = entry.getName())) continue;
                                Path path = new Path(entryName);
                                int segmentCount = path.segmentCount();
                                if (segmentCount > 1) {
                                    int i2 = 0;
                                    int max2 = path.segmentCount() - 1;
                                    while (i2 < max2) {
                                        if (firstLevelPackageNames.contains(path.segment(i2))) {
                                            tempRoots.add(path.uptoSegment(i2));
                                        }
                                        if (i2 == max2 - 1 && containsADefaultPackage) {
                                            tempRoots.add(path.uptoSegment(max2));
                                        }
                                        ++i2;
                                    }
                                    continue;
                                }
                                if (!containsADefaultPackage) continue;
                                tempRoots.add(new Path(""));
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    catch (Throwable throwable) {
                        Object var17_22 = null;
                        manager.closeZipFile(zip);
                        throw throwable;
                    }
                    {
                        Object var17_23 = null;
                        manager.closeZipFile(zip);
                        break block39;
                    }
                }
                target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
                if (target instanceof IResource) {
                    if (target instanceof IContainer) {
                        this.computeRootPath((IContainer)target, firstLevelPackageNames, containsADefaultPackage, tempRoots);
                    }
                } else if (target instanceof File && (file = (File)target).isDirectory()) {
                    this.computeRootPath(file, firstLevelPackageNames, containsADefaultPackage, tempRoots);
                }
            }
            size = tempRoots.size();
            if (this.rootPaths != null) {
                Iterator iterator = this.rootPaths.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.rootPaths.clear();
                        break block40;
                    }
                    tempRoots.add(new Path((String)iterator.next()));
                }
            }
            this.rootPaths = new ArrayList(size);
        }
        size = tempRoots.size();
        if (size > 0) {
            ArrayList sortedRoots = new ArrayList(tempRoots);
            if (size > 1) {
                Collections.sort(sortedRoots, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        IPath path1 = (IPath)o1;
                        IPath path2 = (IPath)o2;
                        return path1.segmentCount() - path2.segmentCount();
                    }
                });
            }
            Iterator iter = sortedRoots.iterator();
            while (iter.hasNext()) {
                IPath path = (IPath)iter.next();
                this.rootPaths.add(path.toString());
            }
        }
        this.areRootPathsComputed = true;
        if (VERBOSE) {
            System.out.println("Spent " + (System.currentTimeMillis() - time) + "ms");
            System.out.println("Found " + size + " root paths");
            int i = 0;
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext()) {
                System.out.println("root[" + i + "]=" + (String)iterator.next());
                ++i;
            }
        }
    }

    private void computeRootPath(File directory, HashSet firstLevelPackageNames, boolean hasDefaultPackage, Set set) {
        File[] files = directory.listFiles();
        boolean hasSubDirectories = false;
        int i = 0;
        int max = files.length;
        while (i < max) {
            File parentDir;
            File file = files[i];
            if (file.isDirectory()) {
                hasSubDirectories = true;
                if (firstLevelPackageNames.contains(file.getName())) {
                    Path fullPath = new Path(file.getParentFile().getPath());
                    IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                    set.add(rootPathEntry);
                    break;
                }
                this.computeRootPath(file, firstLevelPackageNames, hasDefaultPackage, set);
            } else if (i == max - 1 && !hasSubDirectories && hasDefaultPackage && (parentDir = file.getParentFile()).list(FILENAME_FILTER).length != 0) {
                Path fullPath = new Path(parentDir.getPath());
                IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                set.add(rootPathEntry);
            }
            ++i;
        }
    }

    private void computeRootPath(IContainer container, HashSet firstLevelPackageNames, boolean hasDefaultPackage, Set set) {
        try {
            IResource[] resources = container.members();
            boolean hasSubDirectories = false;
            int i = 0;
            int max = resources.length;
            while (i < max) {
                IResource resource = resources[i];
                if (resource.getType() == 2) {
                    hasSubDirectories = true;
                    if (firstLevelPackageNames.contains(resource.getName())) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        set.add(rootPathEntry);
                        break;
                    }
                    this.computeRootPath((IContainer)((IFolder)resource), firstLevelPackageNames, hasDefaultPackage, set);
                }
                if (i == max - 1 && !hasSubDirectories && hasDefaultPackage) {
                    boolean hasJavaSourceFile = false;
                    int j = 0;
                    while (j < max) {
                        if (Util.isJavaLikeFileName(resources[i].getName())) {
                            hasJavaSourceFile = true;
                            break;
                        }
                        ++j;
                    }
                    if (hasJavaSourceFile) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        set.add(rootPathEntry);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        ++this.typeDepth;
        if (this.typeDepth == this.types.length) {
            this.types = new IType[this.typeDepth * 2];
            System.arraycopy(this.types, 0, this.types, 0, this.typeDepth);
            this.typeNameRanges = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.typeNameRanges, 0, this.typeNameRanges, 0, this.typeDepth);
            this.typeDeclarationStarts = new int[this.typeDepth * 2];
            System.arraycopy(this.typeDeclarationStarts, 0, this.typeDeclarationStarts, 0, this.typeDepth);
            this.memberName = new String[this.typeDepth * 2];
            System.arraycopy(this.memberName, 0, this.memberName, 0, this.typeDepth);
            this.memberDeclarationStart = new int[this.typeDepth * 2];
            System.arraycopy(this.memberDeclarationStart, 0, this.memberDeclarationStart, 0, this.typeDepth);
            this.memberNameRange = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.memberNameRange, 0, this.memberNameRange, 0, this.typeDepth);
            char[][][] cArrayArray = new char[this.typeDepth * 2][][];
            this.methodParameterTypes = cArrayArray;
            System.arraycopy(this.methodParameterTypes, 0, cArrayArray, 0, this.typeDepth);
            char[][][] cArrayArray2 = new char[this.typeDepth * 2][][];
            this.methodParameterNames = cArrayArray2;
            System.arraycopy(this.methodParameterNames, 0, cArrayArray2, 0, this.typeDepth);
            this.typeModifiers = new int[this.typeDepth * 2];
            System.arraycopy(this.typeModifiers, 0, this.typeModifiers, 0, this.typeDepth);
        }
        if (typeInfo.name.length == 0) {
            ++this.anonymousCounter;
            this.types[this.typeDepth] = this.anonymousCounter == this.anonymousClassName ? this.getType(this.binaryType.getElementName()) : this.getType(new String(typeInfo.name));
        } else {
            this.types[this.typeDepth] = this.getType(new String(typeInfo.name));
        }
        this.typeNameRanges[this.typeDepth] = new SourceRange(typeInfo.nameSourceStart, typeInfo.nameSourceEnd - typeInfo.nameSourceStart + 1);
        this.typeDeclarationStarts[this.typeDepth] = typeInfo.declarationStart;
        IType currentType = this.types[this.typeDepth];
        if (typeInfo.typeParameters != null) {
            int i = 0;
            int length = typeInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i];
                ITypeParameter typeParameter = currentType.getTypeParameter(new String(typeParameterInfo.name));
                this.setSourceRange(typeParameter, new SourceRange(typeParameterInfo.declarationStart, typeParameterInfo.declarationEnd - typeParameterInfo.declarationStart + 1), new SourceRange(typeParameterInfo.nameSourceStart, typeParameterInfo.nameSourceEnd - typeParameterInfo.nameSourceStart + 1));
                ++i;
            }
        }
        this.typeModifiers[this.typeDepth] = typeInfo.modifiers;
        this.addCategories(currentType, typeInfo.categories);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        if (this.typeDepth >= 0) {
            String fieldName;
            this.memberDeclarationStart[this.typeDepth] = fieldInfo.declarationStart;
            this.memberNameRange[this.typeDepth] = new SourceRange(fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd - fieldInfo.nameSourceStart + 1);
            this.memberName[this.typeDepth] = fieldName = new String(fieldInfo.name);
            IType currentType = this.types[this.typeDepth];
            IField field = currentType.getField(fieldName);
            this.addCategories(field, fieldInfo.categories);
        }
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    private void enterAbstractMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        if (this.typeDepth >= 0) {
            this.memberName[this.typeDepth] = new String(methodInfo.name);
            this.memberNameRange[this.typeDepth] = new SourceRange(methodInfo.nameSourceStart, methodInfo.nameSourceEnd - methodInfo.nameSourceStart + 1);
            this.memberDeclarationStart[this.typeDepth] = methodInfo.declarationStart;
            IType currentType = this.types[this.typeDepth];
            int currenTypeModifiers = this.typeModifiers[this.typeDepth];
            char[][] parameterTypes = methodInfo.parameterTypes;
            if (parameterTypes != null && methodInfo.isConstructor && currentType.getDeclaringType() != null && !Flags.isStatic(currenTypeModifiers)) {
                IType declaringType = currentType.getDeclaringType();
                String declaringTypeName = declaringType.getElementName();
                if (declaringTypeName.length() == 0) {
                    IClassFile classFile = declaringType.getClassFile();
                    int length = parameterTypes.length;
                    char[][] newParameterTypes = new char[length + 1][];
                    declaringTypeName = classFile.getElementName();
                    declaringTypeName = declaringTypeName.substring(0, declaringTypeName.indexOf(46));
                    newParameterTypes[0] = declaringTypeName.toCharArray();
                    System.arraycopy(parameterTypes, 0, newParameterTypes, 1, length);
                    this.methodParameterTypes[this.typeDepth] = newParameterTypes;
                } else {
                    int length = parameterTypes.length;
                    char[][] newParameterTypes = new char[length + 1][];
                    newParameterTypes[0] = declaringTypeName.toCharArray();
                    System.arraycopy(parameterTypes, 0, newParameterTypes, 1, length);
                    this.methodParameterTypes[this.typeDepth] = newParameterTypes;
                }
            } else {
                this.methodParameterTypes[this.typeDepth] = parameterTypes;
            }
            this.methodParameterNames[this.typeDepth] = methodInfo.parameterNames;
            IFunction method = currentType.getFunction(this.memberName[this.typeDepth], this.convertTypeNamesToSigs(this.methodParameterTypes[this.typeDepth]));
            if (methodInfo.typeParameters != null) {
                int i = 0;
                int length = methodInfo.typeParameters.length;
                while (i < length) {
                    ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[i];
                    ITypeParameter typeParameter = method.getTypeParameter(new String(typeParameterInfo.name));
                    this.setSourceRange(typeParameter, new SourceRange(typeParameterInfo.declarationStart, typeParameterInfo.declarationEnd - typeParameterInfo.declarationStart + 1), new SourceRange(typeParameterInfo.nameSourceStart, typeParameterInfo.nameSourceEnd - typeParameterInfo.nameSourceStart + 1));
                    ++i;
                }
            }
            this.addCategories(method, methodInfo.categories);
        }
    }

    public void exitType(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType, new SourceRange(this.typeDeclarationStarts[this.typeDepth], declarationEnd - this.typeDeclarationStarts[this.typeDepth] + 1), this.typeNameRanges[this.typeDepth]);
            --this.typeDepth;
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        this.exitAbstractMethod(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType.getField(this.memberName[this.typeDepth]), new SourceRange(this.memberDeclarationStart[this.typeDepth], declarationEnd - this.memberDeclarationStart[this.typeDepth] + 1), this.memberNameRange[this.typeDepth]);
        }
    }

    public void exitInitializer(int declarationEnd) {
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        this.exitAbstractMethod(declarationEnd);
    }

    private void exitAbstractMethod(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            SourceRange sourceRange = new SourceRange(this.memberDeclarationStart[this.typeDepth], declarationEnd - this.memberDeclarationStart[this.typeDepth] + 1);
            IFunction method = currentType.getFunction(this.memberName[this.typeDepth], this.convertTypeNamesToSigs(this.methodParameterTypes[this.typeDepth]));
            this.setSourceRange(method, sourceRange, this.memberNameRange[this.typeDepth]);
            this.setMethodParameterNames(method, this.methodParameterNames[this.typeDepth]);
        }
    }

    public char[] findSource(IType type, IBinaryType info) {
        if (!type.isBinary()) {
            return null;
        }
        String simpleSourceFileName = ((BinaryType)type).getSourceFileName(info);
        if (simpleSourceFileName == null) {
            return null;
        }
        return this.findSource(type, simpleSourceFileName);
    }

    public char[] findSource(IType type, String simpleSourceFileName) {
        long time = 0L;
        if (VERBOSE) {
            time = System.currentTimeMillis();
        }
        PackageFragment pkgFrag = (PackageFragment)type.getPackageFragment();
        String name = Util.concatWith(pkgFrag.names, simpleSourceFileName, '/');
        char[] source = null;
        if (this.rootPath != null) {
            source = this.getSourceForRootPath(this.rootPath, name);
        }
        if (source == null) {
            this.computeAllRootPaths(type);
            if (this.rootPaths != null) {
                Iterator iterator = this.rootPaths.iterator();
                while (iterator.hasNext()) {
                    String currentRootPath = (String)iterator.next();
                    if (currentRootPath.equals(this.rootPath) || (source = this.getSourceForRootPath(currentRootPath, name)) == null) continue;
                    this.rootPath = currentRootPath;
                    break;
                }
            }
        }
        if (VERBOSE) {
            System.out.println("spent " + (System.currentTimeMillis() - time) + "ms for " + type.getElementName());
        }
        return source;
    }

    private char[] getSourceForRootPath(String currentRootPath, String name) {
        String newFullName = !currentRootPath.equals("") ? (currentRootPath.endsWith("/") ? String.valueOf(currentRootPath) + name : String.valueOf(currentRootPath) + '/' + name) : name;
        return this.findSource(newFullName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] findSource(String fullName) {
        char[] source;
        block11: {
            source = null;
            if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block11;
            ZipEntry entry = null;
            ZipFile zip = null;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            try {
                try {
                    zip = manager.getZipFile(this.sourcePath);
                    entry = zip.getEntry(fullName);
                    if (entry != null) {
                        source = this.readSource(entry, zip);
                    }
                }
                catch (CoreException coreException) {
                    Object var6_10 = null;
                    manager.closeZipFile(zip);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                manager.closeZipFile(zip);
                throw throwable;
            }
            {
                Object var6_12 = null;
                manager.closeZipFile(zip);
                return source;
            }
        }
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
        if (target instanceof IResource) {
            if (!(target instanceof IContainer)) return source;
            IResource res = ((IContainer)target).findMember(fullName);
            if (!(res instanceof IFile)) return source;
            try {
                return Util.getResourceContentsAsCharArray((IFile)res);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return source;
            }
        }
        if (!(target instanceof File)) return source;
        File file = (File)target;
        if (!file.isDirectory()) return source;
        File sourceFile = new File(file, fullName);
        if (!sourceFile.isFile()) return source;
        try {
            return org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(sourceFile, this.encoding);
        }
        catch (IOException iOException) {}
        return source;
    }

    public SourceRange getNameRange(IJavaScriptElement element) {
        switch (element.getElementType()) {
            case 9: {
                if (!((IMember)element).isBinary()) break;
                IJavaScriptElement[] el = this.getUnqualifiedMethodHandle((IFunction)element, false);
                if (el[1] != null && this.sourceRanges.get(el[0]) == null) {
                    element = this.getUnqualifiedMethodHandle((IFunction)element, true)[0];
                    break;
                }
                element = el[0];
                break;
            }
            case 15: {
                IFunction method;
                IJavaScriptElement parent = element.getParent();
                if (parent.getElementType() != 9 || !(method = (IFunction)parent).isBinary()) break;
                IJavaScriptElement[] el = this.getUnqualifiedMethodHandle(method, false);
                method = el[1] != null && this.sourceRanges.get(el[0]) == null ? (IFunction)this.getUnqualifiedMethodHandle(method, true)[0] : (IFunction)el[0];
                element = method.getTypeParameter(element.getElementName());
            }
        }
        SourceRange[] ranges = (SourceRange[])this.sourceRanges.get(element);
        if (ranges == null) {
            return UNKNOWN_RANGE;
        }
        return ranges[1];
    }

    public char[][] getMethodParameterNames(IFunction method) {
        char[][] parameters;
        if (method.isBinary()) {
            IJavaScriptElement[] el = this.getUnqualifiedMethodHandle(method, false);
            method = el[1] != null && this.parameterNames.get(el[0]) == null ? (IFunction)this.getUnqualifiedMethodHandle(method, true)[0] : (IFunction)el[0];
        }
        if ((parameters = (char[][])this.parameterNames.get(method)) == null) {
            return null;
        }
        return parameters;
    }

    public SourceRange getSourceRange(IJavaScriptElement element) {
        if (!this.areRootPathsComputed && element instanceof ISourceReference) {
            try {
                return (SourceRange)((ISourceReference)((Object)element)).getSourceRange();
            }
            catch (JavaScriptModelException e) {
                Util.log((Throwable)((Object)e), "error getting source range");
                return UNKNOWN_RANGE;
            }
        }
        switch (element.getElementType()) {
            case 9: {
                if (!((IMember)element).isBinary()) break;
                IJavaScriptElement[] el = this.getUnqualifiedMethodHandle((IFunction)element, false);
                if (el[1] != null && this.sourceRanges.get(el[0]) == null) {
                    element = this.getUnqualifiedMethodHandle((IFunction)element, true)[0];
                    break;
                }
                element = el[0];
                break;
            }
            case 15: {
                IFunction method;
                IJavaScriptElement parent = element.getParent();
                if (parent.getElementType() != 9 || !(method = (IFunction)parent).isBinary()) break;
                IJavaScriptElement[] el = this.getUnqualifiedMethodHandle(method, false);
                method = el[1] != null && this.sourceRanges.get(el[0]) == null ? (IFunction)this.getUnqualifiedMethodHandle(method, true)[0] : (IFunction)el[0];
                element = method.getTypeParameter(element.getElementName());
            }
        }
        SourceRange[] ranges = (SourceRange[])this.sourceRanges.get(element);
        if (ranges == null) {
            return UNKNOWN_RANGE;
        }
        return ranges[0];
    }

    protected IType getType(String typeName) {
        if (typeName.length() == 0) {
            IJavaScriptElement classFile = this.binaryType.getParent();
            String classFileName = classFile.getElementName();
            StringBuffer newClassFileName = new StringBuffer();
            int lastDollar = classFileName.lastIndexOf(36);
            int i = 0;
            while (i <= lastDollar) {
                newClassFileName.append(classFileName.charAt(i));
                ++i;
            }
            newClassFileName.append(Integer.toString(this.anonymousCounter));
            PackageFragment pkg = (PackageFragment)classFile.getParent();
            return new BinaryType(new ClassFile(pkg, newClassFileName.toString()), typeName);
        }
        if (this.binaryType.getElementName().equals(typeName)) {
            return this.binaryType;
        }
        return this.binaryType.getType(typeName);
    }

    protected IJavaScriptElement[] getUnqualifiedMethodHandle(IFunction method, boolean noDollar) {
        boolean hasDollar = false;
        String[] qualifiedParameterTypes = method.getParameterTypes();
        String[] unqualifiedParameterTypes = new String[qualifiedParameterTypes.length];
        int i = 0;
        while (i < qualifiedParameterTypes.length) {
            StringBuffer unqualifiedTypeSig = new StringBuffer();
            this.getUnqualifiedTypeSignature(qualifiedParameterTypes[i], 0, qualifiedParameterTypes[i].length(), unqualifiedTypeSig, noDollar);
            unqualifiedParameterTypes[i] = unqualifiedTypeSig.toString();
            hasDollar |= unqualifiedParameterTypes[i].lastIndexOf(36) != -1;
            ++i;
        }
        IJavaScriptElement[] result = new IJavaScriptElement[2];
        result[0] = ((IType)method.getParent()).getFunction(method.getElementName(), unqualifiedParameterTypes);
        if (hasDollar) {
            result[1] = result[0];
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getUnqualifiedTypeSignature(String qualifiedTypeSig, int start, int length, StringBuffer unqualifiedTypeSig, boolean noDollar) {
        char current;
        char firstChar = qualifiedTypeSig.charAt(start);
        int end = start + 1;
        boolean sigStart = false;
        int i = start;
        block15: while (i < length) {
            current = qualifiedTypeSig.charAt(i);
            switch (current) {
                case '+': 
                case '-': 
                case '[': {
                    unqualifiedTypeSig.append(current);
                    start = i + 1;
                    end = start + 1;
                    firstChar = qualifiedTypeSig.charAt(start);
                    break;
                }
                case 'L': 
                case 'Q': 
                case 'T': {
                    if (sigStart) break;
                    start = ++i;
                    sigStart = true;
                    break;
                }
                case ';': 
                case '<': {
                    end = i;
                    break block15;
                }
                case '*': {
                    unqualifiedTypeSig.append(current);
                    start = i + 1;
                    end = start + 1;
                    firstChar = qualifiedTypeSig.charAt(start);
                    break;
                }
                case '>': {
                    return i;
                }
                case '.': {
                    start = ++i;
                }
            }
            ++i;
        }
        switch (firstChar) {
            case 'L': 
            case 'Q': 
            case 'T': {
                int lastDollar;
                unqualifiedTypeSig.append('Q');
                if (noDollar && (lastDollar = qualifiedTypeSig.lastIndexOf(36, end)) > start) {
                    start = lastDollar + 1;
                }
                i = start;
                while (i < length) {
                    current = qualifiedTypeSig.charAt(i);
                    switch (current) {
                        case '<': {
                            unqualifiedTypeSig.append(current);
                            ++i;
                            while (qualifiedTypeSig.charAt(i = this.getUnqualifiedTypeSignature(qualifiedTypeSig, i, length, unqualifiedTypeSig, noDollar)) != '>') {
                            }
                            unqualifiedTypeSig.append('>');
                            break;
                        }
                        case ';': {
                            unqualifiedTypeSig.append(current);
                            return i + 1;
                        }
                        default: {
                            unqualifiedTypeSig.append(current);
                        }
                    }
                    ++i;
                }
                return length;
            }
        }
        unqualifiedTypeSig.append(qualifiedTypeSig.substring(start, end));
        return end;
    }

    public void mapSource(IType type, char[] contents, IBinaryType info) {
        this.mapSource(type, contents, info, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized ISourceRange mapSource(IType type, char[] contents, IBinaryType info, IJavaScriptElement elementToFind) {
        block14: {
            this.binaryType = (BinaryType)type;
            if (this.sourceRanges.get(type) != null) {
                return elementToFind != null ? this.getNameRange(elementToFind) : null;
            }
            this.importsTable.remove(this.binaryType);
            this.importsCounterTable.remove(this.binaryType);
            this.searchedElement = elementToFind;
            this.types = new IType[1];
            this.typeDeclarationStarts = new int[1];
            this.typeNameRanges = new SourceRange[1];
            this.typeModifiers = new int[1];
            this.typeDepth = -1;
            this.memberDeclarationStart = new int[1];
            this.memberName = new String[1];
            this.memberNameRange = new SourceRange[1];
            this.methodParameterTypes = new char[1][][];
            this.methodParameterNames = new char[1][][];
            this.anonymousCounter = 0;
            oldSourceRanges = (HashMap)this.sourceRanges.clone();
            try {
                factory = new DefaultProblemFactory();
                parser = null;
                this.anonymousClassName = 0;
                if (info != null) break block14;
                try {
                    info = (IBinaryType)this.binaryType.getElementInfo();
                }
                catch (JavaScriptModelException v0) {
                    while (true) {
                        var13_8 = null;
                        if (elementToFind != null) {
                            this.sourceRanges = oldSourceRanges;
                        }
                        this.binaryType = null;
                        this.searchedElement = null;
                        this.types = null;
                        this.typeDeclarationStarts = null;
                        this.typeNameRanges = null;
                        this.typeDepth = -1;
                        return null;
                    }
                }
            }
            catch (Throwable var14_18) {
                var13_10 = null;
                if (elementToFind != null) {
                    this.sourceRanges = oldSourceRanges;
                }
                this.binaryType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                throw var14_18;
            }
        }
        isAnonymousClass = info.isAnonymous();
        fullName = info.getName();
        if (isAnonymousClass) {
            eltName = this.binaryType.getParent().getElementName();
            eltName = eltName.substring(eltName.lastIndexOf(36) + 1, eltName.length());
            try {
                this.anonymousClassName = Integer.parseInt(eltName);
            }
            catch (NumberFormatException v1) {}
        }
        doFullParse = this.hasToRetrieveSourceRangesForLocalClass(fullName);
        parser = new SourceElementParser(this, factory, new CompilerOptions(this.options), doFullParse, true);
        parser.javadocParser.checkDocComment = false;
        javaElement /* !! */  = this.binaryType.getJavaScriptUnit();
        if (javaElement /* !! */  == null) {
            javaElement /* !! */  = this.binaryType.getParent();
        }
        parser.parseCompilationUnit(new BasicCompilationUnit(contents, null, this.binaryType.sourceFileName(info), javaElement /* !! */ ), doFullParse);
        if (elementToFind == null) ** continue;
        var15_17 = range = this.getNameRange(elementToFind);
        var13_9 = null;
        if (elementToFind != null) {
            this.sourceRanges = oldSourceRanges;
        }
        this.binaryType = null;
        this.searchedElement = null;
        this.types = null;
        this.typeDeclarationStarts = null;
        this.typeNameRanges = null;
        this.typeDepth = -1;
        return var15_17;
    }

    private char[] readSource(ZipEntry entry, ZipFile zip) {
        try {
            byte[] bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(entry, zip);
            if (bytes != null) {
                return org.eclipse.wst.jsdt.internal.compiler.util.Util.bytesToChar(bytes, this.encoding);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    protected void setMethodParameterNames(IFunction method, char[][] parameterNames) {
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        this.parameterNames.put(method, parameterNames);
    }

    protected void setSourceRange(IJavaScriptElement element, SourceRange sourceRange, SourceRange nameRange) {
        this.sourceRanges.put(element, new SourceRange[]{sourceRange, nameRange});
    }

    public char[][] getImports(BinaryType type) {
        Object imports = (char[][])this.importsTable.get(type);
        if (imports != null) {
            int importsCounter = (Integer)this.importsCounterTable.get(type);
            if (((char[][])imports).length != importsCounter) {
                char[][] cArray = imports;
                char[][] cArrayArray = new char[importsCounter][];
                imports = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, importsCounter);
            }
            this.importsTable.put(type, imports);
        }
        return imports;
    }

    private boolean hasToRetrieveSourceRangesForLocalClass(char[] eltName) {
        if (eltName == null) {
            return false;
        }
        int length = eltName.length;
        int dollarIndex = CharOperation.indexOf('$', eltName, 0);
        while (dollarIndex != -1) {
            int nameStart = dollarIndex + 1;
            if (nameStart == length) {
                return false;
            }
            if (Character.isDigit(eltName[nameStart])) {
                return true;
            }
            dollarIndex = CharOperation.indexOf('$', eltName, nameStart);
        }
        return false;
    }
}

