/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IDebugRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.SourceJavadocParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    protected PrintWriter out;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public AbstractAnnotationProcessorManager annotationProcessorManager;
    public ReferenceBinding[] referenceBindings;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        this(environment, policy, options, requestor, problemFactory, null);
    }

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, final ICompilerRequestor requestor, IProblemFactory problemFactory, PrintWriter out) {
        this.options = options;
        this.requestor = DebugRequestor == null ? requestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(result);
                }
                requestor.acceptResult(result);
            }
        };
        this.problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, environment);
        this.out = out == null ? new PrintWriter(System.out, true) : out;
        this.initializeParser();
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(sourceUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        unitResult.packageName = sourceUnit.getPackageName();
        try {
            if (this.options.verbose) {
                String count = String.valueOf(this.totalUnits + 1);
                this.out.println(Messages.bind(Messages.compilation_request, new String[]{count, count, new String(sourceUnit.getFileName())}));
            }
            CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
            parsedUnit.bits |= 1;
            this.parser.inferTypes(parsedUnit, this.options);
            this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
            if (!(sourceUnit instanceof IClassFile)) {
                this.addCompilationUnit(sourceUnit, parsedUnit);
            }
            this.lookupEnvironment.completeTypeBindings(parsedUnit);
        }
        catch (AbortCompilationUnit e) {
            if (unitResult.compilationUnit == sourceUnit) {
                this.requestor.acceptResult(unitResult.tagAsAccepted());
            }
            throw e;
        }
    }

    public void accept(LibraryAPIs libraryMetaData) {
        this.lookupEnvironment.buildTypeBindings(libraryMetaData);
    }

    public CompilationUnitDeclaration doParse(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(sourceUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        if (this.options.verbose) {
            String count = String.valueOf(this.totalUnits + 1);
            this.out.println(Messages.bind(Messages.compilation_request, new String[]{count, count, new String(sourceUnit.getFileName())}));
        }
        CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
        this.parser.inferTypes(parsedUnit, this.options);
        return parsedUnit;
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.problemReporter.abortDueToInternalError(Messages.bind(Messages.abort_againstSourceModel, new String[]{String.valueOf(sourceTypes[0].getName()), String.valueOf(sourceTypes[0].getFileName())}));
    }

    protected void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        int size = this.unitsToProcess.length;
        if (this.totalUnits == size) {
            this.unitsToProcess = new CompilationUnitDeclaration[size * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = parsedUnit;
    }

    protected void beginToCompile(ICompilationUnit[] sourceUnits) {
        int maxUnits = sourceUnits.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        this.internalBeginToCompile(sourceUnits, maxUnits);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(ICompilationUnit[] sourceUnits) {
        CompilationUnitDeclaration unit = null;
        int i = 0;
        try {
            try {
                this.beginToCompile(sourceUnits);
                if (this.annotationProcessorManager != null) {
                    this.processAnnotations();
                    if (!this.options.generateClassFiles) {
                        Object var6_4 = null;
                        this.reset();
                        return;
                    }
                }
                while (i < this.totalUnits) {
                    block15: {
                        Object var4_7;
                        unit = this.unitsToProcess[i];
                        try {
                            if (this.options.verbose) {
                                this.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                            }
                            this.process(unit, i);
                            var4_7 = null;
                            unit.cleanUp();
                            this.unitsToProcess[i] = null;
                            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                            if (!this.options.verbose) break block15;
                        }
                        catch (Throwable throwable) {
                            var4_7 = null;
                            unit.cleanUp();
                            throw throwable;
                        }
                        this.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(unit.getFileName())}));
                    }
                    ++i;
                }
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
            }
            catch (Error e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
            catch (RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
            Object var6_6 = null;
            this.reset();
            if (!this.options.verbose) return;
            if (this.totalUnits > 1) {
                this.out.println(Messages.bind(Messages.compilation_units, String.valueOf(this.totalUnits)));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.reset();
            throw throwable;
        }
        this.out.println(Messages.bind(Messages.compilation_unit, String.valueOf(this.totalUnits)));
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        if (result == null && unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.lookupEnvironment.unitBeingCompleted != null) {
            result = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (result == null && this.lookupEnvironment.unitBeingCompleted != null) {
            result = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        boolean needToPrint = true;
        if (result != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            internalException.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            String[] pbArguments = new String[]{String.valueOf(Messages.compilation_internalError) + "\n" + buffer.toString()};
            result.record(this.problemReporter.createProblem(result.getFileName(), 0, pbArguments, pbArguments, 1, 0, 0, 0, 0), unit);
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
                needToPrint = false;
            }
        }
        if (needToPrint) {
            internalException.printStackTrace();
        }
    }

    public void setBinaryTypes(ReferenceBinding[] binaryTypes) {
        this.referenceBindings = binaryTypes;
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        if (abortException.isSilent) {
            if (abortException.silentException == null) {
                return;
            }
            throw abortException.silentException;
        }
        CompilationResult result = abortException.compilationResult;
        if (result == null && unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.lookupEnvironment.unitBeingCompleted != null) {
            result = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (result != null && !result.hasBeenAccepted) {
            block14: {
                if (abortException.problem != null) {
                    CategorizedProblem distantProblem = abortException.problem;
                    CategorizedProblem[] knownProblems = result.problems;
                    int i = 0;
                    while (i < result.problemCount) {
                        if (knownProblems[i] != distantProblem) {
                            ++i;
                            continue;
                        }
                        break block14;
                    }
                    if (distantProblem instanceof DefaultProblem) {
                        ((DefaultProblem)distantProblem).setOriginatingFileName(result.getFileName());
                    }
                    result.record(distantProblem, unit);
                } else if (abortException.exception != null) {
                    this.handleInternalException(abortException.exception, null, result);
                    return;
                }
            }
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
            }
        } else {
            abortException.printStackTrace();
        }
    }

    public void initializeParser() {
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
        this.parser.javadocParser = new SourceJavadocParser(this.parser);
        this.parser.javadocParser.checkDocComment = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalBeginToCompile(ICompilationUnit[] sourceUnits, int maxUnits) {
        int i = 0;
        while (true) {
            Object var7_7;
            if (i >= maxUnits) {
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            CompilationResult unitResult = new CompilationResult(sourceUnits[i], i, maxUnits, this.options.maxProblemsPerUnit);
            try {
                if (this.options.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_request, new String[]{String.valueOf(i + 1), String.valueOf(maxUnits), new String(sourceUnits[i].getFileName())}));
                }
                CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnits[i], unitResult) : this.parser.dietParse(sourceUnits[i], unitResult);
                this.parser.inferTypes(parsedUnit, this.options);
                this.addCompilationUnit(sourceUnits[i], parsedUnit);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                ImportReference currentPackage = parsedUnit.currentPackage;
                if (currentPackage != null) {
                    unitResult.recordPackageName(currentPackage.tokens);
                }
            }
            catch (Throwable throwable) {
                var7_7 = null;
                sourceUnits[i] = null;
                throw throwable;
            }
            {
                var7_7 = null;
                sourceUnits[i] = null;
                ++i;
                continue;
            }
            break;
        }
    }

    public void process(CompilationUnitDeclaration unit, int i) {
        this.lookupEnvironment.unitBeingCompleted = unit;
        this.parser.getMethodBodies(unit);
        if (unit.scope != null) {
            unit.scope.faultInTypes();
        }
        if (unit.scope != null) {
            unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        unit.resolve();
        unit.analyseCode();
        if (this.options.produceReferenceInfo && unit.scope != null) {
            unit.scope.storeDependencyInfo();
        }
        unit.compilationResult.totalUnitsKnown = this.totalUnits;
        this.lookupEnvironment.unitBeingCompleted = null;
    }

    protected void processAnnotations() {
        int newUnitSize = 0;
        int newClassFilesSize = 0;
        int bottom = 0;
        int top = this.unitsToProcess.length;
        ReferenceBinding[] binaryTypeBindingsTemp = this.referenceBindings;
        if (top == 0 && binaryTypeBindingsTemp == null) {
            return;
        }
        this.referenceBindings = null;
        do {
            int length = top - bottom;
            CompilationUnitDeclaration[] currentUnits = new CompilationUnitDeclaration[length];
            int index = 0;
            int i = bottom;
            while (i < top) {
                CompilationUnitDeclaration currentUnit = this.unitsToProcess[i];
                if ((currentUnit.bits & 1) == 0) {
                    currentUnits[index++] = currentUnit;
                }
                ++i;
            }
            if (index != length) {
                CompilationUnitDeclaration[] compilationUnitDeclarationArray = currentUnits;
                currentUnits = new CompilationUnitDeclaration[index];
                System.arraycopy(compilationUnitDeclarationArray, 0, currentUnits, 0, index);
            }
            this.annotationProcessorManager.processAnnotations(currentUnits, binaryTypeBindingsTemp, false);
            ICompilationUnit[] newUnits = this.annotationProcessorManager.getNewUnits();
            newUnitSize = newUnits.length;
            ReferenceBinding[] newClassFiles = this.annotationProcessorManager.getNewClassFiles();
            binaryTypeBindingsTemp = newClassFiles;
            newClassFilesSize = newClassFiles.length;
            if (newUnitSize != 0) {
                this.internalBeginToCompile(newUnits, newUnitSize);
                bottom = top;
                top = this.unitsToProcess.length;
            } else {
                bottom = top;
            }
            this.annotationProcessorManager.reset();
        } while (newUnitSize != 0 || newClassFilesSize != 0);
        this.annotationProcessorManager.processAnnotations(null, null, true);
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
        this.problemReporter.reset();
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{sourceUnit});
                unit = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(unit, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.lookupEnvironment.unitBeingCompleted = unit;
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, verifyMethods, analyzeCode, generateCode);
    }
}

