/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class FillArgumentNamesCompletionProposalCollector
extends CompletionProposalCollector {
    private final boolean fIsGuessArguments;

    public FillArgumentNamesCompletionProposalCollector(JavaContentAssistInvocationContext context) {
        super(context.getCompilationUnit());
        this.setInvocationContext(context);
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        this.fIsGuessArguments = preferenceStore.getBoolean("content_assist_guess_method_arguments");
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: {
                return this.createMethodReferenceProposal(proposal);
            }
            case 9: {
                return this.createTypeProposal(proposal);
            }
        }
        return super.createJavaCompletionProposal(proposal);
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        String completion = String.valueOf(methodProposal.getCompletion());
        if (completion.length() == 0 || completion.length() == 1 && completion.charAt(0) == ')' || Signature.getParameterCount((char[])methodProposal.getSignature()) == 0 || this.getContext().isInJsdoc()) {
            return super.createJavaCompletionProposal(methodProposal);
        }
        IJavaScriptUnit compilationUnit = this.getCompilationUnit();
        JavaMethodCompletionProposal proposal = compilationUnit != null && this.fIsGuessArguments ? new ParameterGuessingProposal(methodProposal, this.getInvocationContext()) : new FilledArgumentNamesMethodProposal(methodProposal, this.getInvocationContext());
        return proposal;
    }

    private IJavaCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        IJavaScriptUnit cu = this.getCompilationUnit();
        if (cu == null || this.getContext().isInJsdoc()) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        IJavaScriptProject project = cu.getJavaScriptProject();
        if (!this.shouldProposeGenerics(project)) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        char[] completion = typeProposal.getCompletion();
        if (completion.length > 0 && (completion[completion.length - 1] == ';' || completion[completion.length - 1] == '.')) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        LazyGenericTypeProposal newProposal = new LazyGenericTypeProposal(typeProposal, this.getInvocationContext());
        return newProposal;
    }

    private final boolean shouldProposeGenerics(IJavaScriptProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true) : JavaScriptCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.source");
        return sourceVersion != null && "1.5".compareTo(sourceVersion) <= 0;
    }
}

