/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileListener;
import org.eclipse.jpt.db.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.NullConnectionProfile;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPConnectionProfileRepository
implements ConnectionProfileRepository {
    private ProfileManager dtpProfileManager;
    private LocalProfileListener profileListener;
    private final Vector<DTPConnectionProfileWrapper> connectionProfiles = new Vector();
    private static final DTPConnectionProfileRepository INSTANCE = new DTPConnectionProfileRepository();

    public static DTPConnectionProfileRepository instance() {
        return INSTANCE;
    }

    private DTPConnectionProfileRepository() {
    }

    public synchronized void start() {
        this.dtpProfileManager = ProfileManager.getInstance();
        IConnectionProfile[] iConnectionProfileArray = this.dtpProfileManager.getProfiles();
        int n = iConnectionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            this.connectionProfiles.add(new DTPConnectionProfileWrapper(dtpProfile));
            ++n2;
        }
        this.profileListener = new LocalProfileListener();
        this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
    }

    public synchronized void stop() {
        for (DTPConnectionProfileWrapper profile : this.connectionProfiles) {
            profile.dispose();
        }
        this.connectionProfiles.clear();
        this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
        this.profileListener = null;
        this.dtpProfileManager = null;
    }

    @Override
    public synchronized Iterator<ConnectionProfile> connectionProfiles() {
        return new CloneIterator(this.connectionProfiles);
    }

    private synchronized Iterator<DTPConnectionProfileWrapper> connectionProfileWrappers() {
        return new CloneIterator(this.connectionProfiles);
    }

    @Override
    public int connectionProfilesSize() {
        return this.connectionProfiles.size();
    }

    @Override
    public Iterator<String> connectionProfileNames() {
        return new TransformationIterator<DTPConnectionProfileWrapper, String>(this.connectionProfileWrappers()){

            protected String transform(DTPConnectionProfileWrapper profile) {
                return profile.getName();
            }
        };
    }

    @Override
    public boolean containsConnectionProfileNamed(String name) {
        return !this.connectionProfileNamed(name).isNull();
    }

    @Override
    public ConnectionProfile connectionProfileNamed(String name) {
        Iterator<DTPConnectionProfileWrapper> stream = this.connectionProfileWrappers();
        while (stream.hasNext()) {
            DTPConnectionProfileWrapper profile = stream.next();
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return NullConnectionProfile.instance();
    }

    synchronized DTPConnectionProfileWrapper addConnectionProfile(IConnectionProfile dtpConnectionProfile) {
        DTPConnectionProfileWrapper wrapper2;
        for (DTPConnectionProfileWrapper wrapper2 : this.connectionProfiles) {
            if (!wrapper2.wraps(dtpConnectionProfile)) continue;
            throw new IllegalStateException("duplicate connection profile: " + dtpConnectionProfile.getName());
        }
        wrapper2 = new DTPConnectionProfileWrapper(dtpConnectionProfile);
        this.connectionProfiles.add(wrapper2);
        return wrapper2;
    }

    synchronized DTPConnectionProfileWrapper removeConnectionProfile(IConnectionProfile dtpConnectionProfile) {
        Iterator<DTPConnectionProfileWrapper> stream = this.connectionProfiles.iterator();
        while (stream.hasNext()) {
            DTPConnectionProfileWrapper wrapper = stream.next();
            if (!wrapper.wraps(dtpConnectionProfile)) continue;
            stream.remove();
            return wrapper;
        }
        throw new IllegalStateException("invalid connection profile: " + dtpConnectionProfile.getName());
    }

    synchronized DTPConnectionProfileWrapper connectionProfile(IConnectionProfile dtpConnectionProfile) {
        for (DTPConnectionProfileWrapper wrapper : this.connectionProfiles) {
            if (!wrapper.wraps(dtpConnectionProfile)) continue;
            return wrapper;
        }
        throw new IllegalStateException("invalid connection profile: " + dtpConnectionProfile.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassTools.toStringClassNameForObject((Object)this));
        sb.append(this.connectionProfiles != null ? this.connectionProfiles : "<'connectionProfiles' uninitialized>");
        return sb.toString();
    }

    @Override
    public void addConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.addConnectionProfileListener(listener);
    }

    @Override
    public void removeConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.removeConnectionProfileListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalProfileListener
    implements IProfileListener {
        private Vector<ConnectionProfileListener> listeners = new Vector();

        LocalProfileListener() {
        }

        void addConnectionProfileListener(ConnectionProfileListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionProfileListener(ConnectionProfileListener listener) {
            this.listeners.remove(listener);
        }

        private Iterator<ConnectionProfileListener> listeners() {
            return new CloneIterator(this.listeners);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            DTPConnectionProfileWrapper profile = DTPConnectionProfileRepository.this.addConnectionProfile(dtpProfile);
            Iterator<ConnectionProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().connectionProfileReplaced(NullConnectionProfile.instance(), profile);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            DTPConnectionProfileWrapper profile = DTPConnectionProfileRepository.this.connectionProfile(dtpProfile);
            Iterator<ConnectionProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().connectionProfileChanged(profile);
            }
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            DTPConnectionProfileWrapper profile = DTPConnectionProfileRepository.this.removeConnectionProfile(dtpProfile);
            Iterator<ConnectionProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().connectionProfileReplaced(profile, NullConnectionProfile.instance());
            }
        }
    }
}

