/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.eclipse;

import java.io.InputStream;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLMessageInfoHelper;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLValidator;

public class Validator
extends AbstractNestedValidator {
    protected int indicateNoGrammar = 0;

    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        this.indicateNoGrammar = XMLCorePlugin.getDefault().getPluginPreferences().getInt("indicateNoGrammar");
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        return this.validate(uri, inputstream, context, null);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        XMLValidator validator = XMLValidator.getInstance();
        XMLValidationConfiguration configuration = new XMLValidationConfiguration();
        try {
            configuration.setFeature(XMLValidationConfiguration.INDICATE_NO_GRAMMAR, this.indicateNoGrammar);
        }
        catch (Exception exception) {}
        XMLValidationReport valreport = null;
        valreport = inputstream != null ? validator.validate(uri, inputstream, configuration, result) : validator.validate(uri, null, configuration, result);
        return valreport;
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            XMLMessageInfoHelper messageInfoHelper = new XMLMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(key, validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }
}

