/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationFactoryImpl;
import org.eclipse.jst.j2ee.applicationclient.internal.modulecore.util.AppClientEditAdapterFactory;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.core.internal.plugin.CatalogJ2EEXmlDtDEntityResolver;
import org.eclipse.jst.j2ee.internal.common.J2EEDependencyListener;
import org.eclipse.jst.j2ee.internal.common.VirtualArchiveComponentAdapterFactory;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModulemapInit;
import org.eclipse.jst.j2ee.internal.modulecore.util.EarEditAdapterFactory;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.jst.j2ee.internal.validation.ResourceUtil;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.jst.j2ee.refactor.listeners.J2EEElementChangedListener;
import org.eclipse.jst.j2ee.refactor.listeners.ProjectRefactoringListener;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.impl.ReferencedComponentXMIResourceFactory;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.xml.sax.EntityResolver;

public class J2EEPlugin
extends WTPPlugin
implements ResourceLocator {
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee";
    public static final String UI_PLUGIN_ID = "org.eclipse.jst.j2ee.ui";
    protected final IPath iconsFolder = new Path(Platform.getBundle((String)"org.eclipse.jst.j2ee").getEntry("icons").getPath());
    public static final String LIBDIRCHANGE_BUILDER_ID = "org.eclipse.jst.j2ee.web.LibDirBuilder";
    public static final String LIBCOPY_BUILDER_ID = "org.eclipse.jst.j2ee.LibCopyBuilder";
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    private static boolean defaultIsWorkspaceRelativeSchema = false;
    private List fextendedEditModels;
    private static IPath location;
    public static IStatus OK_STATUS;
    public static final String[] ICON_DIRS;
    protected static Boolean EJB_AVAILABLE;
    private static Boolean HAS_DEV_ROLE;
    private J2EEPreferences preferences = null;
    public static J2EEPlugin INSTANCE;
    private static LogEntry _entry;

    static {
        OK_STATUS = new Status(0, PLUGIN_ID, 0, "OK", null);
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/cview16", "icons/full/ctool16", "icons/full/clcl16", "icons/full/ovr16", "icons/full/extra", "icons/full/wizban", "icons", ""};
        EJB_AVAILABLE = null;
    }

    public J2EEPlugin() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle(PLUGIN_ID);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static boolean defaultIsWorkspaceRelativeSchema() {
        return defaultIsWorkspaceRelativeSchema;
    }

    public ApplicationFactory getApplicationFactory() {
        return (ApplicationFactory)this.getApplicationPackage().getEFactoryInstance();
    }

    public ApplicationPackage getApplicationPackage() {
        return ApplicationFactoryImpl.getPackage();
    }

    public static J2EEPlugin getDefault() {
        return INSTANCE;
    }

    public URL getBaseURL() {
        return this.getBundle().getEntry("/");
    }

    public Object[] getJ2EEWebProjectMigrationExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint("J2EEWebProjectMigrationExtension");
        Vector<Object> ret = new Vector<Object>();
        if (pct != null) {
            IExtension[] extension = pct.getExtensions();
            int l = 0;
            while (l < extension.length) {
                IExtension config = extension[l];
                IConfigurationElement[] cElems = config.getConfigurationElements();
                int i = 0;
                while (i < cElems.length) {
                    IConfigurationElement d = cElems[i];
                    if (d.getName().equals("migration")) {
                        try {
                            Object me = d.createExecutableExtension("run");
                            ret.add(me);
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
                ++l;
            }
        }
        return ret.toArray();
    }

    public EditModel getExtendedEditModel(String editModelKey) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint("EditModelExtension");
        IExtension[] extension = pct.getExtensions();
        int l = 0;
        while (l < extension.length) {
            IExtension config = extension[l];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            int i = 0;
            while (i < cElems.length) {
                IConfigurationElement d = cElems[i];
                if (d.getName().equals("editmodel") && editModelKey.equals(d.getAttribute("key"))) {
                    try {
                        return (EditModel)d.createExecutableExtension("run");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ++i;
            }
            ++l;
        }
        return null;
    }

    public List getExtendedEditModels() {
        if (this.fextendedEditModels != null) {
            return this.fextendedEditModels;
        }
        ArrayList<Object> editModels = new ArrayList<Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint("EditModelExtension");
        IExtension[] extension = pct.getExtensions();
        int l = 0;
        while (l < extension.length) {
            IExtension config = extension[l];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            int i = 0;
            while (i < cElems.length) {
                IConfigurationElement d = cElems[i];
                if (d.getName().equals("editmodel")) {
                    try {
                        editModels.add(d.createExecutableExtension("run"));
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ++i;
            }
            ++l;
        }
        this.fextendedEditModels = editModels;
        return this.fextendedEditModels;
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (Platform.find((Bundle)bundle, (IPath)path) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    Logger.getLogger().logWarning(J2EEPluginResourceHandler.getString("Load_Image_Error_", new Object[]{key}));
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public Object getImage(String key) {
        return J2EEPlugin.getImageURL(key, this.getBundle());
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL url = J2EEPlugin.getInstallURL();
            try {
                String installLocation = ((PlatformURLConnection)url.openConnection()).getURLAsLocal().getFile();
                location = new Path(installLocation);
            }
            catch (IOException e) {
                Logger.getLogger().logWarning(String.valueOf(J2EEPluginResourceHandler.getString("Install_Location_Error_", new Object[]{url})) + e);
            }
        }
        return location;
    }

    public static URL getInstallURL() {
        return J2EEPlugin.getDefault().getBundle().getEntry("/");
    }

    protected static IJavaModel getJavaModel() {
        return JemProjectUtilities.getJavaModel();
    }

    protected static IJavaModel getJavaModel(IProject aProject) {
        if (aProject != null) {
            return JemProjectUtilities.getJavaModel();
        }
        return null;
    }

    public static IJavaProject getJavaProject(IProject project) {
        IJavaModel model = J2EEPlugin.getJavaModel(project);
        if (model != null) {
            return model.getJavaProject(project.getName());
        }
        return null;
    }

    public static LogEntry getLogEntry() {
        if (_entry == null) {
            _entry = new LogEntry();
        } else {
            _entry.reset();
        }
        _entry.setLocaleOfOrigin(Locale.getDefault().toString());
        return _entry;
    }

    public static J2EEPlugin getPlugin() {
        return INSTANCE;
    }

    public static IPath getPluginLocation(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            try {
                IPath installPath = new Path(bundle.getEntry("/").toExternalForm()).removeTrailingSeparator();
                String installStr = Platform.asLocalURL((URL)new URL(installPath.toString())).getFile();
                return new Path(installStr);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected void initializeDefaultPluginPreferences() {
        this.getJ2EEPreferences().initializeDefaultPreferences();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IStatus newErrorStatus(int aCode, String aMessage, Throwable exception) {
        return J2EEPlugin.newStatus(4, aCode, aMessage, exception);
    }

    public static IStatus newErrorStatus(String aMessage, Throwable exception) {
        return J2EEPlugin.newErrorStatus(0, aMessage, exception);
    }

    public static IStatus newOperationFailedStatus(String aMessage, Throwable exception) {
        return J2EEPlugin.newStatus(4, 76, aMessage, exception);
    }

    public static IStatus newStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage, exception);
    }

    public String getString(String key) {
        try {
            return Platform.getResourceString((Bundle)this.getBundle(), (String)key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public static void setDefaultIsWorkspaceRelativeSchema(boolean newDefaultIsWorkspaceRelativeSchema) {
        defaultIsWorkspaceRelativeSchema = newDefaultIsWorkspaceRelativeSchema;
    }

    public static boolean isEJBSupportAvailable() {
        if (EJB_AVAILABLE == null) {
            EJB_AVAILABLE = Boolean.TRUE;
        }
        return EJB_AVAILABLE;
    }

    public static boolean isHeadless() {
        return UIContextDetermination.getCurrentContext() == 102;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        J2EEXmlDtDEntityResolver.INSTANCE = new CatalogJ2EEXmlDtDEntityResolver();
        DOMUtilities.setDefaultEntityResolver((EntityResolver)J2EEXmlDtDEntityResolver.INSTANCE);
        ArchiveInit.init((boolean)false);
        ModulemapInit.init(false);
        this.ensureFactoryRegistration();
        ValidatorManager.setResourceUtilClass(ResourceUtil.class);
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)new EarEditAdapterFactory(), ArtifactEditModel.class);
        manager.registerAdapters((IAdapterFactory)new AppClientEditAdapterFactory(), ArtifactEditModel.class);
        manager.registerAdapters((IAdapterFactory)new VirtualArchiveComponentAdapterFactory(), VirtualArchiveComponent.class);
        ProjectRefactoringListener listener = new ProjectRefactoringListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 5);
        JavaCore.addElementChangedListener((IElementChangedListener)new J2EEElementChangedListener(), (int)1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)J2EEComponentClasspathUpdater.getInstance(), 7);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)J2EEDependencyListener.INSTANCE, 7);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)J2EEComponentClasspathUpdater.getInstance());
        try {
            Platform.getJobManager().join((Object)"org.eclipse.jst.j2ee.refactor.component", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Logger.getLogger().logError(e.getMessage());
        }
        catch (InterruptedException e) {
            Logger.getLogger().logError(e.getMessage());
        }
    }

    private void ensureFactoryRegistration() {
        this.ensureDefaultReferencedXMIResourceFactoryRegistration();
    }

    private void ensureDefaultReferencedXMIResourceFactoryRegistration() {
        J2EEResourceFactoryRegistry reg1 = J2EEResourceFactoryRegistry.INSTANCE;
        WTPResourceFactoryRegistry reg2 = WTPResourceFactoryRegistry.INSTANCE;
        ReferencedComponentXMIResourceFactory factory = new ReferencedComponentXMIResourceFactory();
        reg1.getExtensionToFactoryMap().put("*", factory);
        reg2.getExtensionToFactoryMap().put("*", factory);
        reg1.getExtensionToFactoryMap().put("xmi", factory);
        reg2.getExtensionToFactoryMap().put("xmi", factory);
    }

    public static boolean hasDevelopmentRole() {
        if (HAS_DEV_ROLE == null) {
            Bundle desc = Platform.getBundle((String)"org.eclipse.jst.j2ee.assembly");
            HAS_DEV_ROLE = desc != null ? Boolean.FALSE : Boolean.TRUE;
        }
        return HAS_DEV_ROLE;
    }

    public static IWorkspaceRunnable getWorkspaceRunnable(final IHeadlessRunnableWithProgress op) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    op.run(monitor);
                }
                catch (InvocationTargetException e) {
                    throw new CoreException(J2EEPlugin.newErrorStatus(0, e.getMessage(), e));
                }
                catch (InterruptedException e) {
                    throw new CoreException(J2EEPlugin.newErrorStatus(0, e.getMessage(), e));
                }
            }
        };
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public J2EEPreferences getJ2EEPreferences() {
        if (this.preferences == null) {
            this.preferences = new J2EEPreferences((Plugin)this);
        }
        return this.preferences;
    }

    public String getString(String key, boolean translate) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getString(key, substitutions);
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        J2EEPlugin.getDefault().getLog().log(J2EEPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        J2EEPlugin.log(J2EEPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        J2EEPlugin.getDefault().getLog().log(aStatus);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return J2EEPlugin.createStatus(4, aCode, aMessage != null ? aMessage : exception.toString(), exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EEPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

