/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.util.Enumeration;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.html.core.internal.htmlcss.CSSQueryDeclarationData;
import org.eclipse.wst.html.core.internal.htmlcss.CSSQueryValueData;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

class CSSQueryContext
extends CSSPropertyContext {
    public CSSQueryContext() {
    }

    public CSSQueryContext(ICSSStyleDeclaration decl) {
        super(decl);
    }

    public void applyFull(ICSSStyleDeclaration decl) {
        if (decl == null) {
            return;
        }
        Enumeration keys = this.fProperties.keys();
        while (keys.hasMoreElements()) {
            String value;
            ICSSStyleDeclItem itemToRemove;
            Object key = keys.nextElement();
            Object val = this.fProperties.get(key);
            if (val instanceof CSSQueryDeclarationData) {
                ICSSStyleDeclItem declItem = ((CSSQueryDeclarationData)((Object)val)).getDeclItem();
                if (declItem.getLength() <= 0) {
                    itemToRemove = decl.getDeclItemNode(key.toString());
                    if (itemToRemove == null) continue;
                    decl.removeDeclItemNode(itemToRemove);
                    continue;
                }
                decl.setDeclItemNode(declItem);
                continue;
            }
            String string = value = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : val.toString();
            if (value == null || value.length() <= 0) {
                itemToRemove = decl.getDeclItemNode(key.toString());
                if (itemToRemove == null) continue;
                decl.removeDeclItemNode(itemToRemove);
                continue;
            }
            decl.setProperty(key.toString(), value, null);
        }
    }

    private boolean check(String propName, boolean important, int specificity) {
        Object current = this.fProperties.get(propName);
        if (current != null && current instanceof CSSQueryValueData) {
            CSSQueryValueData currentValue = (CSSQueryValueData)((Object)current);
            if (!important && currentValue.important || currentValue.getSpecificity() > specificity) {
                return false;
            }
        }
        return true;
    }

    public void overrideWithExpand(ICSSStyleDeclaration decl, int specificity) {
        if (decl == null) {
            return;
        }
        CSSLinkConverter conv = new CSSLinkConverter((IStructuredModel)decl.getOwnerDocument().getModel());
        int nProperties = decl.getLength();
        int i = 0;
        while (i < nProperties) {
            String propN;
            String propName = decl.item(i);
            if (propName != null && (propN = propName.trim().toLowerCase()).length() != 0) {
                boolean important;
                PropCMProperty prop = PropCMProperty.getInstanceOf((String)propN);
                String priority = decl.getPropertyPriority(propName);
                boolean bl = important = priority != null && priority.length() > 0;
                if (prop != null && prop.isShorthand()) {
                    CSSQueryContext context = new CSSQueryContext();
                    CSSQueryContext.expandToLeaf((PropCMProperty)prop, (String)decl.getPropertyValue(propName), (CSSPropertyContext)context);
                    Enumeration properties = context.properties();
                    while (properties.hasMoreElements()) {
                        propN = properties.nextElement().toString();
                        if (!this.check(propN, important, specificity)) continue;
                        this.fProperties.put(propN, new CSSQueryValueData(conv.toAbsolute(context.get(propN)), important, specificity));
                    }
                } else if (this.check(propN, important, specificity)) {
                    ICSSStyleDeclItem declItem = (ICSSStyleDeclItem)decl.getDeclItemNode(propName).cloneNode(true);
                    int nValues = declItem.getLength();
                    int j = 0;
                    while (j < nValues) {
                        conv.toAbsolute(declItem.item(j));
                        ++j;
                    }
                    declItem.setPriority(null);
                    this.fProperties.put(propN, new CSSQueryDeclarationData(declItem, important, specificity));
                }
            }
            ++i;
        }
    }
}

