/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.ApplicationDeploymentDescriptor;
import org.eclipse.jst.javaee.application.ApplicationFactory;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.internal.util.ApplicationResourceImpl;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.jee.model.internal.JEE5ModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EAR5ModelProvider
extends JEE5ModelProvider
implements IEARModelProvider {
    private static final String EAR5_CONTENT_TYPE = "org.eclipse.jst.jee.ee5earDD";

    public EAR5ModelProvider(IProject proj) {
        this.proj = proj;
        this.setDefaultResourcePath((IPath)new Path("META-INF/application.xml"));
    }

    protected String getContentTypeDescriber() {
        return EAR5_CONTENT_TYPE;
    }

    public Object getModelObject(IPath modelPath) {
        ApplicationResourceImpl earRes = (ApplicationResourceImpl)this.getModelResource(modelPath);
        if (earRes != null && earRes.getContents().size() > 0) {
            return earRes.getApplication();
        }
        return null;
    }

    public String getModuleURI(IVirtualComponent moduleComp) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.proj);
        IVirtualReference[] refs = comp.getReferences();
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getReferencedComponent().equals(moduleComp)) {
                return refs[i].getArchiveName();
            }
            ++i;
        }
        return null;
    }

    public String getWebContextRoot(IProject webProject) {
        Module webModule;
        if (webProject == null || !J2EEProjectUtilities.isDynamicWebProject((IProject)webProject)) {
            return null;
        }
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        String webModuleURI = this.getModuleURI(webComp);
        if (webModuleURI != null && (webModule = ((Application)this.getModelObject()).getModule(webModuleURI, null)) != null) {
            return webModule.getWeb().getContextRoot();
        }
        return null;
    }

    public void populateRoot(XMLResourceImpl res, String name) {
        ApplicationDeploymentDescriptor dd = ApplicationFactory.eINSTANCE.createApplicationDeploymentDescriptor();
        dd.getXMLNSPrefixMap().put("", "http://java.sun.com/xml/ns/javaee");
        dd.getXMLNSPrefixMap().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application_5.xsd");
        Application ear = ApplicationFactory.eINSTANCE.createApplication();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        ear.getDisplayNames().add(dn);
        ear.setVersion("5");
        dd.setApplication(ear);
        res.getContents().add((Object)((EObject)dd));
    }
}

