/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUtil;
import org.eclipse.jst.jsp.ui.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.ui.tests.validation.ValidationContextForTest;
import org.eclipse.wst.html.internal.validation.HTMLValidator;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPHTMLValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "bug_143209";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_143209", "/bug_143209");
        }
        JSPHTMLValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testJSPinAttributes() throws Exception {
        HTMLValidator validator = new HTMLValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are errors when they should not be (in .jsp)", (boolean)reporter.getMessages().isEmpty());
    }

    public void testJSPinAttributesHTML() throws Exception {
        HTMLValidator validator = new HTMLValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.html";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are not errors when they should be (in .html)", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    public void testBadAttributeName() throws Exception {
        HTMLValidator validator = new HTMLValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/badattributenames.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"bad attribute name is not error when it should be", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }
}

