/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentRegionIterator;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class ScanningTests {
    private static IStructuredDocument textStore = null;
    private static long startTime = 0L;
    private static long stopTime = 0L;

    public static void checkNodeSeams(String fileName) {
        System.out.println("CHECKING NODE BOUNDARIES AND CONTENTS FOR " + fileName);
        Enumeration e = ScanningTests.parseFile(fileName).elements();
        int lastEnd = 0;
        while (e.hasMoreElements()) {
            IStructuredDocumentRegion r = (IStructuredDocumentRegion)e.nextElement();
            if (r.getStartOffset() != lastEnd) {
                System.out.println("ERROR: dropped in " + r);
            }
            if (r.getNumberOfRegions() < 1) {
                System.out.println("ERROR: empty IStructuredDocumentRegion " + r);
            }
            lastEnd = r.getEndOffset();
        }
        System.out.println("DONE");
    }

    public static void checkParse(String fileName) {
        ScanningTests.checkTokenSeams(fileName);
        ScanningTests.checkNodeSeams(fileName);
    }

    public static void checkTokenSeams(String fileName) {
        System.out.println("CHECKING TOKENIZER REGION BOUNDARIES FOR " + fileName);
        Iterator e = ScanningTests.tokenizeFile(fileName).iterator();
        int lastEnd = 0;
        while (e.hasNext()) {
            IStructuredDocumentRegion r = (IStructuredDocumentRegion)e.next();
            if (r.getStartOffset() != lastEnd) {
                System.out.println("ERROR: dropped in " + r);
            }
            lastEnd = r.getEndOffset();
        }
        System.out.println("DONE");
    }

    public static char[] loadChars(String fileName) {
        char[] chars = null;
        int c = 0;
        int length = 0;
        int count = 0;
        File file = null;
        FileInputStream fis = null;
        try {
            file = new File(fileName);
            length = (int)file.length();
            chars = new char[length];
            fis = new FileInputStream(file);
            while ((c = fis.read()) >= 0 && count < length) {
                chars[count++] = (char)c;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found : \"" + fileName + "\"");
            System.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Usage : java JSPLexer3 <inputfile>");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("An I/O error occured while scanning :");
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chars;
    }

    public static RegionParser newParser() {
        JSPSourceParser parser = new JSPSourceParser();
        parser.addBlockMarker(new BlockMarker("foo", null, "BLOCK_TEXT", true));
        parser.addBlockMarker(new BlockMarker("globalFoo", null, "BLOCK_TEXT", true));
        return parser;
    }

    public static RegionParser newXMLParser() {
        XMLSourceParser parser = new XMLSourceParser();
        parser.addBlockMarker(new BlockMarker("Script", "BLOCK_TEXT", false));
        parser.addBlockMarker(new BlockMarker("stylE", "BLOCK_TEXT", false));
        return parser;
    }

    public static Vector parse(String stringdata) {
        return ScanningTests.parse(stringdata, false);
    }

    public static Vector parse(String stringdata, boolean useXML) {
        RegionParser parser = null;
        parser = useXML ? ScanningTests.newXMLParser() : ScanningTests.newParser();
        parser.reset((Reader)new StringReader(stringdata));
        IStructuredDocumentRegion aNode = ScanningTests.setNodeDocument(parser.getDocumentRegions());
        textStore = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)parser);
        textStore.setText(null, stringdata);
        StructuredDocumentRegionIterator.setParentDocument((IStructuredDocumentRegion)aNode, (IStructuredDocument)textStore);
        Vector<IStructuredDocumentRegion> v = new Vector<IStructuredDocumentRegion>();
        while (aNode != null) {
            v.addElement(aNode);
            aNode = aNode.getNext();
        }
        return v;
    }

    public static Vector parseFile(String fileName) {
        char[] input = ScanningTests.loadChars(fileName);
        return ScanningTests.parse(new String(input));
    }

    private static IStructuredDocumentRegion setNodeDocument(IStructuredDocumentRegion startNode) {
        IStructuredDocumentRegion aNode = startNode;
        while (aNode != null) {
            aNode.setParentDocument(textStore);
            aNode = aNode.getNext();
        }
        return startNode;
    }

    public static List tokenizeFile(String fileName) {
        List v = null;
        StringBuffer buff = new StringBuffer();
        try {
            FileReader input = new FileReader(fileName);
            RegionParser parser = ScanningTests.newParser();
            parser.reset((Reader)input);
            int c = 0;
            parser.getDocumentRegions();
            v = parser.getRegions();
            input.reset();
            while ((c = ((Reader)input).read()) >= 0) {
                buff.append((char)c);
            }
            textStore = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)parser);
            textStore.setText(null, buff.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found : \"" + fileName + "\"");
        }
        catch (IOException iOException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Usage : java JSPLexer3 <inputfile>");
        }
        return v;
    }

    public static String viewableTokenizeWithSeparator(String data) {
        StringBuffer s = new StringBuffer();
        s.append("\"");
        s.append(data);
        s.append("\"\n");
        s.append(ScanningTests.viewableTokenize(data));
        s.append("--------------------------------------------------------------------------------\n");
        return s.toString();
    }

    public static String viewableTokenize(String stringdata) {
        return ScanningTests.viewableTokenize(stringdata, false);
    }

    public static String viewableTokenize(String stringdata, boolean useXML) {
        Vector l = ScanningTests.parse(stringdata, useXML);
        String s = "";
        int i = 0;
        while (i < l.size()) {
            IStructuredDocumentRegion node = (IStructuredDocumentRegion)l.get(i);
            try {
                s = String.valueOf(s) + StringUtils.escape((String)node.toString()) + "\n";
            }
            catch (Exception e) {
                s = String.valueOf(s) + "[" + node.getStart() + ", " + node.getEnd() + "] (UNPRINTABLE " + e + ")";
            }
            ITextRegionList m = node.getRegions();
            int j = 0;
            while (j < m.size()) {
                if (m.get(j) instanceof ITextRegionContainer) {
                    s = String.valueOf(s) + "\t" + StringUtils.escape((String)m.get(j).toString()) + "\n";
                    ITextRegionList n = ((ITextRegionContainer)m.get(j)).getRegions();
                    int k = 0;
                    while (k < n.size()) {
                        s = String.valueOf(s) + "\t\t" + StringUtils.escape((String)n.get(k).toString()) + "\n";
                        ++k;
                    }
                } else {
                    s = String.valueOf(s) + "\t" + StringUtils.escape((String)m.get(j).toString()) + "\n";
                }
                ++j;
            }
            ++i;
        }
        return s;
    }

    public static String viewableTokenizeFile(String fileName) {
        char[] input = ScanningTests.loadChars(fileName);
        return ScanningTests.viewableTokenize(new String(input));
    }
}

