/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.A;
import org.eclipse.wst.common.frameworks.datamodel.tests.B;
import org.eclipse.wst.common.frameworks.datamodel.tests.C;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;

public class NestingTest
extends TestCase {
    private IDataModel a;
    private IDataModel b;
    private IDataModel c;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = DataModelFactory.createDataModel((IDataModelProvider)new A());
        this.b = DataModelFactory.createDataModel((IDataModelProvider)new B());
        this.c = DataModelFactory.createDataModel((IDataModelProvider)new C());
    }

    protected void tearDown() throws Exception {
        if (this.a != null) {
            this.a.dispose();
            this.a = null;
        }
        if (this.b != null) {
            this.b.dispose();
            this.b = null;
        }
        if (this.c != null) {
            this.c.dispose();
            this.c = null;
        }
    }

    public void testInvalidNestedModel() {
        String NESTED_MODEL_NOT_LOCATED = WTPResourceHandler.getString((String)"21");
        RuntimeException ex = null;
        try {
            this.a.getNestedModel("foo");
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(NESTED_MODEL_NOT_LOCATED));
        ex = null;
        try {
            this.a.getNestedModel(null);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(NESTED_MODEL_NOT_LOCATED));
        this.a.addNestedModel("b", this.b);
        ex = null;
        try {
            this.a.getNestedModel(null);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().startsWith(NESTED_MODEL_NOT_LOCATED));
    }

    public void testIsNestedModel() {
        Assert.assertFalse((boolean)this.a.isNestedModel(""));
        Assert.assertFalse((boolean)this.a.isNestedModel(null));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isNestedModel("b"));
        Assert.assertFalse((boolean)this.a.isNestedModel("c"));
        this.a.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isNestedModel("c"));
    }

    public void testRemoveNonExistentModels() {
        Assert.assertNull((Object)this.a.removeNestedModel("a"));
        Assert.assertNull((Object)this.a.removeNestedModel(null));
    }

    public void testGetNestedAndGetNesting() {
        Assert.assertEquals((int)0, (int)this.a.getNestedModels().size());
        Assert.assertEquals((int)0, (int)this.b.getNestingModels().size());
        Assert.assertTrue((boolean)this.a.addNestedModel("b", this.b));
        Assert.assertEquals((int)1, (int)this.a.getNestedModels().size());
        Assert.assertTrue((boolean)this.a.getNestedModels().contains(this.b));
        Assert.assertEquals((Object)this.b, (Object)this.a.getNestedModel("b"));
        Assert.assertEquals((int)1, (int)this.b.getNestingModels().size());
        Assert.assertTrue((boolean)this.b.getNestingModels().contains(this.a));
        Assert.assertTrue((boolean)this.a.addNestedModel("c", this.c));
        Assert.assertEquals((int)2, (int)this.a.getNestedModels().size());
        Assert.assertTrue((boolean)this.a.getNestedModels().contains(this.c));
        Assert.assertEquals((Object)this.c, (Object)this.a.getNestedModel("c"));
        Assert.assertEquals((int)1, (int)this.c.getNestingModels().size());
        Assert.assertTrue((boolean)this.c.getNestingModels().contains(this.a));
        Assert.assertTrue((boolean)this.b.addNestedModel("c", this.c));
        Assert.assertEquals((int)1, (int)this.b.getNestedModels().size());
        Assert.assertTrue((boolean)this.b.getNestedModels().contains(this.c));
        Assert.assertEquals((int)2, (int)this.c.getNestingModels().size());
        Assert.assertTrue((boolean)this.c.getNestingModels().contains(this.b));
        Assert.assertEquals((Object)this.b, (Object)this.a.removeNestedModel("b"));
        Assert.assertEquals((int)1, (int)this.a.getNestedModels().size());
        Assert.assertEquals((int)0, (int)this.b.getNestingModels().size());
        Assert.assertEquals((Object)this.c, (Object)this.a.removeNestedModel("c"));
        Assert.assertEquals((int)0, (int)this.a.getNestedModels().size());
        Assert.assertEquals((int)1, (int)this.c.getNestingModels().size());
        Assert.assertTrue((boolean)this.c.getNestingModels().contains(this.b));
        Assert.assertEquals((Object)this.c, (Object)this.b.removeNestedModel("c"));
        Assert.assertEquals((int)0, (int)this.b.getNestedModels().size());
        Assert.assertEquals((int)0, (int)this.c.getNestingModels().size());
    }

    public void testSelfNest() {
        Assert.assertFalse((boolean)this.a.addNestedModel("a", this.a));
        Assert.assertEquals((int)0, (int)this.a.getNestedModels().size());
    }

    public void testDuplicateNest() {
        Assert.assertTrue((boolean)this.a.addNestedModel("b1", this.b));
        Assert.assertEquals((Object)this.b, (Object)this.a.getNestedModel("b1"));
        Assert.assertFalse((boolean)this.a.addNestedModel("b2", this.b));
        Assert.assertEquals((Object)this.b, (Object)this.a.getNestedModel("b1"));
        Assert.assertFalse((boolean)this.a.isNestedModel("b2"));
    }

    public void testIsPropertySimpleNesting0() {
        this.a.addNestedModel("b", this.b);
        Assert.assertFalse((boolean)this.a.isBaseProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("B.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isBaseProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isNestedProperty("B.P"));
        this.a.addNestedModel("b", this.b);
        Assert.assertFalse((boolean)this.a.isBaseProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("B.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertFalse((boolean)this.a.isBaseProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.a.isBaseProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isNestedProperty("C.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertFalse((boolean)this.a.isBaseProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("C.P"));
    }

    public void testIsPropertySimpleNesting1() {
        this.a.addNestedModel("b", this.b);
        Assert.assertFalse((boolean)this.a.isBaseProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("B.P"));
        Assert.assertTrue((this.b == this.a.getNestedModel("b") ? 1 : 0) != 0);
        Collection nestedModelNames = this.a.getNestedModelNames();
        Assert.assertEquals((int)1, (int)nestedModelNames.size());
        Assert.assertTrue((boolean)nestedModelNames.contains("b"));
        Collection baseProperties = this.a.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("A.P"));
        Collection nestedProperties = this.a.getNestedProperties();
        Assert.assertEquals((int)3, (int)nestedProperties.size());
        Assert.assertTrue((boolean)nestedProperties.contains("B.P"));
        Collection allProperties = this.a.getAllProperties();
        Assert.assertEquals((int)4, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("A.P"));
        Assert.assertTrue((boolean)allProperties.contains("B.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertFalse((boolean)this.a.isBaseProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isNestedProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isBaseProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isNestedProperty("C.P"));
        Assert.assertTrue((this.b == this.a.getNestedModel("b") ? 1 : 0) != 0);
        nestedModelNames = this.a.getNestedModelNames();
        Assert.assertEquals((int)1, (int)nestedModelNames.size());
        Assert.assertTrue((boolean)nestedModelNames.contains("b"));
        baseProperties = this.a.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("A.P"));
        nestedProperties = this.a.getNestedProperties();
        Assert.assertEquals((int)4, (int)nestedProperties.size());
        Assert.assertTrue((boolean)nestedProperties.contains("B.P"));
        Assert.assertTrue((boolean)nestedProperties.contains("C.P"));
        allProperties = this.a.getAllProperties();
        Assert.assertEquals((int)5, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("A.P"));
        Assert.assertTrue((boolean)allProperties.contains("B.P"));
        Assert.assertTrue((boolean)allProperties.contains("C.P"));
        Assert.assertTrue((this.c == this.b.getNestedModel("c") ? 1 : 0) != 0);
        nestedModelNames = this.b.getNestedModelNames();
        Assert.assertEquals((int)1, (int)nestedModelNames.size());
        Assert.assertTrue((boolean)nestedModelNames.contains("c"));
        baseProperties = this.b.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("B.P"));
        nestedProperties = this.b.getNestedProperties();
        Assert.assertEquals((int)3, (int)nestedProperties.size());
        Assert.assertTrue((boolean)nestedProperties.contains("C.P"));
        allProperties = this.b.getAllProperties();
        Assert.assertEquals((int)4, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("B.P"));
        Assert.assertTrue((boolean)allProperties.contains("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.a.isBaseProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isNestedProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isBaseProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isNestedProperty("C.P"));
        Assert.assertTrue((this.b == this.a.getNestedModel("b") ? 1 : 0) != 0);
        nestedModelNames = this.a.getNestedModelNames();
        Assert.assertEquals((int)1, (int)nestedModelNames.size());
        Assert.assertTrue((boolean)nestedModelNames.contains("b"));
        baseProperties = this.a.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("A.P"));
        nestedProperties = this.a.getNestedProperties();
        Assert.assertEquals((int)3, (int)nestedProperties.size());
        Assert.assertTrue((boolean)nestedProperties.contains("B.P"));
        allProperties = this.a.getAllProperties();
        Assert.assertEquals((int)4, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("A.P"));
        Assert.assertTrue((boolean)allProperties.contains("B.P"));
        nestedModelNames = this.b.getNestedModelNames();
        Assert.assertEquals((int)0, (int)nestedModelNames.size());
        baseProperties = this.b.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("B.P"));
        nestedProperties = this.b.getNestedProperties();
        Assert.assertEquals((int)2, (int)nestedProperties.size());
        allProperties = this.b.getAllProperties();
        Assert.assertEquals((int)3, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("B.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isBaseProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isNestedProperty("B.P"));
        nestedModelNames = this.a.getNestedModelNames();
        Assert.assertEquals((int)0, (int)nestedModelNames.size());
        baseProperties = this.a.getBaseProperties();
        Assert.assertEquals((int)3, (int)baseProperties.size());
        Assert.assertTrue((boolean)baseProperties.contains("A.P"));
        nestedProperties = this.a.getNestedProperties();
        Assert.assertEquals((int)2, (int)nestedProperties.size());
        allProperties = this.a.getAllProperties();
        Assert.assertEquals((int)3, (int)allProperties.size());
        Assert.assertTrue((boolean)allProperties.contains("A.P"));
    }

    public void testIsPropertySimpleNesting2() {
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting1() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        IDataModel c2 = DataModelFactory.createDataModel((IDataModelProvider)new C());
        this.b.addNestedModel("c2", c2);
        this.b.removeNestedModel("c2");
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting2() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        IDataModel c2 = DataModelFactory.createDataModel((IDataModelProvider)new C());
        this.a.addNestedModel("c2", c2);
        this.a.removeNestedModel("c2");
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.addNestedModel("c2", c2);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c2");
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting3() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.c.addNestedModel("a", this.a);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.b.removeNestedModel("c");
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.c.removeNestedModel("a");
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
    }

    public void testSetGetProperty1() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        this.c.addNestedModel("a", this.a);
        this.a.setProperty("A.P", (Object)"a");
        this.a.setProperty("B.P", (Object)"b");
        this.a.setProperty("C.P", (Object)"c");
        NestingTest.assertEquals((Object)"a", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"a", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"a", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.c.getProperty("C.P"));
        this.b.setProperty("A.P", (Object)"aa");
        this.b.setProperty("B.P", (Object)"bb");
        this.b.setProperty("C.P", (Object)"cc");
        NestingTest.assertEquals((Object)"aa", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aa", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aa", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.c.getProperty("C.P"));
        this.c.setProperty("A.P", (Object)"aaa");
        this.c.setProperty("B.P", (Object)"bbb");
        this.c.setProperty("C.P", (Object)"ccc");
        NestingTest.assertEquals((Object)"aaa", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aaa", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aaa", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.c.getProperty("C.P"));
    }
}

