/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EARComponentSaveStrategyImpl
extends ComponentSaveStrategyImpl {
    protected Map createdComponentsMap;

    public EARComponentSaveStrategyImpl(IVirtualComponent component) {
        super(component);
    }

    public void setDataModel(IDataModel dataModel) {
        super.setDataModel(dataModel);
        this.setArchive((Archive)dataModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE"));
        this.overwriteHandler = (IOverwriteHandler)dataModel.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER");
        if (this.overwriteHandler != null) {
            this.overwriteHandler.setEarSaveStrategy(this);
        }
        this.buildProjectsMap();
    }

    private void buildProjectsMap() {
        this.createdComponentsMap = new HashMap();
        List createdProjectsList = (List)this.dataModel.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
        IDataModel importDM = null;
        Archive anArchive = null;
        int i = 0;
        while (i < createdProjectsList.size()) {
            importDM = (IDataModel)createdProjectsList.get(i);
            anArchive = (Archive)importDM.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            this.createdComponentsMap.put(anArchive.getURI(), importDM.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT"));
            ++i;
        }
    }

    protected void addFileToClasspath(IProject p, IFile file, List cp) {
        if (!file.exists()) {
            return;
        }
        IPath path = file.getFullPath();
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (boolean)true);
        if (!cp.contains(entry)) {
            cp.add(entry);
        }
    }

    protected void addProjectToClasspath(IProject dependent, IProject prereq, List cp) {
        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)prereq.getFullPath(), (boolean)true);
        if (!cp.contains(entry)) {
            cp.add(entry);
        }
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return null;
    }

    public void save() throws SaveFailureException {
        this.saveFiles();
        this.saveManifest();
        this.saveMofResources();
        this.progressMonitor.subTask(EARArchiveOpsResourceHandler.Updating_project_classpath_UI_);
        this.updateComponentClasspaths();
    }

    public void save(Archive anArchive) throws SaveFailureException {
        this.progressMonitor.subTask(anArchive.getURI());
        this.saveArchiveAsJARInEAR(anArchive);
    }

    protected void saveArchiveAsJARInEAR(Archive anArchive) throws SaveFailureException {
        try {
            anArchive.save(this.createNestedSaveStrategy(anArchive));
            this.progressMonitor.worked(1);
        }
        catch (IOException e) {
            throw new SaveFailureException(anArchive.getURI(), (Exception)e);
        }
    }

    protected SubProgressMonitor subMonitor() {
        return new SubProgressMonitor(this.progressMonitor, 10);
    }

    public void setMonitor(IProgressMonitor newMonitor) {
        this.progressMonitor = newMonitor;
    }

    protected boolean shouldSave(File aFile) {
        if (aFile.isArchive()) {
            return this.getFilter().shouldSave(aFile.getURI(), this.getArchive());
        }
        return super.shouldSave(aFile);
    }

    protected boolean operationHandlesNested(Archive archive) {
        return !this.shouldLinkAsComponentRef(archive);
    }

    protected boolean shouldLinkAsComponentRef(Archive archive) {
        if (this.dataModel != null) {
            List list = (List)this.dataModel.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
            int i = 0;
            while (i < list.size()) {
                if (archive == ((IDataModel)list.get(i)).getProperty("IJ2EEArtifactImportDataModelProperties.FILE")) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean shouldSave(String uri) {
        if (this.overwriteHandler != null) {
            if (this.overwriteHandler.isOverwriteNone()) {
                return false;
            }
            return super.shouldSave(uri) && (this.overwriteHandler.isOverwriteAll() || this.overwriteHandler.isOverwriteResources() || this.overwriteHandler.shouldOverwrite(uri));
        }
        return true;
    }

    protected void updateProjectClasspath(Archive anArchive, IVirtualComponent component) {
        String message = String.valueOf(EARArchiveOpsResourceHandler.Updating_project_classpath_UI_) + component.getName();
        this.progressMonitor.subTask(message);
        ArrayList projectCpEntries = new ArrayList();
        HashSet visited = new HashSet();
        this.traverseClasspaths(component.getProject(), anArchive, projectCpEntries, visited);
        try {
            if (!projectCpEntries.isEmpty()) {
                JemProjectUtilities.appendJavaClassPath((IProject)component.getProject(), projectCpEntries);
            }
            JemProjectUtilities.forceClasspathReload((IProject)component.getProject());
        }
        catch (JavaModelException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    protected void traverseClasspaths(IProject p, Archive anArchive, List projectCpEntries, Set visitedArchives) {
        visitedArchives.add(anArchive);
        String[] manifestCpEntries = anArchive.getManifest().getClassPathTokenized();
        EARFile earFile = (EARFile)this.dataModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
        int i = 0;
        while (i < manifestCpEntries.length) {
            String uri = ArchiveUtil.deriveEARRelativeURI((String)manifestCpEntries[i], (Archive)anArchive);
            if (uri != null) {
                File aFile = null;
                try {
                    aFile = earFile.getFile(uri);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                if (aFile != null && aFile.isArchive() && !visitedArchives.contains(aFile)) {
                    Archive depArchive = (Archive)aFile;
                    IProject prereq = null;
                    IVirtualComponent depComponent = (IVirtualComponent)this.createdComponentsMap.get(uri);
                    if (depComponent != null) {
                        prereq = depComponent.getProject();
                    }
                    if (prereq != null) {
                        this.addProjectToClasspath(p, prereq, projectCpEntries);
                    } else {
                        this.addFileToClasspath(p, this.vComponent.getRootFolder().getFile(uri).getUnderlyingFile(), projectCpEntries);
                        this.traverseClasspaths(p, depArchive, projectCpEntries, visitedArchives);
                    }
                }
            }
            ++i;
        }
    }

    protected void updateComponentClasspaths() {
        List jarFiles = this.getEARFile().getArchiveFiles();
        int i = 0;
        while (i < jarFiles.size()) {
            Archive anArchive = (Archive)jarFiles.get(i);
            IVirtualComponent component = (IVirtualComponent)this.createdComponentsMap.get(anArchive.getURI());
            if (component != null) {
                this.updateProjectClasspath(anArchive, component);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualFile vFile = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile iFile = vFile.getUnderlyingFile();
        this.validateEdit(iFile);
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(iFile);
        try {
            try {
                aManifest.write((OutputStream)out);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
            return;
        }
        out.close();
    }
}

