/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.label;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.core.internal.ui.services.IStateProvider;
import org.eclipse.wst.rdb.core.internal.ui.services.StateManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Dependency;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class ServerExplorerLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final IDataToolsUIServiceManager imageService = IDataToolsUIServiceManager.INSTANCE;
    private static final String EXTERNAL_DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.EXTERNAL_DEPENDENCY");
    private static final StateManager stateManager = StateManager.INSTANCE;
    private static final String SPACE = " ";
    private static Color background = null;

    private IStateProvider.State getState(SQLObject sqlObject) {
        return stateManager.getState(sqlObject);
    }

    public static Integer RGBToInteger(RGB rgb) {
        return new Integer(rgb.blue << 16 | rgb.green << 8 | rgb.red);
    }

    public static Color integerToColor(Integer i) {
        if (i == null) {
            return null;
        }
        int color = i;
        return new Color(null, color & 0xFF, (color & 0xFF00) >> 8, (color & 0xFF0000) >> 16);
    }

    public void dispose() {
        if (background != null && !background.isDisposed()) {
            background.dispose();
        }
        background = null;
    }

    public Image getImage(Object element) {
        return imageService.getLabelService(element).getIcon();
    }

    public String getText(Object element) {
        if (element instanceof IVirtualNode) {
            return ((IVirtualNode)element).getDisplayName();
        }
        if (element instanceof Dependency) {
            return EXTERNAL_DEPENDENCY;
        }
        if (element instanceof ENamedElement) {
            SQLSchemaPackage.eINSTANCE.getSQLObject().isSuperTypeOf(((EObject)element).eClass());
            return ((ENamedElement)element).getName();
        }
        return imageService.getLabelService(element).getName();
    }

    public Color getBackground(Object element) {
        IStateProvider.State state;
        if (element instanceof SQLObject && ((state = this.getState((SQLObject)element)) == IStateProvider.State.CREATE || state == IStateProvider.State.ALTER)) {
            return background;
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof SQLObject) {
            IStateProvider.State state = this.getState((SQLObject)element);
            if (state == IStateProvider.State.ALTER) {
                return Display.getCurrent().getSystemColor(3);
            }
            if (state == IStateProvider.State.CREATE) {
                return Display.getCurrent().getSystemColor(15);
            }
        }
        return null;
    }

    public String getDescription(Object element) {
        return imageService.getLabelService(element).getName();
    }

    public void init(ICommonContentExtensionSite aConfig) {
        background = ServerExplorerLabelProvider.integerToColor(ServerExplorerLabelProvider.RGBToInteger(new RGB(232, 242, 254)));
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

