/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.breakpointproviders.AbstractBreakpointProvider;
import org.eclipse.jst.jsp.ui.internal.breakpointproviders.JavascriptLineBreakpoint;
import org.eclipse.ui.IEditorInput;
import org.w3c.dom.Document;

public class JavaScriptBreakpointProvider
extends AbstractBreakpointProvider {
    public boolean canAddBreakpoint(IDocument document, IEditorInput input, int lineNumber, int offset) {
        IResource res = this.getEditorInputResource(input);
        Document doc = null;
        return res != null && !this.isBreakpointExist(res, lineNumber) && this.isValidPosition(document, lineNumber) && JavaScriptBreakpointProvider.getPageLanguage(doc) != 1;
    }

    public IStatus addBreakpoint(IDocument document, IEditorInput input, int lineNumber, int offset) {
        IResource res;
        int pos = this.getValidPosition(document, lineNumber);
        if (pos != -2 && this.canAddBreakpoint(document, input, lineNumber, offset) && (res = this.getEditorInputResource(input)) != null) {
            new JavascriptLineBreakpoint(res, lineNumber, pos, pos);
        }
        return new Status(0, "org.eclipse.jst.jsp.ui", 0, JSPUIMessages.OK, null);
    }

    private boolean isBreakpointExist(IResource res, int lineNumber) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof JavascriptLineBreakpoint) {
                JavascriptLineBreakpoint breakpoint = (JavascriptLineBreakpoint)breakpoints[i];
                try {
                    if (breakpoint.getResource().equals((Object)res) && breakpoint.getLineNumber() == lineNumber) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isValidPosition(IDocument idoc, int lineNumber) {
        return this.getValidPosition(idoc, lineNumber) != -2;
    }

    public IResource getResource(IEditorInput input) {
        return this.getEditorInputResource(input);
    }
}

