/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xsd.ui.internal.adt.design.FlatCCombo;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonSelectionManager;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorMode;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager;
import org.eclipse.wst.xsd.ui.internal.adt.editor.IEditorModeListener;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public abstract class CommonMultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
CommandStackListener,
ITabbedPropertySheetPageContributor,
IPropertyListener,
IEditorModeListener {
    public static int SOURCE_PAGE_INDEX = 1;
    public static int DESIGN_PAGE_INDEX = 0;
    protected IContentOutlinePage fOutlinePage;
    protected DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this){

        public void mouseDown(MouseEvent mouseEvent, EditPartViewer viewer) {
            boolean eatTheEvent = false;
            LayerManager manager = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure layer = manager.getLayer((Object)"Scaled Handle Layer");
            if (layer != null) {
                Point p = new Point(mouseEvent.x, mouseEvent.y);
                layer.translateToRelative((Translatable)p);
                IFigure figure = layer.findFigureAt(p);
                if (figure != null && figure != layer) {
                    eatTheEvent = true;
                }
            }
            if (!eatTheEvent) {
                super.mouseDown(mouseEvent, viewer);
            }
        }
    };
    protected SelectionSynchronizer synchronizer;
    protected ActionRegistry actionRegistry;
    protected StructuredTextEditor structuredTextEditor;
    protected CommonSelectionManager selectionProvider;
    protected ScrollingGraphicalViewer graphicalViewer;
    protected EditorModeManager editorModeManager;
    protected FlatCCombo modeCombo;
    private EditorModeAndCustomizedName[] editorModeAndCustomizedNames;
    protected Composite toolbar;
    protected ModeComboListener modeComboListener;
    protected int maxLength = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public abstract String getContributorId();

    protected abstract void createActions();

    protected void createPages() {
    }

    public void doSave(IProgressMonitor monitor) {
        this.structuredTextEditor.doSave(monitor);
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        this.structuredTextEditor.doSaveAs();
        this.setInput(this.structuredTextEditor.getEditorInput());
        this.setPartName(editor.getTitle());
        this.getCommandStack().markSaveLocation();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = CommonMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)CommonMultiPageEditor.this.structuredTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(CommonMultiPageEditor.this.structuredTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
    }

    public void propertyChanged(Object source, int propId) {
        switch (propId) {
            case 257: 
            case 258: {
                if (source != this.structuredTextEditor || this.structuredTextEditor.getEditorInput() == this.getEditorInput()) break;
                this.setInput(this.structuredTextEditor.getEditorInput());
                Runnable runnable = new Runnable(){

                    public void run() {
                        CommonMultiPageEditor.this._firePropertyChange(1);
                    }
                };
                this.postOnDisplayQue(runnable);
                break;
            }
            case 1: {
                if (source != this.structuredTextEditor || this.structuredTextEditor.getEditorInput() == this.getEditorInput()) break;
                this.setInput(this.structuredTextEditor.getEditorInput());
                break;
            }
            default: {
                if (source != this.structuredTextEditor) break;
                this.firePropertyChange(propId);
            }
        }
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public CommonSelectionManager getSelectionManager() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new CommonSelectionManager(this);
        }
        return this.selectionProvider;
    }

    protected void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    protected void postOnDisplayQue(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.actionRegistry.dispose();
        if (this.structuredTextEditor != null) {
            this.structuredTextEditor.removePropertyListener((IPropertyListener)this);
        }
        this.structuredTextEditor = null;
        this.editDomain = null;
        this.fOutlinePage = null;
        this.synchronizer = null;
        this.actionRegistry = null;
        this.selectionProvider = null;
        this.graphicalViewer = null;
        if (this.modeCombo != null && !this.modeCombo.isDisposed()) {
            this.modeCombo.removeSelectionListener(this.modeComboListener);
            this.modeComboListener = null;
        }
        super.dispose();
    }

    protected CommandStack getCommandStack() {
        return this.editDomain.getCommandStack();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(SOURCE_PAGE_INDEX);
        IDE.gotoMarker((IEditorPart)this.structuredTextEditor, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.initializeActionRegistry();
        String title = null;
        if (this.getEditorInput() != null) {
            title = this.getEditorInput().getName();
        }
        this.setPartName(title);
    }

    protected void initializeActionRegistry() {
        this.createActions();
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getCommandStack();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getActionRegistry();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.getEditorModeManager();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return new IGotoMarker(){

                public void gotoMarker(IMarker marker) {
                    CommonMultiPageEditor.this.gotoMarker(marker);
                }
            };
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return this.getTextEditor();
        }
        return super.getAdapter(type);
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction(iter.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public boolean isDirty() {
        if (this.getCommandStack().isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public StructuredTextEditor getTextEditor() {
        return this.structuredTextEditor;
    }

    protected Composite createGraphPageComposite() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        return parent;
    }

    protected void createGraphPage() {
        Composite parent = this.createGraphPageComposite();
        this.graphicalViewer = this.getGraphicalViewer();
        this.graphicalViewer.createControl(parent);
        this.getEditDomain().addViewer((EditPartViewer)this.graphicalViewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages._UI_LABEL_DESIGN);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.structuredTextEditor ? new MultiPageEditorSite(this, editor){

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() {
        this.structuredTextEditor = new StructuredTextEditor();
        try {
            int index = this.addPage((IEditorPart)this.structuredTextEditor, this.getEditorInput());
            this.setPageText(index, Messages._UI_LABEL_SOURCE);
            this.structuredTextEditor.update();
            this.structuredTextEditor.setEditorPart((IEditorPart)this);
            this.structuredTextEditor.addPropertyListener((IPropertyListener)this);
            this.firePropertyChange(1);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void configureGraphicalViewer() {
        this.graphicalViewer.getControl().setBackground(ColorConstants.listBackground);
        org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart root = new org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart();
        ZoomManager zoomManager = root.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        zoomManager.setZoom(1.0);
        this.graphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)MouseWheelZoomHandler.SINGLETON);
        this.graphicalViewer.setRootEditPart((RootEditPart)root);
        this.graphicalViewer.setEditPartFactory(this.getEditPartFactory());
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.graphicalViewer);
    }

    protected abstract ScrollingGraphicalViewer getGraphicalViewer();

    protected abstract EditPartFactory getEditPartFactory();

    protected abstract void initializeGraphicalViewer();

    protected EditorModeManager getEditorModeManager() {
        if (this.editorModeManager == null) {
            this.editorModeManager = this.createEditorModeManager();
            this.editorModeManager.addListener(this);
            this.editorModeManager.init();
        }
        return this.editorModeManager;
    }

    protected abstract EditorModeManager createEditorModeManager();

    private String getEditModeName(EditorMode editorMode, ProductCustomizationProvider productCustomizationProvider) {
        String customizedName;
        String result = editorMode.getDisplayName();
        if (productCustomizationProvider != null && (customizedName = productCustomizationProvider.getEditorModeDisplayName(editorMode.getId())) != null) {
            result = customizedName;
        }
        return result;
    }

    protected void createViewModeToolbar(Composite parent) {
        boolean showToolBar;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EditorModeManager manager = (EditorModeManager)this.getAdapter(clazz);
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final ProductCustomizationProvider productCustomizationProvider = (ProductCustomizationProvider)this.getAdapter(clazz2);
        EditorMode[] modeList = manager.getModes();
        int modeListLength = modeList.length;
        boolean bl = showToolBar = modeListLength > 1;
        if (showToolBar) {
            EditorModeAndCustomizedName entry;
            this.toolbar = new Composite(parent, 0x800001);
            this.toolbar.setBackground(ColorConstants.white);
            this.toolbar.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Rectangle clientArea = CommonMultiPageEditor.this.toolbar.getClientArea();
                    e.gc.setForeground(ColorConstants.lightGray);
                    e.gc.drawRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1);
                }
            });
            GridLayout gridLayout = new GridLayout(3, false);
            this.toolbar.setLayout((Layout)gridLayout);
            Label label = new Label(this.toolbar, 0x800100);
            label.setBackground(ColorConstants.white);
            label.setText(Messages._UI_LABEL_VIEW);
            label.setLayoutData((Object)new GridData(4));
            this.modeCombo = new FlatCCombo(this.toolbar, 0x800000);
            this.modeCombo.setEditable(false);
            this.modeCombo.setText(this.getEditModeName(manager.getCurrentMode(), productCustomizationProvider));
            GC gc = new GC((Drawable)this.modeCombo);
            int textWidth = 0;
            this.maxLength = 0;
            this.editorModeAndCustomizedNames = new EditorModeAndCustomizedName[modeListLength];
            int i = 0;
            while (i < modeListLength) {
                this.editorModeAndCustomizedNames[i] = entry = new EditorModeAndCustomizedName();
                entry.name = this.getEditModeName(modeList[i], productCustomizationProvider);
                entry.mode = modeList[i];
                ++i;
            }
            Arrays.sort(this.editorModeAndCustomizedNames, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EditorModeAndCustomizedName a = (EditorModeAndCustomizedName)arg0;
                    EditorModeAndCustomizedName b = (EditorModeAndCustomizedName)arg1;
                    return Collator.getInstance().compare(a.name, b.name);
                }
            });
            i = 0;
            while (i < this.editorModeAndCustomizedNames.length) {
                entry = this.editorModeAndCustomizedNames[i];
                this.modeCombo.add(entry.name);
                this.maxLength = Math.max(gc.stringExtent((String)entry.name).x, this.maxLength);
                int approxWidthOfStrings = Math.max(gc.stringExtent((String)entry.name).x, textWidth);
                if (approxWidthOfStrings > this.maxLength) {
                    this.maxLength = approxWidthOfStrings;
                }
                ++i;
            }
            this.maxLength += gc.stringExtent((String)Messages._UI_LABEL_VIEW).x;
            gc.dispose();
            this.modeComboListener = new ModeComboListener();
            this.modeCombo.addSelectionListener(this.modeComboListener);
            this.modeCombo.setLayoutData(new GridData(8));
            this.modeCombo.setBackground(this.toolbar.getBackground());
            ImageHyperlink hyperlink = new ImageHyperlink(this.toolbar, 0x800000);
            hyperlink.setBackground(ColorConstants.white);
            Image image = XSDEditorPlugin.getDefault().getIconImage("etool16/help_contents");
            hyperlink.setImage(image);
            hyperlink.setToolTipText(Messages._UI_HOVER_VIEW_MODE_DESCRIPTION);
            hyperlink.setLayoutData((Object)new GridData(4));
            hyperlink.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (productCustomizationProvider != null) {
                        productCustomizationProvider.handleAction("showEditorModeHelp");
                    }
                }
            });
        }
    }

    protected void storeCurrentModePreference(String id) {
    }

    class EditorModeAndCustomizedName {
        EditorMode mode;
        String name;

        EditorModeAndCustomizedName() {
        }
    }

    protected class ModeComboListener
    implements SelectionListener {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == CommonMultiPageEditor.this.modeCombo) {
                EditorModeManager manager;
                EditorMode[] modeList;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((modeList = (manager = (EditorModeManager)CommonMultiPageEditor.this.getAdapter(clazz)).getModes()).length >= 1) {
                    EditorModeAndCustomizedName entry = CommonMultiPageEditor.this.editorModeAndCustomizedNames[CommonMultiPageEditor.this.modeCombo.getSelectionIndex()];
                    if (manager.getCurrentMode() != entry.mode) {
                        ProductCustomizationProvider productCustomizationProvider;
                        manager.setCurrentMode(entry.mode);
                        CommonMultiPageEditor.this.storeCurrentModePreference(entry.mode.getId());
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((productCustomizationProvider = (ProductCustomizationProvider)CommonMultiPageEditor.this.getAdapter(clazz2)) != null) {
                            productCustomizationProvider.handleAction("editorModeChanged");
                        }
                    }
                }
            }
        }
    }
}

