/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;

public class TaglibClassLoader
extends ClassLoader {
    private static final boolean DEBUG;
    private List jarsList = new ArrayList();
    private List dirsList = new ArrayList();
    private List usedJars = new ArrayList();
    private List usedDirs = new ArrayList();
    private Map failedClasses = new HashMap();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibclassloader");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public TaglibClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
    }

    public void addJar(String filename) {
        if (DEBUG) {
            System.out.println("trying to add: [" + filename + "] to classpath");
        }
        if (!this.jarsList.contains(filename)) {
            this.jarsList.add(filename);
            this.failedClasses = new HashMap();
            if (DEBUG) {
                System.out.println(" + [" + filename + "] added to classpath");
            }
        }
    }

    public void removeJar(String filename) {
        this.jarsList.remove(filename);
        this.failedClasses = new HashMap();
        if (DEBUG) {
            System.out.println("removed: [" + filename + "] from classpath");
        }
    }

    public void addDirectory(String dirPath) {
        if (!this.dirsList.contains(dirPath)) {
            this.dirsList.add(dirPath);
            this.failedClasses = new HashMap();
            if (DEBUG) {
                System.out.println("added: [" + dirPath + "] to classpath");
            }
        }
    }

    public void removeDirectory(String dirPath) {
        this.dirsList.remove(dirPath);
        this.failedClasses = new HashMap();
        if (DEBUG) {
            System.out.println("removed: [" + dirPath + "] from classpath");
        }
    }

    public List getJarsInUse() {
        return this.usedJars;
    }

    public List getDirectoriesInUse() {
        return this.usedDirs;
    }

    Map getFailures() {
        return this.failedClasses;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Class findClass(String className) throws ClassNotFoundException {
        oldClass = this.findLoadedClass(className);
        if (oldClass != null) {
            if (TaglibClassLoader.DEBUG == false) return oldClass;
            System.out.println(">> TaglibClassLoader " + this + " returning existing class: " + className);
            return oldClass;
        }
        if (this.failedClasses.containsKey(className)) {
            if (TaglibClassLoader.DEBUG == false) throw new ClassNotFoundException();
            System.out.println(">> TaglibClassLoader " + this + " known missing class: " + className);
            throw new ClassNotFoundException();
        }
        if (TaglibClassLoader.DEBUG) {
            System.out.println(">> TaglibClassLoader " + this + " finding class: " + className);
        }
        newClass = null;
        jarfile = null;
        entry = null;
        fileName = this.calculateClassFilename(className);
        stream = null;
        try {
            try {
                dirs = this.dirsList.iterator();
                fileToFind = "";
                while (dirs.hasNext()) {
                    dirName = (String)dirs.next();
                    fileToFind = String.valueOf(dirName) + "/" + fileName;
                    f = new File(fileToFind);
                    if (!f.exists()) continue;
                    stream = new FileInputStream(f);
                    this.usedDirs.add(dirName);
                    if (!TaglibClassLoader.DEBUG) break;
                    System.out.println(">> added file from dir: " + dirName + "/" + fileName);
                    break;
                }
                if (stream != null) {
                    byteStream = new ByteArrayOutputStream();
                    buffer = new byte[2048];
                    while (true) {
                        if (stream.available() <= 0) {
                            byteArray = byteStream.toByteArray();
                            try {
                                if (TaglibClassLoader.DEBUG) {
                                    System.out.println(">> defining newClass:" + className);
                                }
                                newClass = this.defineClass(className, byteArray, 0, byteArray.length);
                                this.resolveClass(newClass);
                                break;
                            }
                            catch (ClassCircularityError e) {
                                try {
                                    c = this.getParent().loadClass(className);
                                    if (TaglibClassLoader.DEBUG) {
                                        System.out.println(">> loaded: " + className + " with: " + this.getParent());
                                    }
                                    var26_24 = c;
                                }
                                catch (ClassNotFoundException cnf) {
                                    if (TaglibClassLoader.DEBUG) {
                                        cnf.printStackTrace();
                                    }
                                    Logger.logException("Unrecoverable error loading TEI class " + className, e);
                                    break;
                                }
                                var24_26 = null;
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    if (jarfile == null) return var26_24;
                                    jarfile.close();
                                    return var26_24;
                                }
                                catch (IOException v0) {}
                                return var26_24;
                            }
                            catch (Throwable t) {
                                Logger.logException("Error loading TEI class " + className, t);
                                break;
                            }
                        }
                        amountRead = stream.read(buffer);
                        if (amountRead <= 0) continue;
                        byteStream.write(buffer, 0, amountRead);
                    }
                    stream.close();
                }
                if (stream != null) ** GOTO lbl-1000
                jars = this.jarsList.iterator();
                while (jars.hasNext()) {
                    block48: {
                        jarName = (String)jars.next();
                        f = new File(jarName);
                        if (!f.exists()) continue;
                        try {
                            jarfile = new JarFile(jarName);
                        }
                        catch (IOException e) {
                            if (!TaglibClassLoader.DEBUG) break block48;
                            Logger.logException("bad jar file", e);
                        }
                    }
                    if (jarfile == null) continue;
                    entry = jarfile.getJarEntry(fileName);
                    if (TaglibClassLoader.DEBUG) {
                        System.out.println("looking for filename: " + fileName + " in: " + jarfile.getName());
                    }
                    if (entry != null) {
                        if (TaglibClassLoader.DEBUG) {
                            System.out.println("found the entry: " + entry + " for filename: " + fileName);
                        }
                        if (this.usedJars.contains(jarName)) break;
                        this.usedJars.add(jarName);
                        break;
                    }
                    jarfile.close();
                }
                if (entry != null) {
                    block49: {
                        stream = jarfile.getInputStream(entry);
                        byteStream = new ByteArrayOutputStream();
                        byteLength = entry.getSize();
                        totalBytesRead = 0L;
                        byteBuffer = new byte[10000];
                        while (totalBytesRead < byteLength && (bytesRead = stream.read(byteBuffer)) != -1) {
                            totalBytesRead += (long)bytesRead;
                            byteStream.write(byteBuffer, 0, bytesRead);
                        }
                        byteArray = byteStream.toByteArray();
                        try {
                            if (TaglibClassLoader.DEBUG) {
                                System.out.println(">> defining newClass:" + className);
                            }
                            newClass = this.defineClass(className, byteArray, 0, byteArray.length);
                            this.resolveClass(newClass);
                        }
                        catch (ClassCircularityError e) {
                            try {
                                c = this.getParent().loadClass(className);
                                if (TaglibClassLoader.DEBUG) {
                                    System.out.println(">> loaded: " + className + " with: " + this.getParent());
                                }
                                var26_25 = c;
                            }
                            catch (ClassNotFoundException cnf) {
                                if (TaglibClassLoader.DEBUG) {
                                    cnf.printStackTrace();
                                }
                                Logger.logException("Unrecoverable error loading TEI class " + className, e);
                                break block49;
                            }
                            var24_27 = null;
                            try {}
                            catch (IOException v1) {}
                            if (stream != null) {
                                stream.close();
                            }
                            if (jarfile == null) return var26_25;
                            jarfile.close();
                            return var26_25;
                            return var26_25;
                        }
                        catch (Throwable t) {
                            Logger.logException("Error loading TEI class " + className, t);
                        }
                    }
                    stream.close();
                    jarfile.close();
                }
            }
            catch (Throwable t) {
                this.failedClasses.put(className, t);
                var24_28 = null;
                try {}
                catch (IOException v2) {}
                if (stream != null) {
                    stream.close();
                }
                if (jarfile == null) return null;
                jarfile.close();
                return null;
                return null;
            }
        }
        catch (Throwable var25_39) {
            var24_29 = null;
            try {}
            catch (IOException v3) {}
            if (stream != null) {
                stream.close();
            }
            if (jarfile == null) throw var25_39;
            jarfile.close();
            throw var25_39;
            throw var25_39;
        }
lbl-1000:
        // 2 sources

        {
            var24_30 = null;
        }
        try {}
        catch (IOException v4) {}
        if (stream != null) {
            stream.close();
        }
        if (jarfile != null) {
            jarfile.close();
        }
        if (newClass == null) throw new ClassNotFoundException();
        if (TaglibClassLoader.DEBUG == false) return newClass;
        System.out.println(">> loaded: " + newClass + " with: " + this);
        return newClass;
    }

    private String calculateClassFilename(String name) {
        StringBuffer buffer = new StringBuffer(name.replace('.', '/'));
        if (!name.endsWith(".class")) {
            buffer.append(".class");
        }
        return buffer.toString();
    }
}

