/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.internal.outputview.DialogShowLongField;
import org.eclipse.wst.rdb.internal.outputview.OutputUtil;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.ResultTableModel;
import org.eclipse.wst.rdb.internal.outputview.ResultTableRow;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResultTableViewer {
    protected TextCellEditor stringEditor;
    protected TableViewer tableViewer;
    protected Table table;
    protected ResultTableModel tableModel;
    protected ArrayList tableRows;
    protected TableLayout layout;
    protected Composite parent;
    protected static String BUTTON_TEXT = "...";
    protected ArrayList longColumns;
    protected int butNo = 0;
    protected static final int MAXDISPLAYLENGTH = 60;
    protected TableEditor editor;
    private static MouseListener previousListener;

    protected ResultTableViewer(Composite parent, ResultTableModel model) {
        this.table = new Table(parent, 68356);
        this.parent = parent;
        this.tableModel = model;
        this.tableRows = new ArrayList();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.longColumns = new ArrayList();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider());
        this.tableViewer.setInput((Object)this.tableRows);
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
    }

    protected void refresh() {
        this.tableViewer.refresh();
    }

    protected void clearResult() {
        this.tableRows.clear();
        this.removeColumns();
        this.tableViewer.refresh();
    }

    protected void removeColumns() {
        TableColumn[] columns = this.table.getColumns();
        int count = this.table.getColumnCount();
        int i = 0;
        while (i < count) {
            columns[i].dispose();
            ++i;
        }
        if (this.longColumns != null) {
            Iterator iterLongColumns = this.longColumns.iterator();
            while (iterLongColumns.hasNext()) {
                LongColumnControls longColCtls = (LongColumnControls)iterLongColumns.next();
                Iterator iter = longColCtls.getEditorCells().iterator();
                while (iter.hasNext()) {
                    ((TableEditor)iter.next()).dispose();
                }
                iter = longColCtls.getEditorButtons().iterator();
                while (iter.hasNext()) {
                    ((Button)iter.next()).dispose();
                }
            }
            this.longColumns.clear();
        }
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setColumnNames() {
        if (this.tableModel != null) {
            this.setColumnNames(this.tableModel.getColumnNames(), this.tableModel.getColumnCount());
        }
    }

    protected void setColumnNames(String[] colNames, int numColumns) {
        this.layout = new TableLayout();
        int i = 0;
        while (i < numColumns) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(colNames[i]);
            this.layout.addColumnData((ColumnLayoutData)new ColumnPixelData(80, true));
            column.pack();
            ++i;
        }
        this.table.setLayout((Layout)this.layout);
    }

    protected void setColumnButton(int i, TableItem[] items, LongColumnControls longColumnCtls) {
        TableItem item = items[i];
        TableEditor tableEditor = new TableEditor(this.table);
        Button colButton = new Button((Composite)this.table, 8);
        colButton.setToolTipText(OutputViewPlugin.getString("OV_LOB_COLUMN_TOOLTIP"));
        colButton.setText(BUTTON_TEXT);
        colButton.setSize(colButton.computeSize(-1, -1));
        colButton.setData((Object)new Integer(i));
        tableEditor.horizontalAlignment = 131072;
        tableEditor.minimumWidth = colButton.computeSize((int)-1, (int)-1).x;
        tableEditor.setEditor((Control)colButton, item, longColumnCtls.getColumnIndex());
        longColumnCtls.getEditorCells().add(tableEditor);
        longColumnCtls.getEditorButtons().add(colButton);
        colButton.addSelectionListener((SelectionListener)longColumnCtls.getListener());
    }

    protected void setTableModel(ResultTableModel model) {
        if (this.tableModel == model) {
            return;
        }
        this.tableModel = model;
        if (this.tableModel != null) {
            this.clearResult();
            ArrayList rows = this.tableModel.getTableRows();
            if (rows != null) {
                this.setColumnNames(this.tableModel.getColumnNames(), this.tableModel.getColumnCount());
                this.tableRows.addAll(rows);
                this.refresh();
                this.setupMouseListener();
                this.table.layout(true);
            }
        }
    }

    protected void addColumnButtons() {
        int[] colTypes = this.tableModel.getColumnTypes();
        int[] colLengths = this.tableModel.getColumnLengths();
        String[] colTypeNames = this.tableModel.getColumnTypeNames();
        int col = 0;
        while (col < colTypes.length) {
            if ((colTypes[col] == 12 || colTypes[col] == 1 || colTypes[col] == -4) && colLengths[col] > 60 || colTypes[col] == 2005 || colTypes[col] == 2004 || colTypes[col] == 2000 || colTypes[col] == -1 || colTypes[col] == ResultTableViewer.getXMLJdbcEnumType() && "XML".equalsIgnoreCase(colTypeNames[col])) {
                LongColumnControls longColumnCtls = new LongColumnControls(col);
                this.longColumns.add(longColumnCtls);
                TableItem[] items = this.table.getItems();
                int i = 0;
                while (i < items.length) {
                    ResultTableRow rtr = (ResultTableRow)items[i].getData();
                    int len = rtr.getColumnText(col).length();
                    if (len > 60 || colTypes[col] == ResultTableViewer.getXMLJdbcEnumType()) {
                        this.setColumnButton(i, items, longColumnCtls);
                    }
                    ++i;
                }
            }
            ++col;
        }
    }

    public ResultTableModel getTableModel() {
        return this.tableModel;
    }

    public Document parseXMLText(String xmlText) {
        Document domDocument = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(xmlText);
            InputSource xmlSource = new InputSource(reader);
            domDocument = builder.parse(xmlSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return domDocument;
    }

    public static int getXMLJdbcEnumType() {
        return 1111;
    }

    protected void setupMouseListener() {
        final int[] colTypes = this.tableModel.getColumnTypes();
        final int[] colLengths = this.tableModel.getColumnLengths();
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                int b = evt.button;
                int stateMask = evt.stateMask;
                if (b == 1 && stateMask == 0) {
                    int rowSelected = ResultTableViewer.this.tableViewer.getTable().getSelectionIndex();
                    if (rowSelected == -1) {
                        return;
                    }
                    TableItem tabItem = ResultTableViewer.this.tableViewer.getTable().getItem(rowSelected);
                    int columnSelected = -1;
                    int columns = ResultTableViewer.this.tableViewer.getTable().getColumnCount();
                    int maxColumnCount = columns == 0 ? 0 : columns - 1;
                    Rectangle clientR = ResultTableViewer.this.tableViewer.getTable().getClientArea();
                    Point point = new Point(evt.x, evt.y);
                    int i = 0;
                    while (i <= maxColumnCount) {
                        Rectangle rect = tabItem.getBounds(i);
                        if (rect.y > clientR.y + clientR.height) {
                            return;
                        }
                        if (rect.contains(point)) {
                            columnSelected = i;
                            break;
                        }
                        ++i;
                    }
                    if (columnSelected != -1) {
                        Control oldEditor;
                        int len = colLengths[columnSelected];
                        if (len > 60 || colTypes[columnSelected] == ResultTableViewer.getXMLJdbcEnumType() || colTypes[columnSelected] == -1) {
                            oldEditor = ResultTableViewer.this.editor.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                            ResultTableViewer.this.editor = new TableEditor(ResultTableViewer.this.table);
                            ResultTableViewer.this.editor.horizontalAlignment = 16384;
                            LongColumnControls longColumnCtls = new LongColumnControls(columnSelected);
                            ResultTableViewer.this.longColumns.clear();
                            ResultTableViewer.this.longColumns.add(longColumnCtls);
                            Button button = new Button((Composite)ResultTableViewer.this.tableViewer.getTable(), 8);
                            button.setText(BUTTON_TEXT);
                            button.setToolTipText(OutputViewPlugin.getString("OV_LOB_COLUMN_TOOLTIP"));
                            button.setSize(button.computeSize(-1, -1));
                            button.setData((Object)new Integer(rowSelected));
                            ResultTableViewer.this.editor.minimumWidth = button.computeSize((int)-1, (int)-1).x;
                            ResultTableViewer.this.editor.setEditor((Control)button, tabItem, longColumnCtls.getColumnIndex());
                            longColumnCtls.getEditorCells().add(ResultTableViewer.this.editor);
                            longColumnCtls.getEditorButtons().add(button);
                            button.addSelectionListener((SelectionListener)longColumnCtls.getListener());
                        } else {
                            oldEditor = ResultTableViewer.this.editor.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                        }
                    }
                }
            }
        };
        if (previousListener != null) {
            this.tableViewer.getTable().removeMouseListener(previousListener);
        }
        this.tableViewer.getTable().addMouseListener((MouseListener)listener);
        previousListener = listener;
    }

    protected class ResultContentProvider
    implements IStructuredContentProvider {
        protected ResultContentProvider() {
        }

        public Object[] getElements(Object tableRows) {
            ArrayList rows = (ArrayList)tableRows;
            rows.toArray();
            return rows.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    protected class ResultLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ResultLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof ResultTableRow) {
                String columnText = ((ResultTableRow)object).getColumnText(columnIndex);
                if (columnText != null && columnText.length() > 60) {
                    return columnText.substring(0, 60);
                }
                return columnText;
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }

    protected class ButtonListener
    extends SelectionAdapter {
        protected ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            LongColumnControls longColCtls = null;
            Iterator iterLongColumns = ResultTableViewer.this.longColumns.iterator();
            while (iterLongColumns.hasNext()) {
                longColCtls = (LongColumnControls)iterLongColumns.next();
                if (longColCtls.getListener() == this) break;
            }
            Button button = (Button)e.widget;
            int i = (Integer)button.getData();
            ResultTableRow row = (ResultTableRow)ResultTableViewer.this.tableModel.getTableRows().get(i);
            String[] colNames = ResultTableViewer.this.tableModel.getColumnNames();
            int[] colTypes = ResultTableViewer.this.tableModel.getColumnTypes();
            boolean truncate = false;
            if (colTypes[longColCtls.getColumnIndex()] == ResultTableViewer.getXMLJdbcEnumType()) {
                String title = String.valueOf(colNames[longColCtls.getColumnIndex()]) + " (" + i + "," + longColCtls.getColumnIndex() + ")";
                OutputUtil.launchXMLDialog(ResultTableViewer.this.parent.getShell(), title, row.getXMLColumnContent(longColCtls.getColumnIndex()));
                return;
            }
            if (colTypes[longColCtls.getColumnIndex()] == 2005 || colTypes[longColCtls.getColumnIndex()] == 2004 || colTypes[longColCtls.getColumnIndex()] == 12) {
                Document doc = ResultTableViewer.this.parseXMLText(row.getColumnText(longColCtls.getColumnIndex()));
                if (doc != null) {
                    String title = String.valueOf(colNames[longColCtls.getColumnIndex()]) + " (" + i + "," + longColCtls.getColumnIndex() + ")";
                    OutputUtil.launchXMLDialog(ResultTableViewer.this.parent.getShell(), title, row.getColumnText(longColCtls.getColumnIndex()));
                } else {
                    truncate = false;
                    String title = String.valueOf(colNames[longColCtls.getColumnIndex()]) + " (" + i + "," + longColCtls.getColumnIndex() + ")";
                    DialogShowLongField ddlDialog = new DialogShowLongField(ResultTableViewer.this.parent.getShell(), title, row.getColumnText(longColCtls.getColumnIndex()), truncate);
                    ddlDialog.open();
                }
                return;
            }
            if (colTypes[longColCtls.getColumnIndex()] == -4 || colTypes[longColCtls.getColumnIndex()] == 2004) {
                truncate = false;
            }
            String title = String.valueOf(colNames[longColCtls.getColumnIndex()]) + " (" + i + "," + longColCtls.getColumnIndex() + ")";
            DialogShowLongField ddlDialog = new DialogShowLongField(ResultTableViewer.this.parent.getShell(), title, row.getColumnText(longColCtls.getColumnIndex()), truncate);
            ddlDialog.open();
        }
    }

    protected class LongColumnControls {
        protected ArrayList editorCells;
        protected ArrayList editorButtons;
        protected ButtonListener listener;
        protected int colIndex;

        public LongColumnControls(int aColIndex) {
            this.colIndex = aColIndex;
            this.editorCells = new ArrayList();
            this.editorButtons = new ArrayList();
            this.listener = new ButtonListener();
        }

        public ArrayList getEditorCells() {
            return this.editorCells;
        }

        public ArrayList getEditorButtons() {
            return this.editorButtons;
        }

        public ButtonListener getListener() {
            return this.listener;
        }

        public int getColumnIndex() {
            return this.colIndex;
        }
    }
}

