/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class FilterUtil {
    private static VMDDeltaVisitor _deltaVisitor = null;
    private static VMDResourceVisitor _resourceVisitor = null;

    private FilterUtil() {
    }

    static Map wrapInMap(Set enabledValidators) {
        HashMap result = new HashMap();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return result;
        }
        Iterator iterator = enabledValidators.iterator();
        while (iterator.hasNext()) {
            result.put(iterator.next(), null);
        }
        return result;
    }

    static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("");
        }
    }

    private static Set getResourceDeltas(Map enabledValidators, ValidatorMetaData vmd) {
        HashSet fileDeltas = (HashSet)enabledValidators.get(vmd);
        if (fileDeltas == null) {
            fileDeltas = new HashSet();
            enabledValidators.put(vmd, fileDeltas);
        }
        return fileDeltas;
    }

    private static int getResourceDeltaType(int ifileDeltaType) {
        switch (ifileDeltaType) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    static int getFileDeltaType(int iresourceDeltaType) {
        switch (iresourceDeltaType) {
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 8: {
                return 1;
            }
            case 16: {
                return 3;
            }
        }
        return 2;
    }

    static void addFileDelta(Map enabledValidators, ValidatorMetaData vmd, WorkbenchFileDelta fileDelta) {
        Set fileDeltas = FilterUtil.getResourceDeltas(enabledValidators, vmd);
        fileDeltas.add(fileDelta);
        enabledValidators.put(vmd, fileDeltas);
    }

    public static Map getFileDeltas(Set enabledValidators, Object[] changedResources, boolean filterIn) {
        return FilterUtil.getFileDeltas(enabledValidators, changedResources, 2, filterIn);
    }

    public static Map getFileDeltas(Set enabledValidators, Object[] changedResources, int ifileDeltaType) {
        return FilterUtil.getFileDeltas(enabledValidators, changedResources, ifileDeltaType, false);
    }

    public static Map getFileDeltas(Set enabledValidators, Object[] changedResources, int ifileDeltaType, boolean force) {
        HashMap result = new HashMap();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return result;
        }
        Iterator iterator = enabledValidators.iterator();
        boolean cannotLoad = false;
        IWorkbenchContext helper = null;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            try {
                HashSet<WorkbenchFileDelta> deltas = new HashSet<WorkbenchFileDelta>();
                NullProgressMonitor monitor = new NullProgressMonitor();
                int i = 0;
                while (i < changedResources.length) {
                    Object obj = changedResources[i];
                    WorkbenchFileDelta wfd = null;
                    if (obj instanceof IResource) {
                        IResource res = (IResource)obj;
                        if (force || !FilterUtil.filterOut((IProgressMonitor)monitor, vmd, res, FilterUtil.getResourceDeltaType(ifileDeltaType))) {
                            helper = vmd.getHelper(res.getProject());
                            wfd = FilterUtil.getFileDelta(helper, vmd, res, FilterUtil.getResourceDeltaType(ifileDeltaType));
                        }
                    } else {
                        wfd = new WorkbenchFileDelta(obj);
                    }
                    if (wfd != null) {
                        deltas.add(wfd);
                    }
                    ++i;
                }
                result.put(vmd, deltas);
            }
            catch (InstantiationException exc) {
                cannotLoad = true;
                ValidationRegistryReader.getReader().disableValidator(vmd);
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("FilterUtil::getFileDeltas(Set, Object[], int, boolean)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        if (cannotLoad) {
            Object[] vmds = enabledValidators.toArray();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = (ValidatorMetaData)vmds[i];
                if (vmd.cannotLoad()) {
                    result.remove(vmd);
                }
                ++i;
            }
        }
        return result;
    }

    public static WorkbenchFileDelta getFileDelta(IWorkbenchContext helper, ValidatorMetaData vmd, IResource resource, int iresourceDeltaType) {
        String fileName = helper.getPortableName(resource);
        if (fileName == null) {
            IPath resourcePath;
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("FilterUtil::getFileDelta(IWorkbenchContext, ValidatorMetaData, IResource, int)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NULL_NAME");
                String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NULL_NAME"), resource.getName(), vmd.getValidatorDisplayName());
                entry.setText(result);
                logger.write(Level.SEVERE, (Object)entry);
            }
            if ((resourcePath = resource.getFullPath()) != null) {
                fileName = resourcePath.toString();
            } else {
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("FilterUtil::getFileDelta(IWorkbenchContext, ValidtaorMetaData, IResource, int)");
                    entry.setText("portableName is null and path is null for resource " + resource);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                return null;
            }
        }
        int ifileDeltaType = FilterUtil.getFileDeltaType(iresourceDeltaType);
        return new WorkbenchFileDelta(fileName, ifileDeltaType, resource);
    }

    static boolean addToFileList(Map enabledValidators, IWorkbenchContext helper, ValidatorMetaData vmd, IResource resource, int resourceDelta, boolean isFullBuild) {
        if (vmd == null || resource == null) {
            return false;
        }
        try {
            helper.registerResource(resource);
        }
        catch (Throwable exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("FilterUtil.addToFileList");
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            InternalValidatorManager.getManager().addInternalErrorTask(resource.getProject(), vmd, exc);
        }
        if (isFullBuild) {
            return true;
        }
        WorkbenchFileDelta newFileDelta = FilterUtil.getFileDelta(helper, vmd, resource, resourceDelta);
        if (newFileDelta != null) {
            FilterUtil.addFileDelta(enabledValidators, vmd, newFileDelta);
        }
        return true;
    }

    static boolean filterOut(IProgressMonitor monitor, ValidatorMetaData vmd, IResource resource, int resourceDelta) {
        if (monitor == null) {
            return false;
        }
        FilterUtil.checkCanceled(monitor);
        return !vmd.isApplicableTo(resource, resourceDelta);
    }

    static void filterOut(IProgressMonitor monitor, Map enabledValidators, IResource resource, int resourceDelta, boolean isFullBuild) {
        if (monitor == null) {
            return;
        }
        FilterUtil.checkCanceled(monitor);
        Iterator iterator = enabledValidators.keySet().iterator();
        boolean cannotLoad = false;
        while (iterator.hasNext()) {
            FilterUtil.checkCanceled(monitor);
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            if (FilterUtil.filterOut(monitor, vmd, resource, resourceDelta)) continue;
            try {
                IWorkbenchContext helper = vmd.getHelper(resource.getProject());
                FilterUtil.addToFileList(enabledValidators, helper, vmd, resource, resourceDelta, isFullBuild);
            }
            catch (InstantiationException exc) {
                cannotLoad = true;
                ValidationRegistryReader.getReader().disableValidator(vmd);
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("FilterUtil::filterOut(IProgressMonitor, Map, IResource, int, boolean)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        if (cannotLoad) {
            Object[] vmds = enabledValidators.keySet().toArray();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = (ValidatorMetaData)vmds[i];
                if (vmd.cannotLoad()) {
                    enabledValidators.remove(vmd);
                }
                ++i;
            }
        }
    }

    static void filterOut(IProgressMonitor monitor, Map enabledValidators, IResource resource, IResourceDelta delta) {
        if (FilterUtil.filterOut(delta)) {
            return;
        }
        FilterUtil.filterOut(monitor, enabledValidators, resource, delta.getKind(), false);
    }

    static boolean filterOut(IResourceDelta delta) {
        if (delta == null) {
            return true;
        }
        switch (delta.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return delta.getResource() instanceof IProject;
            }
            case 4: {
                if (!(delta.getResource() instanceof IFile) || (delta.getFlags() & 0x100) == 0) break;
                return false;
            }
        }
        return true;
    }

    static boolean shouldProcess(IResource resource, IResourceDelta delta) {
        if (resource != null && !(resource instanceof IProject)) {
            return true;
        }
        if (delta == null) {
            return false;
        }
        switch (delta.getKind()) {
            case 1: {
                if ((delta.getFlags() & 0x1000) == 0) break;
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                if ((delta.getFlags() & 0x4000) != 0) {
                    return false;
                }
                if ((delta.getFlags() & 0x40000) == 0) break;
                return false;
            }
        }
        return true;
    }

    private static VMDResourceVisitor getResourceVisitor(IProgressMonitor monitor, Set enabledValidators) {
        if (_resourceVisitor == null) {
            _resourceVisitor = new VMDResourceVisitor(){
                private Map _vmdDeltas = null;
                private IProgressMonitor _progressMonitor = null;

                public Map getResult() {
                    return this._vmdDeltas;
                }

                public void setEnabledValidators(Set validators) {
                    this._vmdDeltas = FilterUtil.wrapInMap(validators);
                }

                public IProgressMonitor getProgressMonitor() {
                    return this._progressMonitor;
                }

                public void setProgressMonitor(IProgressMonitor m) {
                    this._progressMonitor = m;
                }

                public boolean visit(IResource res) throws CoreException {
                    FilterUtil.checkCanceled(this.getProgressMonitor());
                    FilterUtil.filterOut(this.getProgressMonitor(), this._vmdDeltas, res, 4, true);
                    return true;
                }
            };
        }
        _resourceVisitor.setProgressMonitor(monitor);
        _resourceVisitor.setEnabledValidators(enabledValidators);
        return _resourceVisitor;
    }

    private static VMDDeltaVisitor getDeltaVisitor(IProgressMonitor monitor, Set enabledValidators) {
        if (_deltaVisitor == null) {
            _deltaVisitor = new VMDDeltaVisitor(){
                private Map _vmdDeltas = null;
                private IProgressMonitor _progressMonitor = null;

                public Map getResult() {
                    return this._vmdDeltas;
                }

                public void setEnabledValidators(Set validators) {
                    this._vmdDeltas = FilterUtil.wrapInMap(validators);
                }

                public IProgressMonitor getProgressMonitor() {
                    return this._progressMonitor;
                }

                public void setProgressMonitor(IProgressMonitor m) {
                    this._progressMonitor = m;
                }

                public boolean visit(IResourceDelta subdelta) throws CoreException {
                    FilterUtil.checkCanceled(this.getProgressMonitor());
                    if (subdelta == null) {
                        return true;
                    }
                    IResource resource = subdelta.getResource();
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.FINEST)) {
                        StringBuffer buffer = new StringBuffer("subdelta of ");
                        buffer.append(resource.getName());
                        buffer.append(" is ");
                        buffer.append(subdelta.getKind());
                        buffer.append(" resource exists? ");
                        buffer.append(resource.exists());
                        buffer.append(" resource.isPhantom?");
                        buffer.append(resource.isPhantom());
                        if (logger.isLoggingLevel(Level.FINEST)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("FilterUtil::visit(IResourceDelta)");
                            entry.setText(buffer.toString());
                            logger.write(Level.FINEST, (Object)entry);
                        }
                    }
                    if (FilterUtil.shouldProcess(resource, subdelta)) {
                        FilterUtil.filterOut(this.getProgressMonitor(), this._vmdDeltas, resource, subdelta);
                        return true;
                    }
                    return false;
                }
            };
        }
        _deltaVisitor.setProgressMonitor(monitor);
        _deltaVisitor.setEnabledValidators(enabledValidators);
        return _deltaVisitor;
    }

    public static Map loadDeltas(IProgressMonitor monitor, Set enabledValidators, IResourceDelta delta) throws CoreException {
        VMDDeltaVisitor visitor = FilterUtil.getDeltaVisitor(monitor, enabledValidators);
        delta.accept((IResourceDeltaVisitor)visitor, true);
        return visitor.getResult();
    }

    public static Map loadDeltas(IProgressMonitor monitor, Set enabledValidators, IProject project) throws CoreException {
        VMDResourceVisitor visitor = FilterUtil.getResourceVisitor(monitor, enabledValidators);
        project.accept((IResourceVisitor)visitor, 2, true);
        return visitor.getResult();
    }

    private static interface VMDRecorder {
        public Map getResult();

        public void setEnabledValidators(Set var1);

        public void setProgressMonitor(IProgressMonitor var1);

        public IProgressMonitor getProgressMonitor();
    }

    private static interface VMDDeltaVisitor
    extends VMDRecorder,
    IResourceDeltaVisitor {
    }

    private static interface VMDResourceVisitor
    extends VMDRecorder,
    IResourceVisitor {
    }
}

