/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHelper;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AddHandlerDialog;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ConfigClientHandlersTableWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private Composite parent_;
    private String outputLocation_;
    private Composite webServiceRefComp_;
    private Combo webServiceRefCombo_;
    private Text webServiceDescText_ = null;
    private Table handlersTable_;
    private TableViewer tableViewer_;
    private Button addButton_;
    private Button removeButton_;
    private Button genSkeletonRadioButton_;
    private Composite sourceLocationComp_;
    private Combo sourceLocationCombo_;
    private HandlerServiceRefHolder[] handlerServiceRefHolder_;
    private HandlerServiceRefHolder currentHSRH_;
    private Hashtable pathsTable_ = new Hashtable();
    private boolean isMultipleSelection_ = false;
    private boolean isGenSkeletonEnabled_;
    private String serviceRefName_;
    private int DEFAULT_COLUMN_WIDTH = 150;
    private final String INFOPOP_HDLR_WS_HANDLERS = "HDLR0001";
    private final String INFOPOP_HDLR_GEN_SKELETON = "HDLR0002";
    private final String INFOPOP_COMBO_SOURCE_LOC = "HDLR0003";
    private final String INFOPOP_WS_CLIENT_REF = "HDLR0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        this.webServiceRefComp_ = uiUtils.createComposite(this.parent_, 2);
        Composite displayComp = new Composite(this.parent_, 0);
        GridLayout gridlayout = new GridLayout(2, false);
        displayComp.setLayout((Layout)gridlayout);
        displayComp.setLayoutData((Object)uiUtils.createFillAll());
        final Composite handlersComp = uiUtils.createComposite(displayComp, 1);
        GridData griddata = new GridData(1810);
        handlersComp.setLayoutData((Object)griddata);
        handlersComp.setSize(130, 600);
        Composite buttonsComp = uiUtils.createComposite(displayComp, 1);
        griddata = new GridData(770);
        buttonsComp.setLayoutData((Object)griddata);
        Text handlersText = new Text(handlersComp, 8);
        handlersText.setText(ConsumptionUIMessages.LABEL_HANDLERS_CONFIG);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        handlersText.setLayoutData((Object)gd);
        this.handlersTable_ = uiUtils.createTable(handlersComp, ConsumptionUIMessages.TOOLTIP_EDIT_WS_HANDLERS, "HDLR0001", 67586);
        this.handlersTable_.setHeaderVisible(true);
        this.handlersTable_.setLinesVisible(true);
        Label wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        Button moveUpButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_UP, null, null);
        GridData muGriddata = new GridData();
        Point musize = moveUpButton.computeSize(-1, -1);
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigClientHandlersTableWidget.this.handleMoveUpButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Button moveDownButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_DOWN, null, null);
        GridData mdGriddata = new GridData();
        Point mdsize = moveDownButton.computeSize(-1, -1);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigClientHandlersTableWidget.this.handleMoveDownButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        this.addButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_ADD, null, null);
        GridData addGriddata = new GridData();
        Point addSize = this.addButton_.computeSize(-1, -1);
        this.addButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigClientHandlersTableWidget.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_REMOVE, null, null);
        GridData remGriddata = new GridData();
        Point remSize = this.removeButton_.computeSize(-1, -1);
        this.removeButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigClientHandlersTableWidget.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enableRemove(false);
        int widthHint = 0;
        int[] sizes = new int[]{musize.x, mdsize.x, addSize.x, remSize.x, 100};
        int j = 0;
        while (j < sizes.length) {
            if (sizes[j] > widthHint) {
                widthHint = sizes[j];
            }
            ++j;
        }
        muGriddata.widthHint = widthHint;
        mdGriddata.widthHint = widthHint;
        addGriddata.widthHint = widthHint;
        remGriddata.widthHint = widthHint;
        moveUpButton.setLayoutData((Object)muGriddata);
        moveDownButton.setLayoutData((Object)mdGriddata);
        this.addButton_.setLayoutData((Object)addGriddata);
        this.removeButton_.setLayoutData((Object)remGriddata);
        String[] columns_ = new String[]{ConsumptionUIMessages.LABEL_HANDLER_NAME, ConsumptionUIMessages.LABLE_HANDLER_CLASS};
        final TableColumn[] tableCols = new TableColumn[columns_.length];
        int i = 0;
        while (i < columns_.length) {
            TableColumn tableColumn = new TableColumn(this.handlersTable_, i);
            tableColumn.setText(columns_[i]);
            tableColumn.setAlignment(16384);
            tableColumn.setWidth(this.DEFAULT_COLUMN_WIDTH);
            tableColumn.setResizable(true);
            tableCols[i] = tableColumn;
            ++i;
        }
        handlersComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = handlersComp.getClientArea();
                Point preferredSize = ConfigClientHandlersTableWidget.this.handlersTable_.computeSize(-1, -1);
                int width = area.width - 2 * ConfigClientHandlersTableWidget.this.handlersTable_.getBorderWidth() - 10;
                if (preferredSize.y > area.height + ConfigClientHandlersTableWidget.this.handlersTable_.getHeaderHeight()) {
                    Point vBarSize = ConfigClientHandlersTableWidget.this.handlersTable_.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ConfigClientHandlersTableWidget.this.handlersTable_.getSize();
                if (oldSize.x > area.width) {
                    tableCols[0].setWidth(width / 2);
                    tableCols[1].setWidth(width - tableCols[0].getWidth());
                    ConfigClientHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                } else {
                    ConfigClientHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                    tableCols[0].setWidth(width / 2);
                    tableCols[1].setWidth(width - tableCols[0].getWidth());
                }
            }
        });
        this.tableViewer_ = new TableViewer(this.handlersTable_);
        Control control = this.tableViewer_.getControl();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)data);
        this.tableViewer_.setColumnProperties(columns_);
        this.tableViewer_.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigClientHandlersTableWidget.this.enableRemove(true);
            }
        });
        this.genSkeletonRadioButton_ = uiUtils.createCheckbox(this.parent_, ConsumptionUIMessages.LABEL_BUTTON_GEN_SKELETON, ConsumptionUIMessages.TOOLTIP_BUTTON_GEN_SKELETON, "HDLR0002");
        this.genSkeletonRadioButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigClientHandlersTableWidget.this.handleGenSkeletonRadioButton();
            }
        });
        this.sourceLocationComp_ = uiUtils.createComposite(this.parent_, 2);
        this.sourceLocationCombo_ = uiUtils.createCombo(this.sourceLocationComp_, ConsumptionUIMessages.LABEL_COMBO_SOURCE_LOC, ConsumptionUIMessages.TOOLTIP_COMBO_SOURCE_LOC, "HDLR0003", 8);
        this.sourceLocationCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigClientHandlersTableWidget.this.handleSourceLocationCombo(evt);
            }
        });
        return this;
    }

    private void populateHandlersTable() {
        try {
            UIUtils uiUtils = new UIUtils(this.pluginId_);
            if (this.isMultipleSelection_) {
                this.webServiceDescText_ = uiUtils.createText(this.webServiceRefComp_, ConsumptionUIMessages.LABEL_COMBO_WS_CLIENT_REF, ConsumptionUIMessages.TOOLTIP_WS_CLIENT_REF, "HDLR0004", 8);
                if (this.handlerServiceRefHolder_ != null) {
                    this.currentHSRH_ = this.handlerServiceRefHolder_[0];
                    String text = NLS.bind((String)ConsumptionUIMessages.MSG_TEXT_NUM_OF_CLIENTS, (Object)Integer.toString(this.handlerServiceRefHolder_.length));
                    this.webServiceDescText_.setText(text);
                }
                this.genSkeletonRadioButton_.setSelection(false);
                this.genSkeletonRadioButton_.setEnabled(false);
                this.genSkeletonRadioButton_.setVisible(false);
                this.sourceLocationComp_.setVisible(false);
                this.sourceLocationCombo_.setEnabled(false);
                this.sourceLocationCombo_.setVisible(false);
                this.refresh();
            } else {
                this.webServiceRefCombo_ = uiUtils.createCombo(this.webServiceRefComp_, ConsumptionUIMessages.LABEL_COMBO_WS_CLIENT_REF, ConsumptionUIMessages.TOOLTIP_WS_CLIENT_REF, "HDLR0004", 8);
                this.webServiceRefCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        ConfigClientHandlersTableWidget.this.handleWebServiceRefCombo(evt);
                    }
                });
                String[] wsRefNames = HandlerServiceRefHelper.getAllServiceRefNames(this.handlerServiceRefHolder_);
                this.webServiceRefCombo_.setItems(wsRefNames);
                if (this.handlerServiceRefHolder_.length < 1) {
                    this.webServiceRefCombo_.select(0);
                    this.webServiceRefCombo_.setEnabled(false);
                } else if (this.serviceRefName_ != null) {
                    int index = this.webServiceRefCombo_.indexOf(this.serviceRefName_);
                    if (index != -1) {
                        this.webServiceRefCombo_.select(index);
                    }
                } else {
                    this.webServiceRefCombo_.select(0);
                }
                HandlerServiceRefHolder hsrh = HandlerServiceRefHelper.getForServiceRefName(this.handlerServiceRefHolder_, this.webServiceRefCombo_.getText());
                if (hsrh != null) {
                    this.currentHSRH_ = hsrh;
                    List handlers = hsrh.getHandlerList();
                    this.tableViewer_.setInput((Object)handlers);
                    this.tableViewer_.refresh();
                }
                this.setSourceOutputLocation();
            }
            this.parent_.getShell().setSize(530, 650);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        if (this.isMultipleSelection_) {
            return StatusUtils.infoStatus((String)ConsumptionUIMessages.PAGE_DESC_MULTIPLE_CLIENTS_CONFIG);
        }
        return finalStatus;
    }

    protected void handleAddButtonSelected(SelectionEvent event) {
        AddHandlerDialog dialog = new AddHandlerDialog(this.parent_.getShell(), true);
        dialog.create();
        dialog.getShell().setSize(500, 200);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getName();
            String className = dialog.getClassName();
            HandlerTableItem hi = new HandlerTableItem();
            hi.setHandlerName(name);
            hi.setHandlerClassName(className);
            ServiceRef serviceRef = this.currentHSRH_.getServiceRef();
            hi.setWsDescRef(serviceRef);
            this.currentHSRH_.getHandlerList().add(hi);
        }
        this.refresh();
    }

    protected void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    protected void handleMoveUpButtonSelected(SelectionEvent event) {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && index > 0 && this.currentHSRH_ != null) {
            List handlers = this.currentHSRH_.getHandlerList();
            Object object = handlers.remove(index);
            handlers.add(index - 1, object);
            this.tableViewer_.refresh();
        }
    }

    protected void handleMoveDownButtonSelected(SelectionEvent event) {
        List handlers;
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && this.currentHSRH_ != null && index < (handlers = this.currentHSRH_.getHandlerList()).size() - 1) {
            Object object = handlers.remove(index);
            handlers.add(index + 1, object);
            this.tableViewer_.refresh();
        }
    }

    protected void handleSourceLocationCombo(SelectionEvent event) {
        this.outputLocation_ = this.sourceLocationCombo_.getText();
        IPath outputPath = (IPath)this.pathsTable_.get(this.outputLocation_);
        this.currentHSRH_.setSourceOutputPath(outputPath);
    }

    protected void handleGenSkeletonRadioButton() {
        if (this.genSkeletonRadioButton_.isEnabled()) {
            if (this.genSkeletonRadioButton_.getSelection()) {
                this.isGenSkeletonEnabled_ = true;
                this.sourceLocationCombo_.setEnabled(true);
            } else {
                this.isGenSkeletonEnabled_ = false;
                this.sourceLocationCombo_.setEnabled(false);
            }
        }
    }

    protected void handleWebServiceRefCombo(SelectionEvent event) {
        if (this.webServiceRefCombo_ != null && this.webServiceRefCombo_.isEnabled()) {
            HandlerServiceRefHolder hsrh;
            this.currentHSRH_ = hsrh = HandlerServiceRefHelper.getForServiceRefName(this.handlerServiceRefHolder_, this.webServiceRefCombo_.getText());
            this.refresh();
        }
        if (this.isGenSkeletonEnabled_) {
            this.setSourceOutputLocation();
        }
    }

    public boolean isGenSkeletonEnabled_() {
        return this.isGenSkeletonEnabled_;
    }

    private void enableRemove(boolean enabled) {
        this.removeButton_.setEnabled(enabled && !this.tableViewer_.getSelection().isEmpty());
    }

    protected void handleDeleteKeyPressed() {
        ISelection selection = this.tableViewer_.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            int selectionIndex = this.handlersTable_.getSelectionIndex();
            if (this.currentHSRH_ != null) {
                this.currentHSRH_.getHandlerList().remove(selectionIndex);
            }
            this.refresh();
        }
    }

    public void refresh() {
        try {
            this.tableViewer_.setInput(null);
            if (this.currentHSRH_ != null) {
                List handlers = this.currentHSRH_.getHandlerList();
                this.tableViewer_.setInput((Object)handlers);
                this.tableViewer_.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGenSkeletonEnabled(boolean isGenSkeletonEnabled) {
        this.isGenSkeletonEnabled_ = isGenSkeletonEnabled;
        this.genSkeletonRadioButton_.setSelection(isGenSkeletonEnabled);
    }

    public boolean getGenSkeletonEnabled() {
        return this.isGenSkeletonEnabled_;
    }

    private void setSourceOutputLocation() {
        if (this.currentHSRH_ != null) {
            IProject project = this.currentHSRH_.getProject();
            if (project != null) {
                IPath[] locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
                String[] paths = new String[locations.length];
                int i = 0;
                while (i < locations.length) {
                    paths[i] = locations[i].toString();
                    this.pathsTable_.put(paths[i], locations[i]);
                    ++i;
                }
                this.sourceLocationCombo_.setItems(paths);
                this.sourceLocationCombo_.select(0);
            }
            this.outputLocation_ = this.sourceLocationCombo_.getText();
            IPath outputPath = (IPath)this.pathsTable_.get(this.outputLocation_);
            this.currentHSRH_.setSourceOutputPath(outputPath);
        }
    }

    public void internalize() {
        this.populateHandlersTable();
    }

    public void setServiceRefName(String wsRefName) {
        this.serviceRefName_ = wsRefName;
    }

    public void setIsMultipleSelection(boolean isMulitpleSelection) {
        this.isMultipleSelection_ = isMulitpleSelection;
    }

    public void setHandlerServiceRefHolder(HandlerServiceRefHolder[] handlerHolders) {
        this.handlerServiceRefHolder_ = handlerHolders;
    }

    public HandlerServiceRefHolder[] getHandlerServiceRefHolder() {
        return this.handlerServiceRefHolder_;
    }

    protected class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof HandlerTableItem) {
                HandlerTableItem hti = (HandlerTableItem)object;
                if (columnIndex == 0) {
                    return hti.getHandlerName() != null ? hti.getHandlerName() : "";
                }
                if (columnIndex == 1) {
                    return hti.getHandlerClassName() != null ? hti.getHandlerClassName() : "";
                }
            }
            return null;
        }
    }

    protected class ListContentProvider
    implements IStructuredContentProvider {
        protected ListContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof Vector) {
                return ((Vector)element).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }
}

