/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.CommonPublisherAssertionsAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.ShowPublisherAssertionsAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.PublisherAssertionElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.assertion.PublisherAssertion;
import org.uddi4j.response.Result;
import org.uddi4j.transport.TransportException;

public class RemovePublisherAssertionsAction
extends CommonPublisherAssertionsAction {
    public RemovePublisherAssertionsAction(Controller controller) {
        super(controller);
    }

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String[] pubAssertionsViewIds;
        if (this.registryNode_ == null) {
            return false;
        }
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formTool = this.getSelectedFormTool();
        String[] selectedBusIds = parser.getParameterValues("publisherAssertionsSelectedBusID");
        if (selectedBusIds != null && selectedBusIds.length > 0) {
            this.propertyTable_.put("publisherAssertionsSelectedBusID", selectedBusIds);
        }
        this.synchronizeUDDIObjectTable();
        if (!this.isLoggedIn_) {
            String publishURL = parser.getParameter("advancedPublishURL");
            String userID = parser.getParameter("advancedUserId");
            String password = parser.getParameter("advancedPassword");
            if (publishURL != null) {
                this.propertyTable_.put("advancedPublishURL", publishURL);
                formTool.setProperty("advancedPublishURL", publishURL);
            }
            if (!Validator.validateURL(publishURL)) {
                inputsValid = false;
                formTool.flagError("advancedPublishURL");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_PUBLISH_URL"));
            }
            if (userID != null) {
                this.propertyTable_.put("advancedUserId", userID);
                formTool.setProperty("advancedUserId", userID);
            }
            if (!Validator.validateString(userID)) {
                inputsValid = false;
                formTool.flagError("advancedUserId");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USERID"));
            }
            if (password != null) {
                this.propertyTable_.put("advancedPassword", password);
                formTool.setProperty("advancedPassword", password);
            }
        }
        if ((pubAssertionsViewIds = parser.getParameterValues("publisherAssertionsViewId")) == null || pubAssertionsViewIds.length == 0) {
            inputsValid = false;
        } else {
            this.propertyTable_.put("publisherAssertionsViewId", pubAssertionsViewIds);
        }
        return inputsValid;
    }

    /*
     * Unable to fully structure code
     */
    public boolean run() {
        if (this.registryNode_ == null) {
            return false;
        }
        registryElement = (RegistryElement)this.registryNode_.getTreeElement();
        uddiPerspective = this.controller_.getUDDIPerspective();
        messageQueue = uddiPerspective.getMessageQueue();
        navigatorManager = uddiPerspective.getNavigatorManager();
        selectedNode = navigatorManager.getSelectedNode();
        selectedElement = selectedNode.getTreeElement();
        if (!(selectedElement instanceof BusinessElement)) {
            return false;
        }
        if (!this.isLoggedIn_) {
            publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            userID = (String)this.propertyTable_.get("advancedUserId");
            password = (String)this.propertyTable_.get("advancedPassword");
            try {
                registryElement.performLogin(publishURL, userID, password);
            }
            catch (TransportException te) {
                messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
                messageQueue.addMessage("TransportException");
                messageQueue.addMessage(te.getMessage());
                return false;
            }
            catch (UDDIException uddie) {
                messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
                messageQueue.addMessage("UDDIException");
                messageQueue.addMessage(uddie.toString());
                return false;
            }
            catch (MalformedURLException me) {
                messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
                messageQueue.addMessage("MalformedURLException");
                messageQueue.addMessage(me.getMessage());
                return false;
            }
        }
        proxy = registryElement.getProxy();
        registryElement.getUserId();
        registryElement.getCred();
        busElement = (BusinessElement)selectedElement;
        pubAssertions = busElement.getPublisherAssertions();
        if (!this.isBusinessOwned(busElement)) {
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_NOT_OWNED_BUSINESS"));
            return false;
        }
        try {
            pubAssertionViewIds = (String[])this.propertyTable_.get("publisherAssertionsViewId");
            pubAssertionVector = new Vector<PublisherAssertion>();
            refreshRequired = false;
            i = 0;
            while (i < pubAssertionViewIds.length) {
                viewID = Integer.parseInt(pubAssertionViewIds[i]);
                listElement = pubAssertions.getElementWithViewId(viewID);
                pubAssertionElement = (PublisherAssertionElement)listElement.getObject();
                pubAssertion = pubAssertionElement.getPublisherAssertion();
                pubAssertionVector.add(pubAssertion);
                if (pubAssertionElement.getStatus().equals("status:complete")) {
                    refreshRequired = true;
                }
                ++i;
            }
            report = proxy.delete_publisherAssertions(registryElement.getAuthInfoString(), pubAssertionVector);
            reportErrInfo = report.getResultVector();
            i = 0;
            while (i < reportErrInfo.size()) {
                messageQueue.addMessage(((Result)reportErrInfo.get(i)).getErrInfo().getText());
                ++i;
            }
            if (refreshRequired) {
                showPAAction = new ShowPublisherAssertionsAction(this.controller_);
                propertyTable = showPAAction.getPropertyTable();
                ids = this.propertyTable_.get("publisherAssertionsSelectedBusID");
                if (ids != null) {
                    propertyTable.put("publisherAssertionsSelectedBusID", ids);
                }
                showPAAction.run();
            } else {
                k = 0;
                while (k < pubAssertionViewIds.length) {
                    pubAssertions.removeElementWithViewId(Integer.parseInt(pubAssertionViewIds[k]));
                    ++k;
                }
            }
            return report.success();
        }
        catch (UDDIException uddie) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            report = uddie.getDispositionReport();
            reportErrInfo = report.getResultVector();
            i = 0;
            ** while (i < reportErrInfo.size())
        }
lbl-1000:
        // 1 sources

        {
            messageQueue.addMessage(((Result)reportErrInfo.get(i)).getErrInfo().getText());
            ++i;
            continue;
        }
lbl92:
        // 1 sources

        return false;
        catch (Exception e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("Exception");
            messageQueue.addMessage(e.getMessage());
            return false;
        }
    }
}

