/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.CopyOnWriteSet;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;

public class RuntimesPropertyPage
extends PropertyPage {
    private IFacetedProject project;
    private IFacetedProjectListener projectListener;
    private ChangeTargetedRuntimesDataModel model;
    private RuntimesPanel panel;
    private IFile[] validateEditFiles;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                this.project = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {}
            if (this.project == null) {
                return null;
            }
            this.model = new ChangeTargetedRuntimesDataModel();
            this.model.setTargetedRuntimes(this.project.getTargetedRuntimes());
            this.model.setPrimaryRuntime(this.project.getPrimaryRuntime());
            this.model.addRuntimeFilter(new ChangeTargetedRuntimesDataModel.IRuntimeFilter(){

                public boolean check(IRuntime runtime) {
                    IFacetedProject fpj = RuntimesPropertyPage.this.project;
                    Iterator itr = fpj.getProjectFacets().iterator();
                    while (itr.hasNext()) {
                        IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                        if (runtime.supports(fv)) continue;
                        return false;
                    }
                    return true;
                }
            });
            this.projectListener = new IFacetedProjectListener(){

                public void projectChanged() {
                    RuntimesPropertyPage.this.handleProjectChangedEvent();
                }
            };
            this.project.addListener(this.projectListener);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)RuntimesPropertyPage.gdfill());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 5;
            composite.setLayout((Layout)layout);
            this.panel = new RuntimesPanel(composite, 0, this.model);
            this.panel.setLayoutData(RuntimesPropertyPage.gdfill());
            Label hint = new Label(composite, 64);
            hint.setText(Resources.hint);
            GridData gd = RuntimesPropertyPage.gdhfill();
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 300;
            gd.verticalIndent = 5;
            hint.setLayoutData((Object)gd);
            Hyperlink addRemoveLink = new Hyperlink(composite, 0);
            addRemoveLink.setForeground(parent.getDisplay().getSystemColor(10));
            addRemoveLink.setUnderlined(true);
            addRemoveLink.setText(Resources.addRemoveLinkLabel);
            addRemoveLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent evt) {
                    RuntimesPropertyPage.this.performAddRemoveFacets();
                }
            });
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RuntimesPropertyPage.this.handleDisposeEvent();
                }
            });
            return composite;
        }
        return null;
    }

    public boolean performOk() {
        CopyOnWriteSet targeted = new CopyOnWriteSet();
        targeted.addAll(this.model.getTargetedRuntimes());
        IRuntime primary = this.model.getPrimaryRuntime();
        if (!this.project.getTargetedRuntimes().equals(primary) || !RuntimesPropertyPage.equals(this.project.getPrimaryRuntime(), primary)) {
            final IWorkspaceRunnable wr = new IWorkspaceRunnable((Set)targeted, primary){
                private final /* synthetic */ Set val$targeted;
                private final /* synthetic */ IRuntime val$primary;
                {
                    this.val$targeted = set;
                    this.val$primary = iRuntime;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFacetedProject fpj = RuntimesPropertyPage.this.project;
                    fpj.setTargetedRuntimes(this.val$targeted, null);
                    if (this.val$primary != null) {
                        fpj.setPrimaryRuntime(this.val$primary, null);
                    }
                }
            };
            Runnable op = new Runnable(){

                public void run() {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    try {
                        if (RuntimesPropertyPage.this.validateEdit()) {
                            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
                        }
                    }
                    catch (CoreException e) {
                        IStatus st = e.getStatus();
                        ErrorDialog.openError((Shell)RuntimesPropertyPage.this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                        FacetUiPlugin.log(st);
                    }
                }
            };
            BusyIndicator.showWhile(null, (Runnable)op);
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.model.setTargetedRuntimes(this.project.getTargetedRuntimes());
        this.model.setPrimaryRuntime(this.project.getPrimaryRuntime());
    }

    private void performAddRemoveFacets() {
        AddRemoveFacetsWizard wizard = new AddRemoveFacetsWizard(this.project);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    private void handleProjectChangedEvent() {
        this.model.refreshTargetableRuntimes();
        Set targetedRuntimes = this.project.getTargetedRuntimes();
        this.model.setTargetedRuntimes(targetedRuntimes);
        IRuntime primaryRuntime = this.project.getPrimaryRuntime();
        this.model.setPrimaryRuntime(primaryRuntime);
    }

    private void handleDisposeEvent() {
        this.project.removeListener(this.projectListener);
        this.model.dispose();
    }

    private static boolean equals(IRuntime r1, IRuntime r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    private static GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static GridData gdhfill() {
        return new GridData(768);
    }

    private boolean validateEdit() {
        IStatus status;
        if (this.validateEditFiles == null || this.validateEditFiles.length == 0) {
            this.validateEditFiles = new IFile[3];
            this.validateEditFiles[0] = this.project.getProject().getFile(".classpath");
            this.validateEditFiles[1] = this.project.getProject().getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
            this.validateEditFiles[2] = this.project.getProject().getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs");
        }
        if (!(status = ResourcesPlugin.getWorkspace().validateEdit(this.validateEditFiles, (Object)this.getShell())).isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Resources.errDlgTitle, (String)status.getMessage(), (IStatus)status);
        }
        return status.isOK();
    }

    private static final class Resources
    extends NLS {
        public static String errDlgTitle;
        public static String hint;
        public static String addRemoveLinkLabel;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPropertyPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPropertyPage$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

