/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.util;

import java.io.File;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.core.internal.ui.services.IAlternateEditorInput;
import org.eclipse.wst.rdb.core.internal.ui.services.IAlternateSQLEditor;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public class AlternateSQLEditorHelper {
    private static final String ALTERNATE_SQL_EDITOR_EXT_POINT = "org.eclipse.wst.rdb.core.ui.alternateSQLEditor";
    private static final String ALTERNATE_SQL_EDITOR_ID = "id";
    private static final String ALTERNATE_SQL_EDITOR_CLASS = "class";

    public static IExtension[] getAlternateSQLEditors() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(ALTERNATE_SQL_EDITOR_EXT_POINT);
        return extensionPoint.getExtensions();
    }

    public static String getAlternateSQLEditorID(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            try {
                IConfigurationElement currentConfigElement = configElements[i];
                String editorID = currentConfigElement.getAttribute(ALTERNATE_SQL_EDITOR_ID);
                return editorID;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return "";
    }

    public static void launchAlternateEditor(IExtension extension, File sqlFile, ConnectionInfo connection) {
        if (extension == null) {
            return;
        }
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            try {
                IConfigurationElement currentConfigElement = configElements[i];
                String editorID = currentConfigElement.getAttribute(ALTERNATE_SQL_EDITOR_ID);
                IAlternateSQLEditor extEditor = (IAlternateSQLEditor)currentConfigElement.createExecutableExtension(ALTERNATE_SQL_EDITOR_CLASS);
                IAlternateEditorInput input = extEditor.getEditorInput(sqlFile, connection);
                if (connection != null) {
                    input.setConnectionInfo(connection);
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorID);
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public static void launchAlternateEditor(IExtension extension, IFile sqlFile, ConnectionInfo connection) {
        if (extension == null) {
            return;
        }
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            try {
                IConfigurationElement currentConfigElement = configElements[i];
                String editorID = currentConfigElement.getAttribute(ALTERNATE_SQL_EDITOR_ID);
                IAlternateSQLEditor extEditor = (IAlternateSQLEditor)currentConfigElement.createExecutableExtension(ALTERNATE_SQL_EDITOR_CLASS);
                IAlternateEditorInput input = extEditor.getEditorInput(sqlFile, connection);
                if (connection != null) {
                    input.setConnectionInfo(connection);
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorID);
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public static void launchAlternateEditor(IExtension extension, StringWriter writer, String inputTitle, ConnectionInfo connection) {
        if (extension == null) {
            return;
        }
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            try {
                IConfigurationElement currentConfigElement = configElements[i];
                String editorID = currentConfigElement.getAttribute(ALTERNATE_SQL_EDITOR_ID);
                IAlternateSQLEditor extEditor = (IAlternateSQLEditor)currentConfigElement.createExecutableExtension(ALTERNATE_SQL_EDITOR_CLASS);
                IAlternateEditorInput input = extEditor.getEditorInput(writer, inputTitle, connection);
                if (connection != null) {
                    input.setConnectionInfo(connection);
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorID);
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }
}

