/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.extract;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.rdb.data.internal.core.DataCorePlugin;
import org.eclipse.wst.rdb.data.internal.core.common.Output;
import org.eclipse.wst.rdb.data.internal.core.common.data.DataSerializer;
import org.eclipse.wst.rdb.data.internal.core.common.data.ResultSetReader;
import org.eclipse.wst.rdb.data.internal.core.extract.Messages;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class ExtractData {
    protected Connection connection;
    protected Table table;
    protected String filePath;
    protected String colDelim = ",";
    protected static final String ENDL = System.getProperty("line.separator");
    protected String stringDelim = "\"";
    protected HashSet errorColumns = new HashSet();
    protected int rowsExtracted = 0;

    public ExtractData(Table table, String filePath) {
        this.connection = ((ICatalogObject)table).getConnection();
        this.table = table;
        this.filePath = filePath;
    }

    public void setDelims(String colDelim, String stringDelim) {
        this.colDelim = colDelim;
        this.stringDelim = stringDelim;
    }

    public int doExtract(Output output) {
        output.write(String.valueOf(Messages.getString("ExtractData.Extracting")) + " " + this.getFullyQualifiedName() + "...");
        try {
            this.doExtract1();
        }
        catch (Exception ex) {
            DataCorePlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            output.write(ex.toString());
            output.write(Messages.getString("ExtractData.DataExtractionFailed"));
            return 4;
        }
        output.write(Messages.getString("ExtractData.DataExtractionSuccessful"));
        output.write(String.valueOf(String.valueOf(this.rowsExtracted)) + Messages.getString("ExtractData.RowsExtracted"));
        if (this.errorColumns.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("ExtractData.ErrorRetrieving"));
            Iterator it = this.errorColumns.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            output.write(sb.toString());
            return 3;
        }
        return 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExtract1() throws SQLException, IOException {
        BufferedWriter fw;
        Statement st;
        block6: {
            st = null;
            ResultSet rs = null;
            fw = null;
            try {
                st = this.connection.createStatement();
                rs = st.executeQuery(this.getQuery());
                FileOutputStream fos = new FileOutputStream(this.filePath);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                fw = new BufferedWriter(osw);
                this.writeData(rs, fw);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (fw == null) throw throwable;
                fw.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (rs == null) break block6;
            }
            rs.close();
        }
        if (st != null) {
            st.close();
        }
        if (fw == null) return;
        fw.close();
    }

    protected void writeData(ResultSet rs, Writer fw) throws SQLException, IOException {
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            int i = 0;
            while (i < md.getColumnCount()) {
                String s;
                if (i != 0) {
                    fw.write(this.colDelim);
                }
                if ((s = this.getVal(rs, i)) != null) {
                    fw.write(s);
                }
                ++i;
            }
            ++this.rowsExtracted;
            fw.write(ENDL);
        }
    }

    public String getVal(ResultSet rs, int column) throws SQLException, IOException {
        ResultSetMetaData md = rs.getMetaData();
        try {
            Object o = ResultSetReader.read(rs, column);
            String s = DataSerializer.write(o, md.getColumnType(column + 1), this.stringDelim);
            return s;
        }
        catch (Exception ex) {
            DataCorePlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            this.errorColumns.add(md.getColumnName(column + 1));
            return null;
        }
    }

    protected String getQuery() {
        return "select * from " + this.getFullyQualifiedName();
    }

    protected String getFullyQualifiedName() {
        return DataCorePlugin.getQualifiedTableName(this.table);
    }
}

