/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DuplicatesTable
extends HashMap {
    private static final long serialVersionUID = -3189901849555229718L;
    protected static final Boolean UNIQUE = Boolean.FALSE;
    protected static final Boolean DUPLICATE = Boolean.TRUE;
    protected Map _duplicates = null;

    public void add(Object o) {
        Object key = this.get(o);
        if (key == null) {
            this.put(o, UNIQUE);
        } else {
            this.saveDuplicate(o);
            this.put(o, DUPLICATE);
        }
    }

    protected void saveDuplicate(Object o) {
        ArrayList<Object> dupList;
        if (this._duplicates == null) {
            this._duplicates = new HashMap();
        }
        if ((dupList = (ArrayList<Object>)this._duplicates.get(o)) == null) {
            dupList = new ArrayList<Object>();
        }
        dupList.add(o);
        this._duplicates.put(o, dupList);
    }

    public boolean containsDuplicates() {
        return this.containsValue(DUPLICATE);
    }

    public boolean containsUniques() {
        return this.containsValue(UNIQUE);
    }

    public List getDuplicates() {
        if (!this.containsDuplicates()) {
            return Collections.EMPTY_LIST;
        }
        return this.getElements(DUPLICATE);
    }

    private List getElements(Boolean type) {
        if (type == null) {
            return Collections.EMPTY_LIST;
        }
        Set keys = this.keySet();
        if (keys == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList elements = new ArrayList();
        Iterator<Object> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = this.get(key);
            if (value != type) continue;
            elements.add(key);
        }
        if (type == DUPLICATE && this._duplicates != null) {
            iterator = this._duplicates.values().iterator();
            while (iterator.hasNext()) {
                List dupList = (List)iterator.next();
                elements.addAll(dupList);
            }
        }
        return elements;
    }

    public List getUniques() {
        if (!this.containsUniques()) {
            return Collections.EMPTY_LIST;
        }
        return this.getElements(UNIQUE);
    }

    public void clear() {
        super.clear();
        if (this._duplicates != null) {
            this._duplicates.clear();
        }
    }
}

