/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.IConnectionContainer;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TypeReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.IADTUpdateCommand;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;

public abstract class BaseTypeConnectingEditPart
extends BaseEditPart
implements IFeedbackHandler,
IConnectionContainer {
    private TypeReferenceConnection connectionFigure;

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        this.deactivateConnection();
        super.deactivate();
    }

    public void refreshConnections() {
        this.deactivateConnection();
        this.activateConnection();
    }

    protected void activateConnection() {
        if (this.connectionFigure == null && this.shouldDrawConnection()) {
            this.connectionFigure = this.createConnectionFigure();
            if (this.connectionFigure != null) {
                this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
            }
        }
    }

    protected void deactivateConnection() {
        if (this.connectionFigure != null) {
            this.getLayer("Connection Layer").remove((IFigure)this.connectionFigure);
            this.connectionFigure = null;
        }
    }

    protected boolean shouldDrawConnection() {
        return true;
    }

    public abstract TypeReferenceConnection createConnectionFigure();

    public void addFeedback() {
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(true);
        }
    }

    public void removeFeedback() {
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(false);
        }
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }

    public EditPart doGetRelativeEditPart(EditPart editPart, int direction) {
        EditPart result = null;
        if (direction == 8) {
            result = this.getSourceConnectionEditPart();
        }
        return result;
    }

    private EditPart getSourceConnectionEditPart() {
        EditPart result = null;
        Iterator i = this.getLayer("Connection Layer").getChildren().iterator();
        while (i.hasNext()) {
            TypeReferenceConnection typeReferenceConnection;
            ConnectionAnchor targetAnchor;
            Figure figure = (Figure)i.next();
            if (!(figure instanceof TypeReferenceConnection) || (targetAnchor = (typeReferenceConnection = (TypeReferenceConnection)figure).getTargetAnchor()).getOwner() != this.getFigure()) continue;
            ConnectionAnchor sourceAnchor = typeReferenceConnection.getSourceAnchor();
            IFigure sourceFigure = sourceAnchor.getOwner();
            EditPart part = null;
            while (part == null && sourceFigure != null) {
                part = (EditPart)this.getViewer().getVisualPartMap().get(sourceFigure);
                sourceFigure = sourceFigure.getParent();
            }
            result = part;
            break;
        }
        return result;
    }

    protected class NameUpdateCommandWrapper
    extends Command
    implements IADTUpdateCommand {
        Command command;
        protected DirectEditRequest request;

        public NameUpdateCommandWrapper() {
            super(Messages._UI_ACTION_UPDATE_NAME);
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            IType iType = (IType)BaseTypeConnectingEditPart.this.getModel();
            Object newValue = this.request.getCellEditor().getValue();
            if (newValue instanceof String) {
                this.command = iType.getUpdateNameCommand((String)newValue);
            }
            if (this.command != null) {
                this.command.execute();
            }
        }
    }
}

