/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.eclipse.jst.jsp.core.internal.contenttype.HeadParserToken;
import org.eclipse.jst.jsp.core.internal.contenttype.IntStack;

public class JSPHeadTokenizer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 8192;
    public static final int YYINITIAL = 0;
    public static final int UnDelimitedString = 12;
    public static final int DQ_STRING = 8;
    public static final int SQ_STRING = 10;
    public static final int ST_XMLDecl = 2;
    public static final int ST_PAGE_DIRECTIVE = 4;
    public static final int QuotedAttributeValue = 6;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0006\u0001\t\u0002\u0000\u0001\b\u0012\u0000\u0001\u001c\u0001\u000f\u0001\u001f\u0002\u0000\u0001)\u0001\u0000\u0001 \u0006\u0000\u0001#\u0001\u001b\u0001\u0000\u0001'\u0001\u0000\u0001$\u0005\u0000\u0001(\u0001!\u0001\u0000\u0001\n\u0001\u0007\u0001.\u0001\u000b\u0001*\u0001+\u0001\u0019\u0001\u0012\u0001\u0010\u0001\u0016\u0001\u0000\u0001&\u0001\u0017\u0001\u001a\u0001,\u0001\u0000\u0001\u000e\u0001\r\u0001\u001d\u0001\u0011\u0001\u0015\u0001\u0000\u0001%\u0001\u001e\u0001\u0013\u0001\u0018\u0001-\u0001\"\u0001\f\u0001\u0014\u0007\u0000\u0001+\u0001\u0019\u0001\u0012\u0001\u0010\u0001\u0016\u0001\u0000\u0001&\u0001\u0017\u0001\u001a\u0001,\u0001\u0000\u0001\u000e\u0001\r\u0001\u001d\u0001\u0011\u0001\u0015\u0001\u0000\u0001%\u0001\u001e\u0001\u0013\u0001\u0018\u0001-\u0001\"\u0001\f\u0001\u0014A\u0000\u0001\u0004\u0003\u0000\u0001\u0005\u000f\u0000\u0001\u0003\u000e\u0000\u0001\u0001\u0010\u0000\u0001\u0003\u000e\u0000\u0001\u0001\u0001\u0002x\u0000\u0001\u0002\ufe87\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\b\u0000\u0010\u0001\u0002\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0002\u0005\u0001\u0007\u0001\b\u0002\t\u0004\u0000\u0001\n\u0001\u000b\u0006\u0000\u0001\f\u0005\u0000\u0001\r\u0001\u000e\u0001\u0000\u0001\u000f\u0001\u0000\u0001\u0010\u0004\u0000\u0001\u0011!\u0000\u0001\u0012\u0007\u0000\u0001\u0013\n\u0000\u0001\u0014\u0006\u0000\u0001\u0015\u0001\u0016\u0012\u0000\u0001\u0017\u0005\u0000\u0001\u0018*\u0000\u0001\u0019\u0005\u0000\u0001\u001a\n\u0000\u0001\u001a";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[8192];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yychar;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private boolean hasMore = true;
    private static final int MAX_TO_SCAN = 8000;
    StringBuffer string = new StringBuffer();
    private IntStack fStateStack = new IntStack();
    private String valueText = null;
    private boolean isXHTML;
    private boolean isWML;

    static {
        int[] nArray = new int[14];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 5;
        nArray[10] = 6;
        nArray[11] = 6;
        nArray[12] = 7;
        nArray[13] = 7;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = JSPHeadTokenizer.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = JSPHeadTokenizer.zzUnpackAction();
        ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[214];
        int offset = 0;
        offset = JSPHeadTokenizer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public JSPHeadTokenizer() {
    }

    public void reset(Reader in) {
        this.zzReader = in;
        this.zzState = 0;
        this.zzLexicalState = 0;
        Arrays.fill(this.zzBuffer, '\u0000');
        this.zzMarkedPos = 0;
        this.zzPushbackPos = 0;
        this.zzCurrentPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.yychar = 0;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.fStateStack.clear();
        this.hasMore = true;
        this.isXHTML = false;
        this.isWML = false;
    }

    public final HeadParserToken getNextToken() throws IOException {
        String context = null;
        context = this.primGetNextToken();
        HeadParserToken result = null;
        if (this.valueText != null) {
            result = this.createToken(context, this.yychar, this.valueText);
            this.valueText = null;
        } else {
            result = this.createToken(context, this.yychar, this.yytext());
        }
        return result;
    }

    public final boolean hasMoreTokens() {
        return this.hasMore && this.yychar < 8000;
    }

    private void pushCurrentState() {
        this.fStateStack.push(this.yystate());
    }

    private void popState() {
        this.yybegin(this.fStateStack.pop());
    }

    private HeadParserToken createToken(String context, int start, String text) {
        return new HeadParserToken(context, start, text);
    }

    public boolean isXHTML() {
        return this.isXHTML;
    }

    public boolean isWML() {
        return this.isWML;
    }

    public JSPHeadTokenizer(Reader in) {
        this.zzReader = in;
    }

    public JSPHeadTokenizer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 192) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yychar = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.hasMore = false;
        }
    }

    public String primGetNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        block935: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            if (zzMarkedPosL > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        eof = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            block936: while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                zzInput = zzCMapL[zzInput];
                boolean zzIsFinal = false;
                boolean zzNoLookAhead = false;
                block4 : switch (this.zzState) {
                    case 0: {
                        switch (zzInput) {
                            case 10: {
                                zzIsFinal = true;
                                this.zzState = 9;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 8;
                        break;
                    }
                    case 1: {
                        switch (zzInput) {
                            case 1: {
                                zzIsFinal = true;
                                this.zzState = 10;
                                break block4;
                            }
                            case 2: {
                                zzIsFinal = true;
                                this.zzState = 11;
                                break block4;
                            }
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 12;
                                break block4;
                            }
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 13;
                                break block4;
                            }
                            case 10: {
                                zzIsFinal = true;
                                this.zzState = 14;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 8;
                        break;
                    }
                    case 2: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 15;
                                break block4;
                            }
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 16;
                                break block4;
                            }
                            case 22: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block4;
                            }
                            case 45: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 8;
                        break;
                    }
                    case 3: {
                        switch (zzInput) {
                            case 14: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block4;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 20;
                                break block4;
                            }
                            case 21: {
                                zzIsFinal = true;
                                this.zzState = 21;
                                break block4;
                            }
                            case 27: {
                                zzIsFinal = true;
                                this.zzState = 22;
                                break block4;
                            }
                            case 41: {
                                zzIsFinal = true;
                                this.zzState = 23;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 8;
                        break;
                    }
                    case 4: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block4;
                            }
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 26;
                                break block4;
                            }
                            case 31: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 27;
                                break block4;
                            }
                            case 32: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 28;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 24;
                        break;
                    }
                    case 5: {
                        switch (zzInput) {
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 30;
                                break block4;
                            }
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 31;
                                break block4;
                            }
                            case 31: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 32;
                                break block4;
                            }
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 33;
                                break block4;
                            }
                            case 41: {
                                zzIsFinal = true;
                                this.zzState = 34;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 29;
                        break;
                    }
                    case 6: {
                        switch (zzInput) {
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 30;
                                break block4;
                            }
                            case 41: {
                                zzIsFinal = true;
                                this.zzState = 34;
                                break block4;
                            }
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 29;
                        break;
                    }
                    case 7: {
                        switch (zzInput) {
                            case 11: 
                            case 41: {
                                zzIsFinal = true;
                                this.zzState = 34;
                                break block4;
                            }
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 36;
                                break block4;
                            }
                            case 31: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 37;
                                break block4;
                            }
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 29;
                        break;
                    }
                    case 9: {
                        switch (zzInput) {
                            case 15: {
                                this.zzState = 39;
                                break block4;
                            }
                            case 23: {
                                this.zzState = 40;
                                break block4;
                            }
                            case 41: {
                                this.zzState = 41;
                                break block4;
                            }
                            case 44: {
                                this.zzState = 42;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 10: {
                        switch (zzInput) {
                            case 2: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 43;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 11: {
                        switch (zzInput) {
                            case 1: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 44;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 12: {
                        switch (zzInput) {
                            case 4: {
                                this.zzState = 45;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 13: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                this.zzState = 46;
                                break block4;
                            }
                            case 10: {
                                this.zzState = 47;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 14: {
                        switch (zzInput) {
                            case 15: {
                                this.zzState = 39;
                                break block4;
                            }
                            case 23: {
                                this.zzState = 40;
                                break block4;
                            }
                            case 41: {
                                this.zzState = 41;
                                break block4;
                            }
                            case 44: {
                                this.zzState = 42;
                                break block4;
                            }
                            case 11: {
                                this.zzState = 48;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 15: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                this.zzState = 49;
                                break block4;
                            }
                            case 11: {
                                this.zzState = 50;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 16: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 51;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 17: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 52;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 18: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 53;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 19: {
                        switch (zzInput) {
                            case 43: {
                                this.zzState = 54;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 20: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 55;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 21: {
                        switch (zzInput) {
                            case 43: {
                                this.zzState = 56;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 22: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 57;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 23: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 58;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 25: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                            case 9: {
                                this.zzState = 59;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 24;
                        break;
                    }
                    case 26: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block4;
                            }
                            case 9: {
                                this.zzState = 59;
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 24;
                        break;
                    }
                    case 31: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 60;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 33: {
                        switch (zzInput) {
                            case 10: {
                                this.zzState = 61;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 34: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 62;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 35: {
                        switch (zzInput) {
                            case 10: {
                                this.zzState = 61;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 38: {
                        switch (zzInput) {
                            case 10: {
                                this.zzState = 61;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 39: {
                        switch (zzInput) {
                            case 16: {
                                this.zzState = 63;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 40: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 64;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 41: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 42: {
                                this.zzState = 65;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 42: {
                        switch (zzInput) {
                            case 30: {
                                this.zzState = 66;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 45: {
                        switch (zzInput) {
                            case 5: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 67;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 46: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 10: {
                                this.zzState = 47;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 47: {
                        switch (zzInput) {
                            case 11: {
                                this.zzState = 48;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 48: {
                        switch (zzInput) {
                            case 12: {
                                this.zzState = 68;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 49: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 11: {
                                this.zzState = 50;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 50: {
                        switch (zzInput) {
                            case 46: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 51;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 52: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 69;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 53: {
                        switch (zzInput) {
                            case 37: {
                                this.zzState = 70;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 54: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 71;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 55: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 72;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 56: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 73;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 59: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block4;
                            }
                            case 9: {
                                break block4;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 24;
                        break;
                    }
                    case 61: {
                        switch (zzInput) {
                            case 32: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 30;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 63: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 74;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 64: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 75;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 65: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 19: {
                                this.zzState = 76;
                                break block4;
                            }
                            case 21: {
                                this.zzState = 77;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 66: {
                        switch (zzInput) {
                            case 21: {
                                this.zzState = 78;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 68: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 79;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 69: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 80;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 70: {
                        switch (zzInput) {
                            case 30: {
                                this.zzState = 81;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 71: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 82;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 72: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 83;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 73: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 84;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 74: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 85;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 75: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 86;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 76: {
                        switch (zzInput) {
                            case 43: {
                                this.zzState = 87;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 77: {
                        switch (zzInput) {
                            case 43: {
                                this.zzState = 88;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 78: {
                        switch (zzInput) {
                            case 33: {
                                this.zzState = 89;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 79: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 90;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 80: {
                        switch (zzInput) {
                            case 16: {
                                this.zzState = 91;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 81: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 92;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 82: {
                        switch (zzInput) {
                            case 24: {
                                this.zzState = 93;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 83: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 94;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 84: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 95;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 85: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 96;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 86: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 12: {
                                this.zzState = 97;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 87: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 98;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 88: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 99;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 89: {
                        switch (zzInput) {
                            case 16: {
                                this.zzState = 100;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 90: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 101;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 91: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 102;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 92: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 103;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 93: {
                        switch (zzInput) {
                            case 43: {
                                this.zzState = 104;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 94: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 105;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 95: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 106;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 96: {
                        switch (zzInput) {
                            case 20: {
                                this.zzState = 107;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 97: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 108;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 98: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                this.zzState = 109;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 99: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 98;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 100: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 110;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 101: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 102: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 111;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 103: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 112;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 104: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 113;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 105: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 114;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 106: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 115;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 107: {
                        switch (zzInput) {
                            case 21: {
                                this.zzState = 116;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 108: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 117;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 109: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 110: {
                        switch (zzInput) {
                            case 37: {
                                this.zzState = 118;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 111: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 119;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 112: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 120;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 113: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 121;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 114: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 122;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 115: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 123;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 116: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 124;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 117: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 125;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 118: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 126;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 119: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 127;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 120: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 121: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 128;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 122: {
                        switch (zzInput) {
                            case 20: {
                                this.zzState = 129;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 123: {
                        switch (zzInput) {
                            case 16: {
                                this.zzState = 130;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 124: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 23: {
                                this.zzState = 131;
                                break block4;
                            }
                            case 34: {
                                this.zzState = 132;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 125: {
                        switch (zzInput) {
                            case 30: {
                                this.zzState = 133;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 126: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 134;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 127: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 128: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 129: {
                        switch (zzInput) {
                            case 21: {
                                this.zzState = 135;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 130: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 136;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 131: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 137;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 132: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 138;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 133: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                this.zzState = 139;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 134: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 140;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 135: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 141;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 136: {
                        switch (zzInput) {
                            case 29: {
                                this.zzState = 142;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 137: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 143;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 138: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 144;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 139: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 31: 
                            case 32: {
                                this.zzState = 145;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 140: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 146;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 141: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 147;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 142: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 148;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 143: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 149;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 144: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 21: {
                                this.zzState = 150;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 145: {
                        switch (zzInput) {
                            case 23: {
                                this.zzState = 151;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 146: {
                        switch (zzInput) {
                            case 45: {
                                this.zzState = 152;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 147: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 148: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 153;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 149: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                break block4;
                            }
                            case 21: {
                                this.zzState = 154;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 150: {
                        switch (zzInput) {
                            case 24: {
                                this.zzState = 155;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 151: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 156;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 152: {
                        switch (zzInput) {
                            case 22: {
                                this.zzState = 157;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 153: {
                        switch (zzInput) {
                            case 6: 
                            case 8: 
                            case 9: 
                            case 28: {
                                zzIsFinal = true;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 154: {
                        switch (zzInput) {
                            case 24: {
                                this.zzState = 158;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 155: {
                        switch (zzInput) {
                            case 25: {
                                this.zzState = 159;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 156: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 160;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 157: {
                        switch (zzInput) {
                            case 35: {
                                this.zzState = 161;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 158: {
                        switch (zzInput) {
                            case 25: {
                                this.zzState = 162;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 159: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 163;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 160: {
                        switch (zzInput) {
                            case 21: {
                                this.zzState = 164;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 161: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 76;
                                break block4;
                            }
                            case 21: {
                                this.zzState = 77;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 162: {
                        switch (zzInput) {
                            case 14: {
                                this.zzState = 165;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 163: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 166;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 164: {
                        switch (zzInput) {
                            case 33: {
                                this.zzState = 167;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 165: {
                        switch (zzInput) {
                            case 26: {
                                this.zzState = 168;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 166: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 169;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 167: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 170;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 168: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 171;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 169: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                        }
                        break;
                    }
                    case 170: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 173;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 171: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                        }
                        break;
                    }
                    case 172: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 175;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 173: {
                        switch (zzInput) {
                            case 34: {
                                this.zzState = 176;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 174: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 177;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 175: {
                        switch (zzInput) {
                            case 27: {
                                break;
                            }
                            case 16: {
                                this.zzState = 178;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 176: {
                        switch (zzInput) {
                            case 34: {
                                this.zzState = 179;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 177: {
                        switch (zzInput) {
                            case 27: {
                                break;
                            }
                            case 16: {
                                this.zzState = 180;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 178: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 19: {
                                this.zzState = 181;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 179: {
                        switch (zzInput) {
                            case 34: {
                                this.zzState = 182;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 180: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 19: {
                                this.zzState = 183;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 181: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 16: {
                                this.zzState = 184;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 182: {
                        switch (zzInput) {
                            case 35: {
                                this.zzState = 185;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 183: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 16: {
                                this.zzState = 186;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 184: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 28: {
                                this.zzState = 187;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 185: {
                        switch (zzInput) {
                            case 34: {
                                this.zzState = 188;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 186: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 28: {
                                this.zzState = 189;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 187: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 34: {
                                this.zzState = 190;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 188: {
                        switch (zzInput) {
                            case 36: {
                                this.zzState = 191;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 189: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 12: {
                                this.zzState = 192;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 190: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 13: {
                                this.zzState = 193;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 191: {
                        switch (zzInput) {
                            case 35: {
                                this.zzState = 194;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 192: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 23: {
                                this.zzState = 195;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 193: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 14: {
                                zzIsFinal = true;
                                this.zzState = 196;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 194: {
                        switch (zzInput) {
                            case 17: {
                                this.zzState = 197;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 195: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 19: {
                                this.zzState = 198;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 196: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 172;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 169;
                                break;
                            }
                        }
                        break;
                    }
                    case 197: {
                        switch (zzInput) {
                            case 37: {
                                this.zzState = 199;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 198: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 13: {
                                this.zzState = 200;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 199: {
                        switch (zzInput) {
                            case 38: {
                                this.zzState = 201;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 200: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 14: {
                                zzIsFinal = true;
                                this.zzState = 202;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 201: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 203;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 202: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 174;
                                break;
                            }
                            case 9: {
                                break block936;
                            }
                            default: {
                                this.zzState = 171;
                                break;
                            }
                        }
                        break;
                    }
                    case 203: {
                        switch (zzInput) {
                            case 39: {
                                this.zzState = 204;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 204: {
                        switch (zzInput) {
                            case 40: {
                                this.zzState = 205;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 205: {
                        switch (zzInput) {
                            case 40: {
                                this.zzState = 206;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 206: {
                        switch (zzInput) {
                            case 40: {
                                this.zzState = 207;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 207: {
                        switch (zzInput) {
                            case 27: {
                                this.zzState = 208;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 208: {
                        switch (zzInput) {
                            case 12: {
                                this.zzState = 209;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 209: {
                        switch (zzInput) {
                            case 23: {
                                this.zzState = 210;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 210: {
                        switch (zzInput) {
                            case 19: {
                                this.zzState = 211;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 211: {
                        switch (zzInput) {
                            case 13: {
                                this.zzState = 212;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    case 212: {
                        switch (zzInput) {
                            case 14: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 213;
                                break block4;
                            }
                        }
                        break block936;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!zzIsFinal) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if (zzNoLookAhead) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 10: {
                    if (this.yychar != 0) continue block935;
                    this.hasMore = false;
                    return "UTF16BE";
                }
                case 27: {
                    continue block935;
                }
                case 17: {
                    if (this.yychar != 0) continue block935;
                    this.hasMore = false;
                    return "UTF83ByteBOM";
                }
                case 28: {
                    continue block935;
                }
                case 4: {
                    this.yybegin(10);
                    this.string.setLength(0);
                }
                case 29: {
                    continue block935;
                }
                case 5: {
                    this.string.append(this.yytext());
                }
                case 30: {
                    continue block935;
                }
                case 22: {
                    this.pushCurrentState();
                    this.yybegin(6);
                    return "PageLanguage";
                }
                case 31: {
                    continue block935;
                }
                case 26: {
                    this.isXHTML = true;
                }
                case 32: {
                    continue block935;
                }
                case 24: {
                    this.pushCurrentState();
                    this.yybegin(6);
                    return "PageEncoding";
                }
                case 33: {
                    continue block935;
                }
                case 1: {
                    if (this.yychar <= 8000) continue block935;
                    this.hasMore = false;
                    return "MAX_CHARS_REACHED";
                }
                case 34: {
                    continue block935;
                }
                case 11: {
                    if (this.yychar != 0) continue block935;
                    this.hasMore = false;
                    return "UTF16LE";
                }
                case 35: {
                    continue block935;
                }
                case 6: {
                    this.yypushback(1);
                    this.popState();
                    this.valueText = this.string.toString();
                    return "InvalidTerminatedStringValue";
                }
                case 36: {
                    continue block935;
                }
                case 8: {
                    this.yypushback(1);
                    this.popState();
                    this.valueText = this.string.toString();
                    return "UnDelimitedStringValue";
                }
                case 37: {
                    continue block935;
                }
                case 9: {
                    this.yypushback(1);
                    this.popState();
                    this.valueText = this.string.toString();
                    return "InvalidTermintatedUnDelimitedStringValue";
                }
                case 38: {
                    continue block935;
                }
                case 7: {
                    this.popState();
                    this.valueText = this.string.toString();
                    return "strval";
                }
                case 39: {
                    continue block935;
                }
                case 14: {
                    this.yybegin(0);
                    return "PageDirectiveEnd";
                }
                case 40: {
                    continue block935;
                }
                case 23: {
                    this.pushCurrentState();
                    this.yybegin(6);
                    return "PageContentType";
                }
                case 41: {
                    continue block935;
                }
                case 18: {
                    if (this.yychar != 0) continue block935;
                    this.yybegin(2);
                    return "XMLDeclStart";
                }
                case 42: {
                    continue block935;
                }
                case 15: {
                    this.yypushback(2);
                    this.popState();
                    this.valueText = this.string.toString();
                    return "InvalidTerminatedStringValue";
                }
                case 43: {
                    continue block935;
                }
                case 2: {
                    this.yypushback(1);
                    this.yybegin(12);
                    this.string.setLength(0);
                }
                case 44: {
                    continue block935;
                }
                case 12: {
                    this.yybegin(0);
                    return "XMLDeclEnd";
                }
                case 45: {
                    continue block935;
                }
                case 13: {
                    this.yybegin(0);
                    return "PageDirectiveEnd";
                }
                case 46: {
                    continue block935;
                }
                case 25: {
                    this.isWML = true;
                }
                case 47: {
                    continue block935;
                }
                case 19: {
                    this.yybegin(4);
                    return "PageDirectiveStart";
                }
                case 48: {
                    continue block935;
                }
                case 21: {
                    this.pushCurrentState();
                    this.yybegin(6);
                    return "XMLDelEncoding";
                }
                case 49: {
                    continue block935;
                }
                case 20: {
                    this.pushCurrentState();
                    this.yybegin(6);
                    return "XMLDeclVersion";
                }
                case 50: {
                    continue block935;
                }
                case 16: {
                    this.yypushback(2);
                    this.popState();
                    this.valueText = this.string.toString();
                    return "InvalidTerminatedStringValue";
                }
                case 51: {
                    continue block935;
                }
                case 3: {
                    this.yybegin(8);
                    this.string.setLength(0);
                }
                case 52: {
                    continue block935;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                this.hasMore = false;
                return "EOF";
            }
            this.zzScanError(1);
        }
    }
}

