/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class VThreadManager {
    private static VThreadManager _manager = null;
    private static final int MAX_NUM_OF_RESTART = 5;
    private Thread _validationThread = null;
    volatile int restart = 0;
    volatile Jobs _jobs = new Jobs();

    private VThreadManager() {
        Runnable validationRunnable = new Runnable(){

            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            if (VThreadManager.this.restart > 5) {
                                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("VThreadManager::validationRunnable");
                                entry.setText("restart = " + VThreadManager.this.restart);
                                logger.write(Level.SEVERE, (Object)entry);
                                break block2;
                            }
                            Runnable job = VThreadManager.this.getJobs().dequeue();
                            if (job == null) continue;
                            VThreadManager.this.getJobs().setActive(true);
                            job.run();
                            VThreadManager.this.getJobs().setActive(false);
                        }
                    }
                    catch (Throwable exc) {
                        ++VThreadManager.this.restart;
                        VThreadManager.this.getJobs().setActive(false);
                        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                        if (!logger.isLoggingLevel(Level.FINE)) continue;
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("VThreadManager::validationRunnable");
                        entry.setTargetException(exc);
                        logger.write(Level.FINE, (Object)entry);
                        continue;
                    }
                    break;
                }
            }
        };
        this._validationThread = new Thread(validationRunnable, "ValidationThread");
        this._validationThread.start();
    }

    public static VThreadManager getManager() {
        if (_manager == null) {
            _manager = new VThreadManager();
        }
        return _manager;
    }

    Jobs getJobs() {
        return this._jobs;
    }

    public void queue(Runnable runnable) {
        this.getJobs().queue(runnable);
    }

    public boolean isDone() {
        return this.getJobs().isDone();
    }

    private class Jobs {
        private Vector __jobs = new Vector();
        private boolean _isActive = false;

        public synchronized void queue(Runnable runnable) {
            this.__jobs.add(runnable);
            this.notifyAll();
        }

        synchronized Runnable dequeue() {
            while (this.__jobs.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Runnable job = null;
            if (this.__jobs.size() > 0 && (job = (Runnable)this.__jobs.get(0)) != null) {
                this.__jobs.remove(0);
            }
            return job;
        }

        public synchronized boolean isActive() {
            return this._isActive;
        }

        public synchronized void setActive(boolean active) {
            this._isActive = active;
        }

        public synchronized boolean isDone() {
            return this.__jobs.size() == 0 && !this.isActive();
        }
    }
}

