/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputUtil;
import org.eclipse.wst.rdb.internal.outputview.OutputView;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.ProcedureCallCache;

public class OutputViewAPI {
    public static final int MESSAGE_PAGE = 30;
    public static final int PARAMATERS_PAGE = 31;
    public static final int RESULTS_PAGE = 32;
    protected static OutputView outputView;
    protected static OutputViewAPI myself;

    protected OutputViewAPI() {
        outputView = null;
    }

    public static synchronized OutputViewAPI getInstance() {
        if (myself == null) {
            myself = new OutputViewAPI();
        }
        return myself;
    }

    public void showMessage(OutputItem outputItem, String msg, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.showMessage(outputItem, msg, async);
        }
    }

    public void replaceMessage(OutputItem outputItem, String msg) {
        this.replaceMessage(outputItem, msg, false);
    }

    public void replaceMessage(OutputItem outputItem, String msg, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.replaceMessage(outputItem, msg, async);
        }
    }

    public void deleteOutputItem(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().removeOutputItem(outputItem);
            outputView.refreshWithDefault();
        }
    }

    public void deleteOutputItem(OutputItem outputItem) {
        this.deleteOutputItem(outputItem, false);
    }

    public void showParameters(OutputItem outputItem, Vector parms) {
        this.showParameters(outputItem, parms, false);
    }

    public void showParameters(OutputItem outputItem, Vector parms, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.showParameters(outputItem, parms);
        }
    }

    public void showOutputContent(OutputItem outputItem, ResultSet rs, Vector parameters, int showWhichTab, boolean async) throws SQLException {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().addResultAndParameters(outputItem, rs, parameters);
            switch (showWhichTab) {
                case 30: {
                    outputView.showMessage(outputItem, async);
                }
                case 31: {
                    outputView.showParameters(outputItem, async);
                }
                case 32: {
                    outputView.showResult(outputItem, async);
                }
            }
            outputView.showMessage(outputItem, async);
        }
    }

    public void showOutputContent(OutputItem outputItem, ProcedureCallCache proc) {
        this.showOutputContent(outputItem, proc, false);
    }

    public void showOutputContent(OutputItem outputItem, ProcedureCallCache proc, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            try {
                outputView.getModel().addProcedureCall(outputItem, proc);
                outputView.showResult(outputItem);
            }
            catch (SQLException ex) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputViewAPI:showOutputContent(OutputItem, ProcedureCallCache, boolean)", ex);
            }
        }
    }

    public void showOutputContent(OutputItem outputItem, ProcedureCallCache proc, Vector parameters) {
        this.showOutputContent(outputItem, proc, parameters, false);
    }

    public void showOutputContent(OutputItem outputItem, ProcedureCallCache proc, Vector parameters, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            try {
                outputView.getModel().addProcedureCallAndParameters(outputItem, proc, parameters);
                outputView.showResult(outputItem);
            }
            catch (SQLException ex) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputViewAPI:showOutputContent(OutputItem, ProcedureCallCache, Vector, boolean)", ex);
            }
        }
    }

    public void showOutputContent(OutputItem outputItem, ResultSet rs) throws SQLException {
        this.showOutputContent(outputItem, rs, false);
    }

    public void showOutputContent(OutputItem outputItem, ResultSet rs, boolean async) throws SQLException {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().addResult(outputItem, rs);
            outputView.showResult(outputItem);
        }
    }

    public void showOutputContent(OutputItem outputItem, ResultSet rs, Vector parameters) throws SQLException {
        this.showOutputContent(outputItem, rs, parameters, false);
    }

    public void showOutputContent(OutputItem outputItem, ResultSet rs, Vector parameters, boolean async) throws SQLException {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().addResultAndParameters(outputItem, rs, parameters);
            outputView.showResult(outputItem);
        }
    }

    public void showOutputContent(OutputItem outputItem, String id, Object contents, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().addContents(outputItem, id, contents);
            outputView.showContents(outputItem, id, async);
        }
    }

    public void updateStatus(OutputItem outputItem, int statusCode, boolean async) {
        outputItem.setStatus(statusCode);
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.refreshActionTable(outputItem, async);
        }
    }

    public void updateStatus(OutputItem outputItem, int statusCode) {
        this.updateStatus(outputItem, statusCode, false);
    }

    public OutputItem findOutputItem(String uniqueName, int action, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            return outputView.getModel().findOutputItem(uniqueName, action);
        }
        return null;
    }

    public OutputItem findOutputItem(String uniqueName, int action) {
        return this.findOutputItem(uniqueName, action, false);
    }

    public OutputItem findOutputItem(String uniqueName, String action, boolean async) {
        int actionCode = OutputItem.getActionCode(action);
        if (actionCode < 0) {
            return null;
        }
        return this.findOutputItem(uniqueName, actionCode, async);
    }

    public OutputItem findOutputItem(String uniqueName, String action) {
        return this.findOutputItem(uniqueName, action, false);
    }

    public int getRowCount(OutputItem item, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            return outputView.getModel().getResultSetRowCount(item);
        }
        return -1;
    }

    public int getRowCount(OutputItem item) {
        return this.getRowCount(item, false);
    }

    public OutputItem resetOutputItem(OutputItem item, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            return outputView.getModel().resetItem(item);
        }
        return null;
    }

    public OutputItem resetOutputItem(OutputItem item) {
        return this.resetOutputItem(item, false);
    }

    public void clearOutput(OutputItem outputItem, boolean async) {
        this.clearMessages(outputItem, async);
        this.clearResults(outputItem, async);
        this.clearParameters(outputItem, async);
        this.clearAdditionalTabs(outputItem, async);
    }

    public void clearOutput(OutputItem outputItem) {
        this.clearOutput(outputItem, false);
    }

    public void clearResults(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.clearResults();
        }
    }

    public void clearResults(OutputItem outputItem) {
        this.clearResults(outputItem, false);
    }

    public void clearParameters(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.clearParameters();
        }
    }

    public void clearParameters(OutputItem outputItem) {
        this.clearParameters(outputItem, false);
    }

    public void clearAdditionalTabs(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.clearAllAdditionalTabs(outputItem);
        }
    }

    public void clearMessages(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.clearMessages(outputItem);
        }
    }

    public void clearMessages(OutputItem outputItem) {
        this.clearMessages(outputItem, false);
    }

    public void addOutputItem(OutputItem outputItem, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.addOutputItem(outputItem, async, false);
        }
    }

    public void showResultsPage() {
        this.showResultsPage(false);
    }

    public void showResultsPage(boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.showResultsPage(async);
        }
    }

    public void showMessagePage() {
        this.showMessagePage(false);
    }

    public void showMessagePage(boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.showMessagePage(async);
        }
    }

    public void showParametersPage() {
        this.showParametersPage(false);
    }

    public void showParametersPage(boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.showParametersPage(async);
        }
    }

    public void removeOutputItem(OutputItem item, boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().removeOutputItem(item);
        }
    }

    public void removeOutputItem(OutputItem item) {
        this.removeOutputItem(item, false);
    }

    public void removeAllFromOutput(boolean async) {
        outputView = this.getOutputView(async);
        if (outputView != null) {
            outputView.getModel().removeAll();
        }
    }

    public void removeAllFromOutput() {
        this.removeAllFromOutput(false);
    }

    protected OutputView getOutputView() {
        return this.getOutputView(false);
    }

    protected OutputView getOutputView(boolean async) {
        if (outputView == null) {
            outputView = OutputUtil.getOutputView(async);
        }
        OutputUtil.showOutputView();
        return outputView;
    }
}

