/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class JSFAppConfigUtils {
    public static final String CONFIG_FILES_CONTEXT_PARAM_NAME = "javax.faces.CONFIG_FILES";
    public static final String FACES_CONFIG_IN_JAR_PATH = "META-INF/faces-config.xml";

    public static IVirtualFolder getWebContentFolder(IProject project) {
        IVirtualFolder folder = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            folder = component.getRootFolder();
        }
        return folder;
    }

    public static IPath getWebContentFolderRelativePath(IFile file) {
        IPath path = null;
        IVirtualFolder webContentFolder = JSFAppConfigUtils.getWebContentFolder(file.getProject());
        if (webContentFolder != null) {
            IPath webContentPath = webContentFolder.getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            int matchingFirstSegments = webContentPath.matchingFirstSegments(filePath);
            path = filePath.removeFirstSegments(matchingFirstSegments);
        }
        return path;
    }

    public static String[] getConfigFilesFromContextParam(IProject project) {
        String[] files = null;
        ArrayList<String> filesList = new ArrayList<String>();
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        if (webArtifactEdit != null) {
            WebApp webApp = webArtifactEdit.getWebApp();
            if (webApp != null) {
                String filesString = null;
                if (webApp.getVersionID() == 23) {
                    EList contexts = webApp.getContexts();
                    Iterator itContexts = contexts.iterator();
                    while (itContexts.hasNext()) {
                        ContextParam contextParam = (ContextParam)itContexts.next();
                        if (!contextParam.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                        filesString = contextParam.getParamValue();
                        break;
                    }
                } else {
                    EList contextParams = webApp.getContextParams();
                    Iterator itContextParams = contextParams.iterator();
                    while (itContextParams.hasNext()) {
                        ParamValue paramValue = (ParamValue)itContextParams.next();
                        if (!paramValue.getName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                        filesString = paramValue.getValue();
                        break;
                    }
                }
                if (filesString != null && filesString.trim().length() > 0) {
                    StringTokenizer stFilesString = new StringTokenizer(filesString, ",");
                    while (stFilesString.hasMoreTokens()) {
                        String configFile = stFilesString.nextToken().trim();
                        filesList.add(configFile);
                    }
                }
            }
            webArtifactEdit.dispose();
        }
        files = new String[filesList.size()];
        files = filesList.toArray(files);
        return files;
    }

    public static String[] getConfigFileJARsFromClasspath(IProject project) throws CoreException, IOException {
        IClasspathEntry[] classpathEntries;
        IJavaProject javaProject;
        String[] JARs = null;
        ArrayList<String> JARsList = new ArrayList<String>();
        if (project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null && (classpathEntries = javaProject.getResolvedClasspath(true)) != null && classpathEntries.length > 0) {
            int i = 0;
            while (i < classpathEntries.length) {
                IPath libraryPath;
                IClasspathEntry classpathEntry = classpathEntries[i];
                if (classpathEntry.getEntryKind() == 1 && (libraryPath = classpathEntry.getPath()).getFileExtension() != null && libraryPath.getFileExtension().length() > 0) {
                    JarEntry jarEntry;
                    String libraryPathString;
                    JarFile jarFile;
                    if (libraryPath.getDevice() == null) {
                        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                        IPath workspaceRootPath = workspaceRoot.getLocation();
                        libraryPath = workspaceRootPath.append(libraryPath);
                    }
                    if ((jarFile = new JarFile(libraryPathString = libraryPath.toString())) != null && (jarEntry = jarFile.getJarEntry(FACES_CONFIG_IN_JAR_PATH)) != null) {
                        JARsList.add(libraryPathString);
                    }
                }
                ++i;
            }
        }
        JARs = new String[JARsList.size()];
        JARs = JARsList.toArray(JARs);
        return JARs;
    }
}

