/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.DirectedGraph;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.Edge;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.EdgeList;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.Node;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.NodeList;

public class UnconnectedDirectedGraph
extends DirectedGraph {
    private EdgeList candidateEdges = null;
    private NodeList subNodes = null;
    private EdgeList subEdges = null;

    public List getConnectedSubGraphs() {
        ArrayList<DirectedGraph> lstGraph = new ArrayList<DirectedGraph>();
        UnconnectedDirectedGraph graph = new UnconnectedDirectedGraph();
        graph.nodes = this.nodes;
        graph.edges = this.edges;
        graph.nodes.resetFlags();
        graph.edges.resetFlags(false);
        while (graph.nodes.size() > 0) {
            DirectedGraph subGraph = this.getConnectedSubGraph(graph);
            lstGraph.add(subGraph);
            graph.nodes.removeAll(subGraph.nodes);
            graph.edges.removeAll(subGraph.edges);
        }
        return lstGraph;
    }

    private DirectedGraph getConnectedSubGraph(UnconnectedDirectedGraph graph) {
        DirectedGraph subGraph = new DirectedGraph();
        Node root = graph.nodes.getNode(0);
        this.subNodes = new NodeList();
        this.subEdges = new EdgeList();
        this.candidateEdges = new EdgeList();
        this.addNode(root);
        while (this.subNodes.size() < graph.nodes.size()) {
            if (this.candidateEdges.size() == 0) break;
            Edge edge = this.candidateEdges.getEdge(0);
            Node node = null;
            if (!edge.target.flag) {
                node = edge.target;
            }
            if (!edge.source.flag) {
                node = edge.source;
            }
            if (node == null) continue;
            this.addNode(node);
        }
        this.subNodes.resetFlags();
        this.subEdges.resetFlags(false);
        subGraph.nodes = this.subNodes;
        subGraph.edges = this.subEdges;
        return subGraph;
    }

    private void addNode(Node node) {
        Edge e;
        if (node == null) {
            return;
        }
        EdgeList list = node.incoming;
        int i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!e.source.flag) {
                if (!this.candidateEdges.contains(e)) {
                    this.candidateEdges.add(e);
                    if (!this.subEdges.contains(e)) {
                        this.subEdges.add(e);
                    }
                }
            } else {
                this.candidateEdges.remove(e);
            }
            ++i;
        }
        list = node.outgoing;
        i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!e.target.flag) {
                if (!this.candidateEdges.contains(e)) {
                    this.candidateEdges.add(e);
                    if (!this.subEdges.contains(e)) {
                        this.subEdges.add(e);
                    }
                }
            } else {
                this.candidateEdges.remove(e);
            }
            ++i;
        }
        if (!node.flag) {
            node.flag = true;
            this.subNodes.add(node);
        }
    }
}

