/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.action;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jst.jsf.facesconfig.ui.EditorResources;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenEditorAction
extends SelectionAction {
    public static final String OPEN_EDITOR_REQUEST = EditorResources.getInstance().getString("Pageflow.Commands.OpenEditorCommand.Label");
    Request request = new Request((Object)OPEN_EDITOR_REQUEST);

    public OpenEditorAction(IWorkbenchPart part) {
        super(part);
        this.setText(EditorResources.getInstance().getString("Pageflow.Action.OpenEditor.Label"));
        this.setId("org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor");
        this.setToolTipText(EditorResources.getInstance().getString("Pageflow.Action.OpenEditor.ToolTip"));
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        List parts = this.getSelectedObjects();
        int i = 0;
        while (i < parts.size()) {
            Object o = parts.get(i);
            if (!(o instanceof EditPart)) {
                return false;
            }
            EditPart part = (EditPart)o;
            if (!(part.getModel() instanceof PageflowPage)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Command getCommand() {
        List editparts = this.getSelectedObjects();
        CompoundCommand cc = new CompoundCommand();
        cc.setDebugLabel(OPEN_EDITOR_REQUEST);
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            cc.add(part.getCommand(this.request));
            ++i;
        }
        return cc;
    }

    public void run() {
        this.execute(this.getCommand());
    }

    protected void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        command.execute();
    }
}

