/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.guiutils;

import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jst.jsf.facesconfig.common.CommonPlugin;
import org.eclipse.jst.jsf.facesconfig.common.guiutils.SWTUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserWindow
extends ApplicationWindow {
    public static final int BROWSER_CMD_BACK = 1;
    public static final int BROWSER_CMD_FORWARD = 2;
    public static final int BROWSER_CMD_STOP = 3;
    public static final int BROWSER_CMD_REFRESH = 4;
    public static final int BROWSER_CMD_RELOAD = 5;
    protected boolean bIncludeToolbar;
    protected boolean bPopups;
    protected String title;
    protected ScrolledComposite scomp;
    protected Composite browserComposite;
    protected Browser browser;
    protected String startLocation;
    protected String startContent;
    protected Point size = new Point(600, 600);
    protected ToolItem backItem;
    protected ToolItem forwardItem;

    public BrowserWindow(Shell parentShell) {
        this(parentShell, false, null, false);
    }

    public BrowserWindow(Shell parentShell, boolean bPopups, String title) {
        this(parentShell, bPopups, title, false);
    }

    public BrowserWindow(Shell parentShell, boolean bPopups, String title, boolean bModal) {
        super(parentShell);
        this.addStatusLine();
        this.bPopups = bPopups;
        this.title = title;
        this.includeToolbar(true);
        if (bModal && parentShell != null) {
            this.setShellStyle(this.getShellStyle() | 0x10000);
            this.setBlockOnOpen(true);
        }
    }

    public void includeToolbar(boolean bIncludeToolbar) {
        this.bIncludeToolbar = bIncludeToolbar;
    }

    public void setTitle(String title) {
        if (title != null && super.getShell() != null) {
            super.getShell().setText(title);
        }
    }

    public void setStartLocation(String startLocation) {
        this.startLocation = startLocation;
    }

    public void setStartContent(String startContent) {
        this.startContent = startContent;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected Control createContents(Composite parent) {
        this.scomp = new ScrolledComposite(parent, 768);
        Composite innerComposite = SWTUtils.createComposite((Composite)this.scomp, 1, 10, -1);
        this.scomp.setContent((Control)innerComposite);
        ControlListener listener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Point pt = BrowserWindow.this.scomp.getParent().getSize();
                Rectangle rect = BrowserWindow.this.browserComposite.getBounds();
                pt.x -= rect.x;
                pt.y -= rect.y;
                pt.x -= 10;
                pt.y -= 60;
                if (pt.x <= 0 || pt.y <= 0) {
                    return;
                }
                Rectangle innerRect = BrowserWindow.this.scomp.getContent().getBounds();
                Rectangle outerRect = BrowserWindow.this.scomp.getBounds();
                if (innerRect.width > outerRect.width) {
                    pt.y -= BrowserWindow.this.scomp.getHorizontalBar().getSize().y;
                }
                if (innerRect.height > outerRect.height) {
                    pt.x -= BrowserWindow.this.scomp.getVerticalBar().getSize().x;
                }
                BrowserWindow.this.browserComposite.setSize(pt);
                BrowserWindow.this.browserComposite.getParent().layout(true);
            }
        };
        this.scomp.addControlListener(listener);
        if (this.bIncludeToolbar) {
            ToolBar tb = new ToolBar(innerComposite, 0x800100);
            this.fillToolbar(tb);
        }
        this.browserComposite = new Composite(innerComposite, 0);
        this.browserComposite.setLayout((Layout)new FillLayout());
        this.browser = new Browser(this.browserComposite, 0);
        if (this.startLocation != null) {
            this.browser.setUrl(this.startLocation);
        } else if (this.startContent != null) {
            this.browser.setText(this.startContent);
        } else {
            this.browser.setText("<b>Loading...</b>");
        }
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                BrowserWindow.this.setStatus(event.text);
            }
        });
        if (this.bIncludeToolbar) {
            this.browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                }

                public void changed(LocationEvent event) {
                    BrowserWindow.this.backItem.setEnabled(BrowserWindow.this.browser.isBackEnabled());
                    BrowserWindow.this.forwardItem.setEnabled(BrowserWindow.this.browser.isForwardEnabled());
                }
            });
        }
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (BrowserWindow.this.bPopups) {
                    BrowserWindow window = new BrowserWindow(BrowserWindow.this.getShell());
                    window.open();
                    event.browser = window.getBrowser();
                } else {
                    event.browser = BrowserWindow.this.getBrowser();
                }
            }
        });
        this.setTitle(this.title);
        SWTUtils.computeScrollArea(this.scomp, innerComposite);
        return this.scomp;
    }

    protected void fillToolbar(ToolBar tb) {
        this.backItem = new ToolItem(tb, 8);
        this.backItem.setImage(CommonPlugin.getDefault().getImage("back_nav_16.gif"));
        this.backItem.setToolTipText(CommonPlugin.getResourceString("BrowserWindow.back.tooltip"));
        SelectionAdapter backSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(1);
            }
        };
        this.backItem.addSelectionListener((SelectionListener)backSelectionListener);
        this.forwardItem = new ToolItem(tb, 8);
        this.forwardItem.setImage(CommonPlugin.getDefault().getImage("forward_nav_16.gif"));
        this.forwardItem.setToolTipText(CommonPlugin.getResourceString("BrowserWindow.forward.tooltip"));
        SelectionAdapter forwardSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(2);
            }
        };
        this.forwardItem.addSelectionListener((SelectionListener)forwardSelectionListener);
        ToolItem stopItem = new ToolItem(tb, 8);
        stopItem.setImage(CommonPlugin.getDefault().getImage("stop_nav_16.gif"));
        stopItem.setToolTipText(CommonPlugin.getResourceString("BrowserWindow.stop.tooltip"));
        SelectionAdapter stopSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(3);
            }
        };
        stopItem.addSelectionListener((SelectionListener)stopSelectionListener);
        ToolItem refreshItem = new ToolItem(tb, 8);
        refreshItem.setImage(CommonPlugin.getDefault().getImage("refresh_nav_16.gif"));
        refreshItem.setToolTipText(CommonPlugin.getResourceString("BrowserWindow.refresh.tooltip"));
        SelectionAdapter refreshServiceSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(4);
            }
        };
        refreshItem.addSelectionListener((SelectionListener)refreshServiceSelectionListener);
        if (this.startLocation != null || this.startContent != null) {
            ToolItem reloadItem = new ToolItem(tb, 8);
            reloadItem.setImage(CommonPlugin.getDefault().getImage("reload_nav_16.gif"));
            reloadItem.setToolTipText(CommonPlugin.getResourceString("BrowserWindow.reload.tooltip"));
            SelectionAdapter reloadSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowserWindow.this.browserCmd(5);
                }
            };
            reloadItem.addSelectionListener((SelectionListener)reloadSelectionListener);
        }
    }

    public boolean browserCmd(int cmd) {
        switch (cmd) {
            case 1: {
                return this.browser.back();
            }
            case 2: {
                return this.browser.forward();
            }
            case 3: {
                this.browser.stop();
                return true;
            }
            case 4: {
                this.browser.refresh();
                return true;
            }
            case 5: {
                if (this.startLocation != null) {
                    this.browser.setUrl(this.startLocation);
                } else if (this.startContent != null) {
                    this.browser.setText(this.startContent);
                }
                return true;
            }
        }
        return false;
    }

    public void setStartSize(Point pp) {
        this.size = pp;
    }

    public void setStartSize(int x, int y) {
        this.size = new Point(x, y);
    }

    protected Point getInitialSize() {
        return this.size;
    }
}

