/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.context.symbol.plugin.SymbolsPlugin;

final class TypeUtil {
    TypeUtil() {
    }

    static IType resolveType(IType owningType, String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        String fullName = "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType;
    }

    private static String resolveSignatureRelative(IType owningType, String typeSignature) {
        String adjustedTypeSignature = typeSignature;
        int arrayDepth = 0;
        if (Signature.getTypeSignatureKind((String)adjustedTypeSignature) == 4) {
            arrayDepth = Signature.getArrayCount((String)adjustedTypeSignature);
            adjustedTypeSignature = Signature.getElementType((String)adjustedTypeSignature);
        }
        String packageName = Signature.getSignatureQualifier((String)adjustedTypeSignature);
        String typeName = Signature.getSignatureSimpleName((String)adjustedTypeSignature);
        String fullName = "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
        }
        catch (JavaModelException javaModelException) {}
        if (resolvedType != null) {
            String resolvedTypeSignature = Signature.createTypeSignature((String)resolvedType.getFullyQualifiedName(), (boolean)true);
            int i = 0;
            while (i < arrayDepth) {
                resolvedTypeSignature = "[" + resolvedTypeSignature;
                ++i;
            }
            return resolvedTypeSignature;
        }
        if (Signature.getTypeSignatureKind((String)typeSignature) == 1) {
            SymbolsPlugin.getPlugin().log(new Status(2, SymbolsPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Failed to resolve type: " + typeSignature, null));
        }
        return typeSignature;
    }

    static String resolveTypeSignature(IType owningType, String typeSignature) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSignature);
        switch (sigKind) {
            case 2: {
                return typeSignature;
            }
            case 4: {
                String elementType = Signature.getElementType((String)typeSignature);
                if (Signature.getTypeSignatureKind((String)elementType) == 2) {
                    return typeSignature;
                }
                String resolvedElementType = TypeUtil.resolveSignatureRelative(owningType, elementType);
                String resultType = "";
                int i = 0;
                while (i < Signature.getArrayCount((String)typeSignature)) {
                    resultType = String.valueOf(resultType) + '[';
                    ++i;
                }
                return String.valueOf(resultType) + resolvedElementType;
            }
            case 1: {
                return TypeUtil.resolveSignatureRelative(owningType, typeSignature);
            }
        }
        return typeSignature;
    }

    static String getSignature(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true);
    }

    static IMethod[] getAllMethods(ITypeHierarchy typeHierarchy, IType type) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IType[] superTypes = typeHierarchy.getAllSuperclasses(type);
        IType[] closure = new IType[superTypes.length + 1];
        closure[0] = type;
        System.arraycopy(superTypes, 0, closure, 1, superTypes.length);
        int i = 0;
        while (i < superTypes.length) {
            try {
                IType superType = closure[i];
                methods.addAll(Arrays.asList(superType.getMethods()));
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return methods.toArray(new IMethod[0]);
    }

    static String resolveMethodSignature(IType owner, String unresolvedSignature) {
        String[] parameters = Signature.getParameterTypes((String)unresolvedSignature);
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = TypeUtil.resolveSignatureRelative(owner, parameters[i]);
            ++i;
        }
        String resolvedReturn = TypeUtil.resolveSignatureRelative(owner, Signature.getReturnType((String)unresolvedSignature));
        return Signature.createMethodSignature((String[])parameters, (String)resolvedReturn);
    }
}

