/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;

final class DiagnosticFactory {
    private static final int BINARY_OP_BOTH_OPERANDS_NULL_ID = 0;
    private static final int BINARY_OP_POSSIBLE_DIVISION_BY_ZERO_ID = 1;
    private static final int BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION_ID = 2;
    private static final int BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME_ID = 3;
    private static final int BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME_ID = 4;
    private static final int BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN_ID = 5;
    private static final int BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS_ID = 6;
    private static final int BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME_ID = 7;
    private static final int BINARY_OP_NO_AVAILABLE_TYPE_COERCION_ID = 8;
    private static final int BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS_ID = 9;
    private static final int UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID = 10;
    private static final int UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE_ID = 11;
    private static final int UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO_ID = 12;
    private static final int UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION_ID = 13;
    private static final int UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN_ID = 14;
    private static final int TERNARY_OP_CHOICE_IS_ALWAYS_SAME_ID = 15;
    private static final int TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN_ID = 16;
    private static Diagnostic DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO;
    private static Diagnostic DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION;
    private static Diagnostic DIAGNOSTIC_COULD_NOT_COERCE_LITERALS;

    static Diagnostic create_BINARY_OP_BOTH_OPERANDS_NULL(String operatorName) {
        String message = String.valueOf(operatorName) + " with operands 'null' is always zero";
        return new BasicDiagnostic(2, "", 0, message, null);
    }

    static Diagnostic create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO() {
        if (DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO == null) {
            DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO = new BasicDiagnostic(4, "", 1, "Possible division by zero", null);
        }
        return DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO;
    }

    static Diagnostic create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(String operatorName) {
        String message = "Could not make numeric conversion for " + operatorName + " operation";
        return new BasicDiagnostic(4, "", 2, message, null);
    }

    static Diagnostic create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(String operatorName, String value) {
        String message = "This " + operatorName + " will always result a value of " + value;
        return new BasicDiagnostic(2, "", 3, message, null);
    }

    static Diagnostic create_BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME(String value) {
        String message = "Comparisons with null always evaluates to " + value;
        return new BasicDiagnostic(2, "", 4, message, null);
    }

    static Diagnostic create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN(String whichArgument) {
        String message = "Cannot coerce " + whichArgument + " argument to boolean";
        return new BasicDiagnostic(4, "", 5, message, null);
    }

    static Diagnostic create_BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS(boolean shortCircuitValue, String operatorName) {
        String message = "The first boolean argument is always " + shortCircuitValue + ".  The second argument will never be evaluated and the " + operatorName + " to boolean will always evaluate to" + shortCircuitValue;
        return new BasicDiagnostic(2, "", 6, message, null);
    }

    static Diagnostic create_BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME(boolean shortCircuitValue, String operatorName) {
        String message = "The second boolean argument is always" + shortCircuitValue + ".  The " + operatorName + " will always evaluate to " + shortCircuitValue;
        return new BasicDiagnostic(2, "", 7, message, null);
    }

    static Diagnostic create_BINARY_OP_NO_AVAILABLE_TYPE_COERCION() {
        if (DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION == null) {
            DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION = new BasicDiagnostic(4, "", 8, "Cannot coerce arguments for this operator", null);
        }
        return DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION;
    }

    static Diagnostic create_BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS() {
        if (DIAGNOSTIC_COULD_NOT_COERCE_LITERALS == null) {
            DIAGNOSTIC_COULD_NOT_COERCE_LITERALS = new BasicDiagnostic(4, "", 9, "Could not coerce literals to numbers", null);
        }
        return DIAGNOSTIC_COULD_NOT_COERCE_LITERALS;
    }

    static Diagnostic create_UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID(String operatorName, String value) {
        String message = "This " + operatorName + " will always result a value of " + value;
        return new BasicDiagnostic(2, "", 10, message, null);
    }

    static Diagnostic create_UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE() {
        return new BasicDiagnostic(2, "", 11, "This empty expression always evaluates to false.  Only string, maps, arrays and collection are derive meaningful values for empty operator", null);
    }

    static Diagnostic create_UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO() {
        return new BasicDiagnostic(2, "", 12, "Unary minus applied to null is always zero", null);
    }

    static Diagnostic create_UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(String operatorName) {
        String message = "Could not make numeric conversion for " + operatorName + " operation";
        return new BasicDiagnostic(4, "", 13, message, null);
    }

    static Diagnostic create_UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED(String operatorName, String type) {
        return new BasicDiagnostic(2, "", 0, "Type coercion for " + operatorName + " operator not guaranteed for possible runtime types: " + type, null);
    }

    static Diagnostic create_UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN() {
        return new BasicDiagnostic(4, "", 14, "Not operator does not support type coercion. ", null);
    }

    static Diagnostic create_TERNARY_OP_CHOICE_IS_ALWAYS_SAME(boolean result, String whichSelected) {
        return new BasicDiagnostic(2, "", 15, "Choice argument is always " + result + ".  " + whichSelected + " argument is always returned", null);
    }

    static Diagnostic create_TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN() {
        return new BasicDiagnostic(4, "", 16, "Could not coerce choice argument to boolean", null);
    }

    private DiagnosticFactory() {
    }
}

