/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.Assert;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldResources;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DialogFieldBase
implements DialogField {
    private Label label = null;
    private Label requiredLabel = null;
    protected String labelText = "";
    private IDialogFieldChangeListener dialogFieldChangeListener;
    private IDialogFieldApplyListener dialogFieldApplyListener;
    private boolean enabled = true;
    private FontMetrics fontMetrics;
    private IHyperlinkListener listener;
    private Hyperlink hyperlink = null;
    private Map attachedData;
    private boolean isRequired;

    public void setHyperLink(IHyperlinkListener listener) {
        if (this.label != null) {
            throw new RuntimeException("The Label instance does not support the listener");
        }
        this.listener = listener;
    }

    public void setLabelText(String labeltext) {
        String string = this.labelText = labeltext == null ? "" : labeltext;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.labelText);
        } else if (this.hyperlink != null && !this.hyperlink.isDisposed()) {
            this.hyperlink.setText(this.labelText);
        }
    }

    protected Shell getShell() {
        if (this.label != null && !this.label.isDisposed()) {
            return this.label.getShell();
        }
        if (this.hyperlink != null && !this.hyperlink.isDisposed()) {
            return this.hyperlink.getShell();
        }
        return null;
    }

    public final void setDialogFieldChangeListener(IDialogFieldChangeListener listener) {
        this.dialogFieldChangeListener = listener;
    }

    public final void setDialogFieldApplyListener(IDialogFieldApplyListener listener) {
        this.dialogFieldApplyListener = listener;
    }

    public void dialogFieldChangedAndApplied() {
        if (this.dialogFieldChangeListener != null) {
            this.dialogFieldChangeListener.dialogFieldChanged(this);
        }
        if (this.dialogFieldApplyListener != null) {
            this.dialogFieldApplyListener.dialogFieldApplied(this);
        }
    }

    public void dialogFieldChanged() {
        if (this.dialogFieldChangeListener != null) {
            this.dialogFieldChangeListener.dialogFieldChanged(this);
        }
    }

    public void dialogFieldApplied() {
        if (this.dialogFieldApplyListener != null) {
            this.dialogFieldApplyListener.dialogFieldApplied(this);
        }
    }

    public boolean setFocus() {
        return false;
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)DialogFieldBase.gridDataForLabel(nColumns));
        return new Control[]{label};
    }

    protected FontMetrics getDialogUnits(Control control) {
        if (this.fontMetrics == null) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.fontMetrics = gc.getFontMetrics();
            gc.dispose();
        }
        return this.fontMetrics;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    public Control getLabelControl(FormToolkit _formToolkit, Composite parent) {
        Object control = null;
        if (this.label == null && this.hyperlink == null) {
            this.assertCompositeNotNull(parent);
            String label = null;
            label = this.labelText != null && !"".equals(this.labelText) ? this.labelText : ".";
            control = this.listener == null ? this.createLabel(_formToolkit, parent, label) : this.createHyperlink(_formToolkit, parent, label);
            control.setFont(parent.getFont());
            control.setEnabled(this.enabled);
        } else {
            control = this.label != null ? this.label : this.hyperlink;
        }
        return control;
    }

    public Control getRequiredLabelControl(FormToolkit _formToolkit, Composite parent) {
        if (this.requiredLabel == null) {
            if (_formToolkit == null) {
                this.requiredLabel = new Label(parent, 16448);
            } else {
                this.requiredLabel = _formToolkit.createLabel(parent, "", 16448);
                this.requiredLabel.setForeground(this.getLabelColor());
            }
            if (this.isRequired) {
                this.requiredLabel.setText(DialogFieldResources.getInstance().getString("DialogFieldBase.Label.RequiredSymbol"));
            }
        }
        return this.requiredLabel;
    }

    private Control createLabel(FormToolkit _formToolkit, Composite parent, String labelString) {
        if (_formToolkit == null) {
            this.label = new Label(parent, 16448);
            this.label.setText(labelString);
        } else {
            this.label = _formToolkit.createLabel(parent, labelString, 16448);
            this.label.setForeground(this.getLabelColor());
        }
        return this.label;
    }

    private Color getLabelColor() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.startsWith("mac os")) {
            return Display.getCurrent().getSystemColor(24);
        }
        return Display.getCurrent().getSystemColor(26);
    }

    private Control createHyperlink(FormToolkit _formToolkit, Composite parent, String label) {
        if (_formToolkit == null) {
            this.hyperlink = new Hyperlink(parent, 16448);
            this.hyperlink.setForeground(this.getLabelColor());
            this.hyperlink.setUnderlined(true);
            this.hyperlink.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    DialogFieldBase.this.hyperlink.setForeground(Display.getCurrent().getSystemColor(9));
                }

                public void mouseExit(MouseEvent e) {
                    DialogFieldBase.this.hyperlink.setForeground(DialogFieldBase.this.getLabelColor());
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            this.hyperlink.setText(label);
        } else {
            this.hyperlink = _formToolkit.createHyperlink(parent, label, 16448);
        }
        this.hyperlink.addHyperlinkListener(this.listener);
        return this.hyperlink;
    }

    public Control createEmptySpace(FormToolkit toolkit, Composite parent) {
        return this.createEmptySpace(toolkit, parent, 1);
    }

    public Control createEmptySpace(FormToolkit toolkit, Composite parent, int span) {
        Label label = toolkit != null ? toolkit.createLabel(parent, "") : new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.updateEnableState();
        }
    }

    protected void updateEnableState() {
        if (this.label != null) {
            this.label.setEnabled(this.enabled);
        }
        if (this.hyperlink != null) {
            this.hyperlink.setEnabled(this.enabled);
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    public Object getAttachedData(Object key) {
        if (this.attachedData != null) {
            return this.attachedData.get(key);
        }
        return null;
    }

    public void putAttachedData(Object key, Object value) {
        if (this.attachedData == null) {
            this.attachedData = new HashMap();
        }
        this.attachedData.put(key, value);
    }

    public void handleGrabHorizontal() {
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }
}

