/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLDBUtils;

public class SQLDBProposalsService
implements ISQLDBProposalsService {
    protected static int PROPOSAL_TYPE_INVALID = -1;
    protected static int PROPOSAL_TYPE_TABLES = 1;
    protected static int PROPOSAL_TYPE_COLUMNS = 2;
    private ConnectionInfo fConnInfo;
    private String fDBName;
    private List fDBProposalList;
    private String fImpliedSchemaName;
    private List fTokenList;

    public SQLDBProposalsService(ConnectionInfo connInfo) {
        this(connInfo, null);
    }

    public SQLDBProposalsService(ConnectionInfo connInfo, String schemaName) {
        this.fConnInfo = connInfo;
        this.fDBName = this.fConnInfo.getDatabaseName();
        this.fDBProposalList = new ArrayList();
        this.fImpliedSchemaName = schemaName;
        this.fTokenList = null;
    }

    protected int determineProposalType(List tokenList) {
        int proposalType = PROPOSAL_TYPE_INVALID;
        if (tokenList.size() == 1) {
            proposalType = this.fImpliedSchemaName == null ? PROPOSAL_TYPE_TABLES : PROPOSAL_TYPE_TABLES | PROPOSAL_TYPE_COLUMNS;
        } else if (tokenList.size() == 2) {
            proposalType = PROPOSAL_TYPE_COLUMNS;
        }
        return proposalType;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public String getDatabaseName() {
        return this.fDBName;
    }

    public List getDBProposals() {
        return this.fDBProposalList;
    }

    protected Schema getSchema(Database database, String schemaName) {
        EList schemaList = database.getSchemas();
        Schema schema = null;
        int i = 0;
        while (i < schemaList.size()) {
            Schema thisSchema = (Schema)schemaList.get(i);
            if (thisSchema.getName().equalsIgnoreCase(schemaName)) {
                schema = thisSchema;
                break;
            }
            ++i;
        }
        return schema;
    }

    public String getSchemaName() {
        return this.fImpliedSchemaName;
    }

    public List getTokenList() {
        return this.fTokenList;
    }

    protected void loadColumns(Table table) {
        this.loadColumns(table, true);
    }

    protected void loadColumns(Table table, boolean clear) {
        if (table != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList columns = table.getColumns();
            int j = 0;
            while (j < columns.size()) {
                Column column = (Column)columns.get(j);
                this.fDBProposalList.add(new SQLDBProposal((EObject)column));
                ++j;
            }
        }
    }

    protected void loadDBProposals(List tokenList) {
        Database db = this.fConnInfo.getSharedDatabase();
        this.fDBProposalList.clear();
        if (db != null) {
            int proposalsType = this.determineProposalType(tokenList);
            Schema schema = this.getSchema(db, (String)tokenList.get(0));
            if ((proposalsType & PROPOSAL_TYPE_TABLES) == PROPOSAL_TYPE_TABLES) {
                this.loadTables(schema, false);
            }
            if ((proposalsType & PROPOSAL_TYPE_COLUMNS) == PROPOSAL_TYPE_COLUMNS) {
                String tableToken = null;
                if (tokenList.size() == 1 && this.fImpliedSchemaName != null) {
                    schema = this.getSchema(db, this.fImpliedSchemaName);
                    tableToken = (String)tokenList.get(0);
                } else if (tokenList.size() >= 0) {
                    tableToken = (String)tokenList.get(1);
                }
                if (tableToken != null && tableToken.trim().length() > 0) {
                    Table table = null;
                    EList tables = schema.getTables();
                    int i = 0;
                    while (i < tables.size()) {
                        table = (Table)tables.get(i);
                        this.loadColumns(table, false);
                        ++i;
                    }
                }
            }
        }
    }

    protected void loadTables(Schema schema) {
        this.loadTables(schema, true);
    }

    protected void loadTables(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList tables = schema.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table table = (Table)tables.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)table));
                ++i;
            }
        }
    }

    public boolean populate(List tokenList) {
        ConnectionInfo connInfo;
        boolean connected;
        boolean loaded = false;
        if (tokenList.size() > 0 && (connected = SQLDBUtils.reestablishConnection(connInfo = this.getConnectionInfo()))) {
            loaded = true;
            this.fTokenList = tokenList;
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        List tknList = SQLDBProposalsService.this.getTokenList();
                        SQLDBProposalsService.this.loadDBProposals(tknList);
                    }
                }, null);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return loaded;
    }

    public void setSchemaName(String schemaName) {
        this.fImpliedSchemaName = schemaName != null && schemaName.trim().length() > 0 ? schemaName : null;
    }
}

