/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorPlugin;

public class SQLEditorResources {
    private static final String RESOURCE_BUNDLE = "org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources";
    private static ResourceBundle fgResourceBundle;

    private SQLEditorResources() {
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = SQLEditorPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = null;
            try {
                URL baseURL = SQLEditorPlugin.getDefault().getBundle().getEntry("/");
                URL imageURL = new URL(baseURL, "icons" + File.separator + key + ".gif");
                descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            }
            catch (Exception exception) {}
            if (descriptor != null) {
                imageRegistry.put(key, descriptor);
                image = imageRegistry.get(key);
            }
        }
        return image;
    }

    public static String getString(String key) {
        String str = null;
        ResourceBundle bundle = SQLEditorResources.getResourceBundle();
        try {
            str = bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            str = "!" + key + "!";
        }
        return str;
    }

    public static String getString(String key, Object[] substitutions) {
        String str = SQLEditorResources.getString(key);
        if (substitutions != null) {
            str = MessageFormat.format(str, substitutions);
        }
        return str;
    }

    public static ResourceBundle getResourceBundle() {
        if (fgResourceBundle == null) {
            try {
                fgResourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
            }
            catch (MissingResourceException missingResourceException) {
                fgResourceBundle = null;
            }
        }
        return fgResourceBundle;
    }
}

