/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.ui.internal.ImageResource;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTableLabelProvider;

public class ServerClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage {
    protected IClasspathEntry selection;
    protected Map runtimeMap = new HashMap();

    public ServerClasspathContainerPage() {
        super("server.container");
        this.setImageDescriptor(ImageResource.getImageDescriptor("wiz_runtimeType"));
        this.setTitle(Messages.classpathContainer);
        this.setDescription(Messages.classpathContainerDescription);
        this.setPageComplete(false);
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider((IRuntimeType)runtimes[i].getRuntimeType());
            if (rcpw != null) {
                IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(runtimes[i].getId());
                this.runtimeMap.put(runtimes[i], JavaCore.newContainerEntry((IPath)serverContainerPath));
            }
            ++i;
        }
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.selection;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.selection = containerEntry;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.classpathContainerRuntimeList);
        Table table = new Table(comp, 68356);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(false);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] obj = ServerClasspathContainerPage.this.runtimeMap.keySet().toArray();
                return obj;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new RuntimeTableLabelProvider());
        tableViewer.setInput((Object)"root");
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ServerClasspathContainerPage.this.selection = (IClasspathEntry)ServerClasspathContainerPage.this.runtimeMap.get(sel.getFirstElement());
                    ServerClasspathContainerPage.this.setPageComplete(true);
                }
                catch (Exception exception) {
                    ServerClasspathContainerPage.this.selection = null;
                    ServerClasspathContainerPage.this.setPageComplete(false);
                }
            }
        });
        this.setControl((Control)comp);
    }
}

