/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.common;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.wst.command.internal.env.core.data.BeanModifier;

public class JavaWSDLParamModifier
implements BeanModifier {
    public void modify(Object bean, Object propertyHolder) {
        JavaWSDLParameter javaWSDLParam = bean != null ? (JavaWSDLParameter)bean : new JavaWSDLParameter();
        if (propertyHolder instanceof Map) {
            Map propertyMap = (Map)propertyHolder;
            if (propertyMap.containsKey("Use")) {
                javaWSDLParam.setUse((String)propertyMap.get("Use"));
            }
            if (propertyMap.containsKey("Style")) {
                javaWSDLParam.setStyle((String)propertyMap.get("Style"));
            }
            if (propertyMap.containsKey("JavaOutput")) {
                javaWSDLParam.setJavaOutput((String)propertyMap.get("JavaOutput"));
            }
            if (propertyMap.containsKey("Methods")) {
                String methodList = (String)propertyMap.get("Methods");
                StringTokenizer tok = new StringTokenizer(methodList, " ");
                Hashtable<String, Boolean> methods = new Hashtable<String, Boolean>();
                while (tok.hasMoreTokens()) {
                    methods.put(tok.nextToken(), new Boolean(true));
                }
                javaWSDLParam.setMethods(methods);
            }
            if (propertyMap.containsKey("Mappings")) {
                String filename = (String)propertyMap.get("Mappings");
                HashMap mappings = this.readMappingsFromFile(filename);
                javaWSDLParam.setMappings(mappings);
            }
        }
    }

    private HashMap readMappingsFromFile(String filename) {
        HashMap<Object, Object> hashmap = new HashMap<Object, Object>();
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename));
        if (resource != null) {
            try {
                Properties props = new Properties();
                props.load(resource.getContents());
                hashmap.putAll(props);
            }
            catch (Exception exception) {}
        }
        return hashmap;
    }
}

