/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CopyWebServiceUtilsJarCommand
extends AbstractDataModelOperation {
    private String sampleProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_COPY_WEBSERVICE_UTILS);
            IProject sampleIProject = ProjectUtilities.getProject((String)this.sampleProject);
            IPath webModulePath = J2EEUtils.getWebContentPath((IProject)sampleIProject);
            if (webModulePath == null) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PROJECT_NOT_FOUND);
            }
            IStatus status = this.copyIFile("webserviceutils.jar", webModulePath, "WEB-INF/lib/webserviceutils.jar", (Plugin)WebServiceConsumptionPlugin.getInstance(), env, monitor);
            if (status.getSeverity() == 4) {
                IStatusHandler sHandler = env.getStatusHandler();
                IStatus errorStatus = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_FILECOPY_WEBSERVICE_UTILS);
                sHandler.reportError(errorStatus);
                return status;
            }
        }
        catch (Exception e) {
            IStatusHandler sHandler = env.getStatusHandler();
            IStatus errorStatus = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_FILECOPY_WEBSERVICE_UTILS);
            sHandler.reportError(errorStatus);
            return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_FILECOPY_WEBSERVICE_UTILS, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private IStatus copyIFile(String source, IPath targetPath, String targetFile, Plugin plugin, IEnvironment env, IProgressMonitor monitor) {
        if (plugin != null) {
            IPath target = targetPath.append((IPath)new Path(targetFile));
            ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_COPYING_FILE);
            try {
                TransientResourceContext context = new TransientResourceContext();
                context.setOverwriteFilesEnabled(true);
                context.setCreateFoldersEnabled(true);
                context.setCheckoutFilesEnabled(true);
                IResource resource = FileResourceUtils.findResource((IPath)target);
                if (resource != null) {
                    return Status.OK_STATUS;
                }
                FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)plugin.openStream((IPath)new Path(source)), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
            }
            catch (Exception e) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_FILECOPY_WEBSERVICE_UTILS, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }
}

